Name: git-update-index-keeping-only
Version: 0.3
Release: alt1

Summary: rm all but matching files from Git index. (Helps git-filter-branch.)

# Licensed as Git itself, but later licenses are allowed, too.
License: %gpl2plus
BuildRequires(pre): rpm-build-licenses
Group: Development/Other
Url: http://git.altlinux.org/people/imz/packages/git-update-index-keeping-only.git

Packager: Ivan Zakharyaschev <imz@altlinux.org>

Source1: git-update-index-keeping-only
Source2: git-filter-only-files
Source3: git-ls-paths-modified-since

BuildPreReq: /bin/bash4
BuildArch: noarch

%description
git-update-index-keeping-only
- A simple executable script that removes all but matching files from
  Git index. It is a useful helper for git-filter-branch --index-filter
  (for convenience, git-filter-only-files script is included). It is
  implemented on top of git-rm. It takes the list of files to keep on stdin.

git-filter-only-files OLD_COMMIT NEW_BRANCH
- A wrapper around git-filter-branch to rewrite history so that only
  some specified files are kept.

git-ls-paths-modified-since SINCE CURRENT_COMMIT
- A helper to list the files modified or added in the diff between
  2 commits (SINCE and CURRENT_COMMIT).

Example of usage:

FILES="$(git-ls-paths-modified-since SINCE)"
export FILES
git filter-branch \
   --index-filter 'echo "$FILES" | git-update-index-keeping-only -q'

or simply:

git-ls-paths-modified-since SINCE | git-filter-only-files HEAD NEW_BRANCH

%install
mkdir -p %buildroot%_bindir
install -m0755 %SOURCE1 %SOURCE2 %SOURCE3 -t %buildroot%_bindir/

%files
%_bindir/*

%changelog
