Name: git-cola
Version: 4.16.1
Release: alt1

Summary: A highly caffeinated git gui
License: GPL-2.0-or-later
Group: Development/Tools

Url: https://git-cola.github.io
Vcs: https://github.com/git-cola/git-cola
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3 python3-module-sphinx-devel rsync
# Automatically added by buildreq on Mon Aug 11 2025
# optimized out: ca-trust libdouble-conversion3 libgpg-error libp11-kit libqt6-core libqt6-dbus libqt6-gui libqt6-network libqt6-opengl libqt6-openglwidgets libqt6-widgets libsasl2-3 openssl-config python-sphinx-objects.inv python3 python3-base python3-dev python3-module-PyQt6-sip python3-module-Pygments python3-module-alabaster python3-module-babel python3-module-charset-normalizer python3-module-docutils python3-module-idna python3-module-imagesize python3-module-jaraco.context python3-module-jaraco.functools python3-module-jaraco.text python3-module-jinja2 python3-module-markupsafe python3-module-more-itertools python3-module-packaging python3-module-pkg_resources python3-module-py3dephell python3-module-requests python3-module-roman_numerals python3-module-snowballstemmer python3-module-sphinx python3-module-urllib3 python3-module-wheel sh5 xz
BuildRequires: python3-module-PyQt6-devel python3-module-pyproject-installer python3-module-qtpy python3-module-setuptools python3-module-sphinx-sphinx-build-symlink python3-module-sphinxcontrib-applehelp python3-module-sphinxcontrib-devhelp python3-module-sphinxcontrib-htmlhelp python3-module-sphinxcontrib-qthelp python3-module-sphinxcontrib-serializinghtml
# hasher tests:
Requires: python3-module-pyinotify python3-module-PyQt6 git-core

%description
A sweet, carbonated git gui known for its sugary flavour
and caffeine-inspired features.

%package -n bash-completion-%name
Summary: Bash completion for %name
Group: Shells
BuildArch: noarch

%description -n bash-completion-%name
The official bash completion script for %name.

%package -n zsh-completion-%name
Summary: Zsh completion for %name
Group: Shells
BuildArch: noarch

%description -n zsh-completion-%name
The official zsh completion script for %name.

%prep
%setup
%patch -p1
%prepare_sphinx3 share/doc/%name
sed -i '/Git Cola version/s/%%(cola_version)s/%{version}/' \
  cola/widgets/about.py
sed -i '/prefix =/s|\$(HOME)|%_prefix|' Makefile

%build
%pyproject_build
%make_build doc man
%ifnarch aarch64 ppc64le
%make_build html
%endif

%install
export DESTDIR=%buildroot
%pyproject_install
%make_install \
  install-desktop-files \
  install-icons \
  install-htmldocs \
  install-metainfo \
  install-doc \
%ifnarch aarch64 ppc64le
  install-html \
%endif
  install-man

# zsh and bash
install -Dm644 contrib/_%{name} -t %buildroot%_datadir/zsh/site-functions/
install -Dm644 contrib/%name-completion.bash %buildroot%_datadir/bash-completion/completions/%name

# executable script is not executable
chmod +x %buildroot%python3_sitelibdir/cola/bin/ssh-askpass
chmod +x %buildroot%python3_sitelibdir/cola/bin/ssh-askpass-darwin

%find_lang %name

%files -f %name.lang
%doc CHANGES.rst CONTRIBUTING.md LICENSE README.md
%_bindir/*
%_desktopdir/*.desktop
%_docdir/git-cola
%_iconsdir/hicolor/scalable/apps/git-cola.svg
%_datadir/metainfo/git-*.appdata.xml
%_man1dir/git-*.1.xz
%python3_sitelibdir/*

%files -n bash-completion-%name
%_datadir/bash-completion/completions/%name

%files -n zsh-completion-%name
%_datadir/zsh/site-functions/_%{name}

%changelog
