%def_without bootstrap

%define build_ghc_version 9.6.7
%define ghc_major 9.6
%define _ghclibdir %_libdir/ghc-%version

# Bootstrap with the previous version
%if_with bootstrap
    %define with_major 9.2
%else
    %define with_major 9.6
%endif

%global build_flavour perf+debug_info

%global elf_methods unresolved=relaxed
%ifarch i586
    %global elf_methods %{?elf_methods} textrel=relaxed
%endif
%set_verify_elf_method %elf_methods

%def_with docs

Name: ghc%ghc_major
Version: %build_ghc_version
Release: alt1

Epoch: 1

Summary: Glasgow Haskell Compilation system
License: BSD-3-Clause and HaskellReport
Group: Development/Haskell
Url: http://haskell.org/ghc/

Source: %name-%version.tar

# %%ghc_version here from ghc%%with_major-devel
Source1: bootstrap-sources-%ghc_version.tar.gz
Source2: ghc.macros
Source3: ghc.env
Source10: get_libs_versions.sh

# Patches from 10 to 20 is for doc generation
Patch15: ghc9.2-alt-docs_disable_failing_on_undefined_reference.patch

Patch20: ghc9.0-debian-no_missing_haddock_file_warning.patch

Requires: libffi-devel libgmp-devel

# <https://bugzilla.altlinux.org/show_bug.cgi?id=31576>:
Requires: glibc-gconv-modules

# The installed Haskell libs will be processed:
Requires(pre,postun): haskell-filetrigger

# For ghc-pkg with rpath running during install, see:
# https://www.altlinux.org/Hasher/FAQ
# https://lists.altlinux.org/pipermail/devel/2018-April/204171.html
# Not needed after rebuild with separate single directory for shared libraries
BuildRequires: /proc

# (Pre) here to provide correct %%ghc_version for source1
BuildRequires(Pre): ghc%with_major-devel
BuildRequires: gcc-c++

# Macroses needed for libs subpackages
# (Pre) here to remove annoying warnings
BuildRequires(Pre): rpm-build-haskell-extra

BuildRequires: binutils-devel docbook-dtds docbook-style-xsl libelf-devel libffi-devel libgmp-devel libncurses-devel xsltproc

# Needs for build man
BuildRequires: python3-module-sphinx-sphinx-build-symlink

BuildRequires: alex
BuildRequires: happy

# Needs for setting correct RPATH
BuildRequires: patchelf

Provides: haskell(abi) = %version

%description
Haskell is a standard lazy functional programming language; the
current language version is Haskell 98, agreed in December 1998.

GHC is a state-of-the-art programming suite for Haskell.  Included is
an optimising compiler generating good code for a variety of
platforms, together with an interactive system for convenient, quick
development.  The distribution includes space and time profiling
facilities, a large collection of libraries, and support for various
language extensions, including concurrency, exceptions, and foreign
language interfaces (C, C++, whatever).

A wide variety of Haskell related resources (tutorials, libraries,
specifications, documentation, compilers, interpreters, references,
contact information, links to research groups) are available from the
Haskell home page at <http://www.haskell.org/>.

%package common
Summary: Selects the default version of Glasgow Haskell Compilation system
Group: Development/Haskell

Requires: %name = %EVR
Requires: rpm-macros-%{name}-common = %EVR

%description common
Install this package to select %version as the default version
of Glasgow Haskell Compiler.

It will make rpm-build-haskell use this version of GHC for
building other Haskell packages
(if their .spec refers to %%build_ghc_version and %%_ghclibdir).

%package -n rpm-macros-%{name}-common
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other

Provides: rpm-macros-ghc-common = %EVR
Conflicts: rpm-macros-ghc-common < %EVR
Conflicts: rpm-macros-ghc-common > %EVR

%description -n rpm-macros-%{name}-common
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%package doc
Summary: Documentation for GHC
Group: Development/Haskell

%description doc
Preformatted documentation for the Glasgow Haskell Compiler
(GHC) and its libraries. Install it if you like to have local
access to the documentation in PostScript and HTML format.
Alternatively, the documentation is available online at
http://haskell.org/ghc/documentation.html

%package doc-index
Summary: GHC library documentation indexing
Group: Development/Haskell

BuildArch: noarch

%description doc-index
The package enables re-indexing of installed library documention.

# Generated by get_libs_subpackages.sh
# Each standart library separated to subpackages (devel and runtime)
%define basepkg_version 4.18.3.0
%ghc_lib_subpackage -n array -v 0.5.8.0
%ghc_lib_subpackage -n base -v 4.18.3.0
%ghc_lib_subpackage -n binary -v 0.8.9.1
%ghc_lib_subpackage -n bytestring -v 0.11.5.4
%ghc_lib_subpackage -n Cabal-syntax -v 3.10.3.0
%ghc_lib_subpackage -n Cabal -v 3.10.3.0
%ghc_lib_subpackage -n containers -v 0.6.7
%ghc_lib_subpackage -n deepseq -v 1.4.8.1
%ghc_lib_subpackage -n directory -v 1.3.8.5
%ghc_lib_subpackage -n exceptions -v 0.10.7
%ghc_lib_subpackage -n filepath -v 1.4.301.0
%ghc_lib_subpackage -n ghc-bignum -v 1.3
%ghc_lib_subpackage -n ghc-boot-th -v 9.6.7
%ghc_lib_subpackage -n ghc-boot -v 9.6.7
%ghc_lib_subpackage -n ghc-compact -v 0.1.0.0
%ghc_lib_subpackage -n ghc-heap -v 9.6.7
%ghc_lib_subpackage -n ghci -v 9.6.7
%ghc_lib_subpackage -n ghc-prim -v 0.10.0
%ghc_lib_subpackage -n haskeline -v 0.8.2.1
%ghc_lib_subpackage -n hpc -v 0.6.2.0
%ghc_lib_subpackage -n integer-gmp -v 1.1
%ghc_lib_subpackage -n libiserv -v 9.6.7
%ghc_lib_subpackage -n mtl -v 2.3.1
%ghc_lib_subpackage -n parsec -v 3.1.16.1
%ghc_lib_subpackage -n pretty -v 1.1.3.6
%ghc_lib_subpackage -n process -v 1.6.19.0
%ghc_lib_subpackage -n stm -v 2.5.1.0
%ghc_lib_subpackage -n template-haskell -v 2.20.0.0
%ghc_lib_subpackage -n terminfo -v 0.4.1.6
%ghc_lib_subpackage -n text -v 2.0.2
%ghc_lib_subpackage -n time -v 1.12.2
%ghc_lib_subpackage -n transformers -v 0.6.1.0
%ghc_lib_subpackage -n ucd2haskell -v 0.3.0
%ghc_lib_subpackage -n unix -v 2.8.6.0
%ghc_lib_subpackage -n xhtml -v 3000.2.2.1

# Added manually
%ghc_lib_subpackage -n ghc -v %build_ghc_version

%package devel
Summary: GHC development libraries meta package
Version: %build_ghc_version
Group: Development/Haskell

Requires: %name = %EVR
Requires: %name-common = %EVR
Requires: %ghc_devel_subpackages_list

%description devel
This is a meta-package for all the development library packages in GHC

%prep
%setup

%patch15 -p1

%patch20 -p1

# https://github.com/haskell/directory/pull/184
rm libraries/directory/directory.buildinfo

%build
#Set target x86_64-unknown-linux
%define _configure_target %nil

# Fixed internal error in haddock (see git log d5b703f for details)
export LANG=en_US.UTF-8

# Building hadrian
python3 hadrian/bootstrap/bootstrap.py -s %SOURCE1

# Specify LD directrly
# Mainly needed for aarch64 build
# See git log 9349778 for details
export LD=ld.gold

# Building using hadrian
# bindist is almost not documented option
# So you'll have to trust that I'm doing it right
./boot.source
%configure --with-system-libffi --disable-unregisterised --disable-ld-override
_build/bin/hadrian %_smp_mflags -V --docs=no-sphinx-pdfs --flavour=%build_flavour binary-dist-dir

%install
# Installing using hadrian
# bindist dir looks like _build/bindist/ghc-%%build_ghc_version-{Target_Triplet}
pushd _build/bindist/ghc-%build_ghc_version-*
%configure
%makeinstall_std
popd

%define docdir %_docdir/ghc-%version
GHC_PKGDIR=$(find %buildroot%_ghclibdir/lib/ -maxdepth 1 -name "*ghc-%build_ghc_version" -printf "%%f")

# generate fake .pkg configs for core packages.
# haskell.prov will convert them to package provides.
ghc_create_lib_pkgfile() {
        lib="$1"
        pkgid="$(basename "$lib")"
        name="$(echo $pkgid | sed 's|-[0-9.]*$||')"
        version="$(echo $pkgid | awk -F - '{print $NF}')"
        echo -e "name: $name\nversion: $version" > "$lib/$name.pkg"
}
export -f ghc_create_lib_pkgfile
find "%buildroot%_ghclibdir/lib/$GHC_PKGDIR" -mindepth 1 -maxdepth 1 -type d \
                                  | xargs -n 1 sh -e -c 'ghc_create_lib_pkgfile $@' \
                                                         ghc_create_lib_pkgfile

cp -a LICENSE README.md %buildroot%docdir/

# touch our "ghost". ghc-pkg may create him later.
touch %buildroot%_ghclibdir/lib/package.conf.old

# Adding directory with dynamic libraries for ld
mkdir -p %buildroot%_sysconfdir/ld.so.conf.d
echo "%_ghclibdir/lib/$GHC_PKGDIR" > %buildroot%_sysconfdir/ld.so.conf.d/ghc-%version.conf

# Moving man to man_dir from bindist
mkdir -p %buildroot%_man1dir
mv %buildroot%docdir/users_guide/build-man/ghc.1 %buildroot%_man1dir/ghc-%build_ghc_version.1
rm %buildroot%_man1dir/ghc.1
rm -rf --dir %buildroot%docdir/users_guide

# Moving html doc in old ALT style
mv -t %buildroot%docdir %buildroot%docdir/html/*
rmdir %buildroot%docdir/html

# Cleaning package.conf.d from .conf.copy files
# They coincide with non-copy entirely
find %buildroot%_ghclibdir -name "*.conf.copy" -delete

# Setting in conf.d correct path to html documentation
find %buildroot%_ghclibdir -name "*.conf" | xargs sed -i 's!/html/!/!'

# Generate file lists for all subpackages
# expands to %%ghc_gen_filelist {NAME} {VERSION} for each package
# SOURCE10 means get_libs_versions.sh
%SOURCE10 %build_ghc_version | xargs -n 2 %ghc_gen_filelist
%ghc_gen_filelist ghc %version

# Adding rts lib to base package
find "%buildroot%_ghclibdir" -name "*rts*.so" \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.runtime

find "%buildroot%_ghclibdir" -name "rts*.conf" \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.devel

find "%buildroot%_ghclibdir" -name "rts-*" -type d \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.devel

find "%buildroot%_ghclibdir" -name "*system-cxx-std-lib*.conf" \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.devel

# Searching for RTS .so File
# There are many different RTS environments
# (Cartesian product of debug/non-debug and threaded/non-threaded)
# We search for a non-debug and non-threaded environment for preload
# See the git log 97b13aa2 for details
RTS_SO=$(find "%buildroot%_ghclibdir" -name "libHSrts-*[0-9]-ghc%build_ghc_version.so" \
                 | sed "s|%buildroot||g" | head -n 1)

# install and fix up the macros file
mkdir -p %buildroot%_rpmmacrosdir
install %SOURCE2 %buildroot%_rpmmacrosdir/ghc
install %SOURCE3 %buildroot%_rpmmacrosdir/ghc.env

sed -i 's|@GHC_VERSION@|%version|' %buildroot%_rpmmacrosdir/ghc
sed -i "s|@GHC_RUNTIME@|$RTS_SO|"  %buildroot%_rpmmacrosdir/ghc

# For the correct way of ELF verification:
# ld by default doesn't recognize GHC libraries,
# because of incorrect RPATH in binaries.
# so we get errors and warnings.
# Manually setting rpath in binaries is the solution
find %buildroot%_ghclibdir/bin -type f | xargs -n 1 patchelf --set-rpath '$ORIGIN/../lib'"/$GHC_PKGDIR"

%files
%_ghclibdir/bin/*
%_ghclibdir/lib/bin/*
%_bindir/*-%version
%dir %_libdir/ghc-%version
%dir %docdir/
%dir %_ghclibdir/bin/
%_man1dir/ghc-%build_ghc_version.1*
%ghost %_ghclibdir/lib/package.conf.old
%dir %_ghclibdir/lib/package.conf.d
%dir %_ghclibdir/lib
%dir %_ghclibdir/lib/bin
%dir %_ghclibdir/lib/*-ghc-%build_ghc_version
%_ghclibdir/lib/package.conf.d/package.cache*
%_ghclibdir/lib/package.conf.d/.stamp
%_ghclibdir/lib/settings
%_ghclibdir/lib/template-hsc.h
%_ghclibdir/lib/ghc-usage.txt
%_ghclibdir/lib/ghci-usage.txt
%_ghclibdir/lib/llvm-passes
%_ghclibdir/lib/llvm-targets
%_ghclibdir/lib/html
%_ghclibdir/lib/latex
%_sysconfdir/ld.so.conf.d/ghc-%version.conf
%docdir/LICENSE
%docdir/README.md

%files common
%_bindir/*
%exclude %_bindir/*-%version

%files -n rpm-macros-%{name}-common
%_rpmmacrosdir/*

%files doc-index
%dir %docdir/libraries
%docdir/libraries/gen_contents_index
%docdir/libraries/*.html
%docdir/libraries/*.js
%docdir/libraries/*.css
%docdir/libraries/*.png
%docdir/libraries/*.txt

%files doc
%dir %docdir
%docdir/users_guide
%docdir/Haddock
%docdir/archives
%docdir/index.html

%files devel

%changelog
