Name: gerbv
Version: 2.10.0
Release: alt2

Summary: Gerber file viewer

Packager: Vitaly Lipatov <lav@altlinux.ru>

Url: https://github.com/gerbv/gerbv
License: GPLv2
Group: Graphics

# Source-url: https://github.com/gerbv/gerbv/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

BuildRequires: ImageMagick-tools
BuildRequires: gcc-c++ libgtk+2-devel libdxflib-devel
# needed for p10/c10/c9
BuildRequires: desktop-file-utils

%description
Gerber Viewer (gerbv) is a viewer for Gerber files. Gerber files
are generated from PCB CAD system and sent to PCB manufacturers
as basis for the manufacturing process. The standard supported
by gerbv is RS-274X.

gerbv also supports drill files. The format supported are known
under names as NC-drill or Excellon. The format is a bit undefined
and different EDA-vendors implement it different.

%package examples
Summary: Gerber file examples for gerbv
Requires: gerbv
Group: Graphics
BuildArch: noarch

%description examples
Example files for gerbv.


%package -n lib%name
Summary: %name library files
Group: Development/Other

%description -n lib%name
lib%name library.


%package -n lib%name-devel
Summary: Header files for lib%name
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
Header files for lib%name library.

%prep
%setup
subst 's|set -e||' utils/git-version-gen.sh

%build
%autoreconf
%configure --enable-dxf --disable-static
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_datadir/gerbv
cp -r example %buildroot%_datadir/gerbv
cp -r doc %buildroot%_datadir/gerbv

rm -f %buildroot%_desktopdir/*.cache

%find_lang %name

%files -f %name.lang
%dir %_datadir/gerbv
%dir %_datadir/gerbv/doc
%dir %_datadir/gerbv/scheme
%doc AUTHORS ChangeLog NEWS README
%_bindir/gerbv
%_man1dir/gerbv.*
%_datadir/gerbv/doc/*
%_datadir/gerbv/scheme/*.scm
%_datadir/glib-2.0/schemas/org.geda-user.gerbv.gschema.xml
%_datadir/gerbv/gerbv_icon.ico
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_pkgconfigdir/*.pc
%_includedir/%name-*/
%_libdir/*.so

%files examples
%dir %_datadir/gerbv/example
%_datadir/gerbv/example/*

%changelog
