%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname smart_proxy

Name:          gem-smart-proxy
Version:       3.13.0
Release:       alt1
Summary:       RESTful proxies for DNS, DHCP, TFTP, BMC and Puppet
License:       GPL-3.0
Group:         Development/Ruby
Url:           https://github.com/theforeman/smart-proxy
Vcs:           https://github.com/theforeman/smart-proxy.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Source1:       settings.yml
Source2:       smart-proxy.service
Source3:       smart-proxy.conf
Source4:       puppetca_http_api.yml
Source5:       Gemfile
Patch:         %name-%version-%release.patch
Patch1:        config.patch
Patch2:        config-path.patch
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(rake) >= 0
%if_enabled check
BuildRequires: gem(benchmark-ips) >= 0
BuildRequires: gem(ci_reporter) >= 1.6.3
BuildRequires: gem(concurrent-ruby) >= 1.0
BuildRequires: gem(facter) >= 0
BuildRequires: gem(json) >= 0
BuildRequires: gem(logging) >= 0
BuildRequires: gem(mocha) >= 1.10
BuildRequires: gem(pry) >= 0
BuildRequires: gem(rack) >= 1.3
BuildRequires: gem(rack-test) >= 0
BuildRequires: gem(rdoc) >= 0
BuildRequires: gem(rubocop) >= 1.56.0
BuildRequires: gem(rubocop-performance) >= 1.5.2
BuildRequires: gem(rubocop-rake) >= 0
BuildRequires: gem(sd_notify) >= 0.1
BuildRequires: gem(sinatra) >= 2.0
BuildRequires: gem(test-unit) >= 0
BuildRequires: gem(webmock) >= 0
BuildRequires: gem(webrick) >= 1.0
BuildConflicts: gem(ci_reporter) >= 3
BuildConflicts: gem(concurrent-ruby) >= 2
BuildConflicts: gem(mocha) >= 3
BuildConflicts: gem(rubocop) >= 2
BuildConflicts: gem(rubocop-performance) >= 2
BuildConflicts: gem(ruby-prof) >= 2
BuildConflicts: gem(sd_notify) >= 1
BuildConflicts: gem(sinatra) >= 5
BuildConflicts: gem(webrick) >= 2
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency rsec >= 1.0,rsec < 2
%ruby_use_gem_dependency rubocop-performance >= 1.11.3,rubocop-performance < 2
%ruby_use_gem_dependency rubocop >= 1.56,rubocop < 2
%ruby_use_gem_dependency ci_reporter >= 2.0.0,ci_reporter < 3
%ruby_use_gem_dependency mocha >= 2.7,mocha < 3
%ruby_use_gem_dependency sinatra >= 4.0,sinatra < 5
%ruby_use_gem_dependency ruby-prof >= 1.7,ruby-prof < 2
%ruby_alias_names smart_proxy,smart-proxy
Requires:      railsctl >= 1.0.1-alt1
Requires:      ruby >= 2.7
Requires:      gem(json) >= 0
Requires:      gem(logging) >= 0
Requires:      gem(rack) >= 1.3
Requires:      gem(sd_notify) >= 0.1
Requires:      gem(sinatra) >= 2.0
Requires:      gem(webrick) >= 1.0
Conflicts:     gem-smart-proxy-compat
Conflicts:     gem(sd_notify) >= 1
Conflicts:     gem(sinatra) >= 5
Conflicts:     gem(webrick) >= 2
Provides:      gem(smart_proxy) = 3.13.0

%ruby_use_gem_version smart_proxy:3.13.0

%description
Smart Proxy is a free open source project that provides restful API to
subsystems such as DNS, DHCP, etc, for higher level orchestration tools such as
Foreman.

Currently Supported modules:

* BMC - BMC management of devices supported by freeipmi and ipmitool
* DHCP - ISC DHCP and MS DHCP Servers
* DNS - Bind and MS DNS Servers
* Puppet - Any Puppet server from 0.24.x
* Puppet CA - Manage certificate signing, cleaning and autosign on a Puppet CA
  server
* Realm - Manage host registration to a realm (e.g. FreeIPA)
* TFTP - any UNIX based tftp server
* Facts - module to gather facts from facter (used only on discovered nodes)
* HTTPBoot - endpoint exposing a (TFTP) directory via HTTP(s) for UEFI HTTP
  booting
* Logs - log buffer of proxy logs for easier troubleshooting
* Templates - unattended Foreman endpoint proxy


%package       -n smart-proxy
Version:       3.13.0
Release:       alt1
Summary:       RESTful proxies for DNS, DHCP, TFTP, BMC and Puppet executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета smart_proxy
Group:         Other
BuildArch:     noarch

Requires:      gem(concurrent-ruby) >= 1.0
Requires:      gem(facter) >= 0
Requires:      gem(redfish_client) >= 0.6.0
Requires:      gem(rubyipmi) >= 0.10.0
Requires:      gem(rsec) >= 0
Requires:      gem(rb-inotify) >= 0
Requires:      gem(rb-kqueue) >= 0
Requires:      gem(logging-journald) >= 2.0
Requires:      gem(rkerberos) >= 0.1.1
Requires:      gem(gssapi) >= 0
Requires:      gem(ruby-libvirt) >= 0.6.0
Requires:      gem(jwt) >= 0
Requires:      gem(xmlrpc) >= 0.2
Requires:      gem(smart_proxy) = 3.13.0
Requires:      gem(smart_proxy_salt) >= 2.0
Requires:      gem(smart_proxy_dynflow) >= 0.5
Requires:      gem(smart_proxy_remote_execution_ssh) >= 0.4.1
Requires:      gem(smart_proxy_ansible) >= 3.0.1
Requires:      gem(smart_proxy_discovery) >= 1.0.5
Requires:      gem(smart_proxy_pulp) >= 2.1.0
Requires:      gem(smart_proxy_chef) >= 0.2.0
Conflicts:     gem(concurrent-ruby) >= 2
Conflicts:     gem(ruby-prof) >= 2
Conflicts:     smart-proxy-compat

%description   -n smart-proxy
RESTful proxies for DNS, DHCP, TFTP, BMC and Puppet executable(s).

Smart Proxy is a free open source project that provides restful API te
subsystems such as DNS, DHCP, etc, for higher level orchestration tools such as
Foreman.

Currently Supported modules:

* BMC - BMC management of devices supported by freeipmi and ipmitool
* DHCP - ISC DHCP and MS DHCP Servers
* DNS - Bind and MS DNS Servers
* Puppet - Any Puppet server from 0.24.x
* Puppet CA - Manage certificate signing, cleaning and autosign on a Puppet CA
  server
* Realm - Manage host registration to a realm (e.g. FreeIPA)
* TFTP - any UNIX based tftp server
* Facts - module to gather facts from facter (used only on discovered nodes)
* HTTPBoot - endpoint exposing a (TFTP) directory via HTTP(s) for UEFI HTTP
  booting
* Logs - log buffer of proxy logs for easier troubleshooting
* Templates - unattended Foreman endpoint proxy

%description   -n smart-proxy -l ru_RU.UTF-8
Исполнямка для самоцвета smart_proxy.


%if_enabled    doc
%package       -n gem-smart-proxy-doc
Version:       3.13.0
Release:       alt1
Summary:       RESTful proxies for DNS, DHCP, TFTP, BMC and Puppet documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета smart_proxy
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(smart_proxy) = 3.13.0

%description   -n gem-smart-proxy-doc
RESTful proxies for DNS, DHCP, TFTP, BMC and Puppet documentation files.

Smart Proxy is a free open source project that provides restful API to
subsystems such as DNS, DHCP, etc, for higher level orchestration tools such as
Foreman.

Currently Supported modules:

* BMC - BMC management of devices supported by freeipmi and ipmitool
* DHCP - ISC DHCP and MS DHCP Servers
* DNS - Bind and MS DNS Servers
* Puppet - Any Puppet server from 0.24.x
* Puppet CA - Manage certificate signing, cleaning and autosign on a Puppet CA
  server
* Realm - Manage host registration to a realm (e.g. FreeIPA)
* TFTP - any UNIX based tftp server
* Facts - module to gather facts from facter (used only on discovered nodes)
* HTTPBoot - endpoint exposing a (TFTP) directory via HTTP(s) for UEFI HTTP
  booting
* Logs - log buffer of proxy logs for easier troubleshooting
* Templates - unattended Foreman endpoint proxy

%description   -n gem-smart-proxy-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета smart_proxy.
%endif


%if_enabled    devel
%package       -n gem-smart-proxy-devel
Version:       3.13.0
Release:       alt1
Summary:       RESTful proxies for DNS, DHCP, TFTP, BMC and Puppet development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета smart_proxy
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(smart_proxy) = 3.13.0
Requires:      gem(benchmark-ips) >= 0
Requires:      gem(ci_reporter) >= 1.6.3
Requires:      gem(concurrent-ruby) >= 1.0
Requires:      gem(facter) >= 0
Requires:      gem(json) >= 0
Requires:      gem(logging) >= 0
Requires:      gem(mocha) >= 1.10
Requires:      gem(pry) >= 0
Requires:      gem(rack) >= 1.3
Requires:      gem(rack-test) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(rdoc) >= 0
Requires:      gem(rubocop) >= 1.56.0
Requires:      gem(rubocop-performance) >= 1.5.2
Requires:      gem(rubocop-rake) >= 0
Requires:      gem(sd_notify) >= 0.1
Requires:      gem(sinatra) >= 2.0
Requires:      gem(test-unit) >= 0
Requires:      gem(webmock) >= 0
Requires:      gem(webrick) >= 1.0
Conflicts:     gem(ci_reporter) >= 3
Conflicts:     gem(concurrent-ruby) >= 2
Conflicts:     gem(mocha) >= 3
Conflicts:     gem(rubocop) >= 2
Conflicts:     gem(rubocop-performance) >= 2
Conflicts:     gem(ruby-prof) >= 2
Conflicts:     gem(sd_notify) >= 1
Conflicts:     gem(sinatra) >= 5
Conflicts:     gem(webrick) >= 2

%description   -n gem-smart-proxy-devel
RESTful proxies for DNS, DHCP, TFTP, BMC and Puppet development package.

Smart Proxy is a free open source project that provides restful API to
subsystems such as DNS, DHCP, etc, for higher level orchestration tools such as
Foreman.

Currently Supported modules:

* BMC - BMC management of devices supported by freeipmi and ipmitool
* DHCP - ISC DHCP and MS DHCP Servers
* DNS - Bind and MS DNS Servers
* Puppet - Any Puppet server from 0.24.x
* Puppet CA - Manage certificate signing, cleaning and autosign on a Puppet CA
  server
* Realm - Manage host registration to a realm (e.g. FreeIPA)
* TFTP - any UNIX based tftp server
* Facts - module to gather facts from facter (used only on discovered nodes)
* HTTPBoot - endpoint exposing a (TFTP) directory via HTTP(s) for UEFI HTTP
  booting
* Logs - log buffer of proxy logs for easier troubleshooting
* Templates - unattended Foreman endpoint proxy

%description   -n gem-smart-proxy-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета smart_proxy.
%endif


%prep
%setup
%autopatch -p1

%build
%ruby_build

%install
%ruby_install

#TODO move to baltix
install -dm750 %buildroot%_logdir/smart-proxy \
               %buildroot%_sysconfdir/smart-proxy/config/settings.d \
               %buildroot/run/smart-proxy \
               %buildroot%_localstatedir/smart-proxy/
install -m644 %SOURCE1 %buildroot%_sysconfdir/smart-proxy/config/
install -Dm644 %SOURCE2 %buildroot%_unitdir/smart-proxy.service
install -Dm644 %SOURCE3 %buildroot%_tmpfilesdir/smart-proxy.conf
install -Dm644 %SOURCE5 %buildroot%ruby_gemlibdir/Gemfile.run
ln -rvs %buildroot%ruby_gemlibdir/Gemfile.run %buildroot%_localstatedir/smart-proxy/Gemfile
cp -p config/settings.d/*.yml.example %buildroot%_sysconfdir/smart-proxy/config/settings.d
install -Dm644 %SOURCE4 %buildroot%_sysconfdir/smart-proxy/config/settings.d/puppetca_http_api.yml

%check
%ruby_test

%pre           -n smart-proxy
getent group puppet >/dev/null || %_sbindir/groupadd -r puppet
getent group foreman >/dev/null || %_sbindir/groupadd -r foreman
getent passwd _smartforeman >/dev/null || \
   %_sbindir/useradd -r -G puppet,foreman -d %_localstatedir/smart-proxy -s /bin/bash -c "Foreman" _smartforeman

%post          -n smart-proxy
rm -rf %_localstatedir/smart-proxy/Gemfile.lock
%post_service  smart-proxy

%preun         -n smart-proxy
%preun_service smart-proxy


%files
%doc README.md CHANGELOG Contributors LICENSE
%ruby_gemspec
%ruby_gemlibdir
%config(noreplace) %_sysconfdir/smart-proxy/config/settings.yml
%config(noreplace) %_sysconfdir/smart-proxy/config/settings.d/*.yml.example
%config(noreplace) %_sysconfdir/smart-proxy/config/settings.d/puppetca_http_api.yml


%files         -n smart-proxy
%doc README.md CHANGELOG Contributors LICENSE
%_bindir/smart-proxy
%_unitdir/smart-proxy.service
%_tmpfilesdir/smart-proxy.conf
%attr(750,_smartforeman,foreman) %_logdir/smart-proxy
%attr(751,_smartforeman,foreman) %_localstatedir/smart-proxy
%attr(751,_smartforeman,foreman) /run/smart-proxy

%if_enabled    doc
%files         -n gem-smart-proxy-doc
%doc README.md CHANGELOG Contributors LICENSE
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-smart-proxy-devel
%doc README.md CHANGELOG Contributors LICENSE
%endif


%changelog
