%define        gemname sassc

Name:          gem-sassc
Version:       2.4.0.1
Release:       alt1.1
Summary:       Use libsass with Ruby!
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/sass/sassc-ruby
Vcs:           https://github.com/sass/sassc-ruby.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Patch:         use-system-libsass.patch
BuildRequires(pre): rpm-build-ruby
BuildRequires: libstdc++-devel
BuildRequires: libsass-devel
%if_with check
BuildRequires: gem(minitest) >= 5.5.1 gem(minitest) < 6
BuildRequires: gem(minitest-around) >= 0
BuildRequires: gem(test_construct) >= 0
BuildRequires: gem(pry) >= 0
BuildRequires: gem(bundler) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(rake-compiler) >= 0
BuildRequires: gem(rake-compiler-dock) >= 0
BuildRequires: gem(ffi) >= 1.9 gem(ffi) < 2
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency minitest >= 5.17.0,minitest < 6
Requires:      gem(ffi) >= 1.9 gem(ffi) < 2
Requires:      libsass
Obsoletes:     ruby-sassc < %EVR
Provides:      ruby-sassc = %EVR
Provides:      gem(sassc) = 2.4.0.1

%ruby_use_gem_version sassc:2.4.0.1

%description
This gem combines the speed of libsass, the Sass C implementation, with the ease
of use of the original Ruby Sass library.


%package       -n gem-sassc-doc
Version:       2.4.0.1
Release:       alt1.1
Summary:       Use libsass with Ruby! documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета sassc
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(sassc) = 2.4.0.1

%description   -n gem-sassc-doc
Use libsass with Ruby! documentation files.

This gem combines the speed of libsass, the Sass C implementation, with the ease
of use of the original Ruby Sass library.

%description   -n gem-sassc-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета sassc.


%package       -n gem-sassc-devel
Version:       2.4.0.1
Release:       alt1.1
Summary:       Use libsass with Ruby! development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета sassc
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(sassc) = 2.4.0.1
Requires:      libstdc++-devel
Requires:      gem(minitest) >= 5.5.1 gem(minitest) < 6
Requires:      gem(minitest-around) >= 0
Requires:      gem(test_construct) >= 0
Requires:      gem(pry) >= 0
Requires:      gem(bundler) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(rake-compiler) >= 0
Requires:      gem(rake-compiler-dock) >= 0

%description   -n gem-sassc-devel
Use libsass with Ruby! development package.

This gem combines the speed of libsass, the Sass C implementation, with the ease
of use of the original Ruby Sass library.

%description   -n gem-sassc-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета sassc.


%prep
%setup
%autopatch

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir

%files         -n gem-sassc-doc
%doc README.md
%ruby_gemdocdir

%files         -n gem-sassc-devel
%doc README.md


%changelog
