%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname puppet

Name:          gem-puppet
Version:       8.10.0.39
Release:       alt0.2
Summary:       A network tool for managing many disparate systems
License:       Apache-2.0
Group:         Development/Ruby
Url:           https://puppet.com/
Vcs:           https://github.com/puppetlabs/puppet.git
Packager:      Baltix Maintaining Team <baltix@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Source1:       client.init
Source2:       puppet.service
Source3:       puppet-nm-dispatcher
Source4:       auth.conf
Source5:       puppet.conf
BuildRequires(pre): rpm-build-ruby
%if_enabled check
BuildRequires: gem(concurrent-ruby) >= 1.0
BuildRequires: gem(deep_merge) >= 1.0
BuildRequires: gem(fast_gettext) >= 2.1
BuildRequires: gem(ffi) > 1.16.2
BuildRequires: gem(getoptlong) >= 0.2.0
BuildRequires: gem(json-schema) >= 2.0
BuildRequires: gem(locale) >= 2.1
BuildRequires: gem(multi_json) >= 1.13
BuildRequires: gem(pry) >= 0
BuildRequires: gem(puppet-resource_api) >= 1.5
BuildRequires: gem(racc) >= 1.8.0
BuildRequires: gem(rake) >= 13.0
BuildRequires: gem(rspec) >= 3.1
BuildRequires: gem(rspec-its) >= 1.1
BuildRequires: gem(rubocop) >= 1.0
BuildRequires: gem(rubocop-i18n) >= 3.0
BuildRequires: gem(rubocop-performance) >= 1.0
BuildRequires: gem(rubocop-rake) >= 0.6
BuildRequires: gem(rubocop-rspec) >= 2.0
BuildRequires: gem(ruby-prof) >= 0.16.0
BuildRequires: gem(scanf) >= 1.0
BuildRequires: gem(semantic_puppet) >= 1.0
BuildRequires: gem(vcr) >= 6.1
BuildRequires: gem(webmock) >= 3.0
BuildRequires: gem(webrick) >= 1.7
BuildRequires: gem(yard) >= 0
BuildConflicts: gem(concurrent-ruby) >= 2
BuildConflicts: gem(deep_merge) >= 2
BuildConflicts: gem(facter) >= 5
BuildConflicts: gem(fast_gettext) >= 4
BuildConflicts: gem(ffi) >= 2
BuildConflicts: gem(getoptlong) >= 0.3
BuildConflicts: gem(json-schema) >= 3
BuildConflicts: gem(locale) >= 3
BuildConflicts: gem(multi_json) >= 2
BuildConflicts: gem(puppet-resource_api) >= 2
BuildConflicts: gem(rake) >= 14
BuildConflicts: gem(rspec) >= 4
BuildConflicts: gem(rspec-its) >= 2
BuildConflicts: gem(rubocop) >= 2
BuildConflicts: gem(rubocop-i18n) >= 4
BuildConflicts: gem(rubocop-performance) >= 2
BuildConflicts: gem(rubocop-rake) >= 1
BuildConflicts: gem(rubocop-rspec) >= 4
BuildConflicts: gem(scanf) >= 2
BuildConflicts: gem(semantic_puppet) >= 2
BuildConflicts: gem(vcr) >= 7
BuildConflicts: gem(webmock) >= 4
BuildConflicts: gem(webrick) >= 2
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency rubocop-rspec >= 3.7.0,rubocop-rspec < 4
%ruby_use_gem_dependency rdoc >= 6.1.1,rdoc < 7
%ruby_use_gem_dependency rspec-expectations >= 3.10.1,rspec-expectations < 4
%ruby_use_gem_dependency ffi >= 1.15.5,ffi < 2
Requires:      facter
Requires:      ruby >= 3.1.0
Requires:      rubygems > 1.3.1
Requires:      gem(concurrent-ruby) >= 1.0
Requires:      gem(deep_merge) >= 1.0
Requires:      gem(fast_gettext) >= 2.1
Requires:      gem(getoptlong) >= 0.2.0
Requires:      gem(locale) >= 2.1
Requires:      gem(multi_json) >= 1.13
Requires:      gem(puppet-resource_api) >= 1.5
Requires:      gem(scanf) >= 1.0
Requires:      gem(semantic_puppet) >= 1.0
Conflicts:     gem(concurrent-ruby) >= 2
Conflicts:     gem(deep_merge) >= 2
Conflicts:     gem(facter) >= 5
Conflicts:     gem(fast_gettext) >= 4
Conflicts:     gem(getoptlong) >= 0.3
Conflicts:     gem(locale) >= 3
Conflicts:     gem(multi_json) >= 2
Conflicts:     gem(puppet-resource_api) >= 2
Conflicts:     gem(scanf) >= 2
Conflicts:     gem(semantic_puppet) >= 2
Provides:      gem(puppet) = 8.10.0.39

%ruby_use_gem_version puppet:8.10.0.39

%description
Puppet lets you centrally manage every important aspect of your system using a
cross-platform specification language that manages all the separate elements
normally aggregated in different files, like users, cron jobs, and hosts, along
with obviously discrete elements like packages, services, and files.


%package       -n puppet
Version:       8.10.0.39
Release:       alt0.2
Summary:       A network tool for managing many disparate systems executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета puppet
Group:         System/Servers
BuildArch:     noarch

Requires:      shadow-change
Requires:      gem-getoptlong
Requires:      gem-racc
Requires:      gem(puppet) = 8.10.0.39
Requires:      gem(puppet-resource_api) >= 1.5
Requires:      gem(semantic_puppet) >= 1.0
Conflicts:     gem(facter) >= 5
Conflicts:     gem(puppet-resource_api) >= 2
Conflicts:     gem(semantic_puppet) >= 2
Provides:      puppet-agent = %EVR
Requires(preun,post): %name = %EVR

%description   -n puppet
A network tool for managing many disparate systems executable(s).

Puppet lets you centrally manage every important aspect of your system using a
cross-platform specification language that manages all the separate elements
normally aggregated in different files, like users, cron jobs, and hosts, along
with obviously discrete elements like packages, services, and files.

%description   -n puppet -l ru_RU.UTF-8
Исполнямка для самоцвета puppet.


%if_enabled    doc
%package       -n gem-puppet-doc
Version:       8.10.0.39
Release:       alt0.2
Summary:       A network tool for managing many disparate systems documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета puppet
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(puppet) = 8.10.0.39

%description   -n gem-puppet-doc
A network tool for managing many disparate systems documentation files.

Puppet lets you centrally manage every important aspect of your system using a
cross-platform specification language that manages all the separate elements
normally aggregated in different files, like users, cron jobs, and hosts, along
with obviously discrete elements like packages, services, and files.

%description   -n gem-puppet-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета puppet.
%endif


%if_enabled    devel
%package       -n gem-puppet-devel
Version:       8.10.0.39
Release:       alt0.2
Summary:       A network tool for managing many disparate systems development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета puppet
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(puppet) = 8.10.0.39
Requires:      gem(rubocop-performance) >= 1.0
Requires:      gem(rubocop-rake) >= 0.6
Requires:      gem(rubocop-rspec) >= 2.0
Conflicts:     gem(rubocop-performance) >= 2
Conflicts:     gem(rubocop-rake) >= 1
Conflicts:     gem(rubocop-rspec) >= 4

%description   -n gem-puppet-devel
A network tool for managing many disparate systems development package.

Puppet lets you centrally manage every important aspect of your system using a
cross-platform specification language that manages all the separate elements
normally aggregated in different files, like users, cron jobs, and hosts, along
with obviously discrete elements like packages, services, and files.

%description   -n gem-puppet-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета puppet.
%endif


%prep
%setup
%autopatch

%build
%ruby_build

%install
%ruby_install

# SysVInit files
install -Dp -m0644 ./ext/redhat/client.sysconfig %buildroot%_sysconfdir/sysconfig/puppet
install -Dp -m0755 %SOURCE1 %buildroot%_initrddir/puppet
# Systemd files
install -Dp -m0644 %SOURCE2 %buildroot%_unitdir/puppet.service
ln -s %_unitdir/puppet.service %buildroot%_unitdir/puppetagent.service
ln -s %_unitdir/puppet.service %buildroot%_unitdir/puppet-agent.service

install -Dp -m0644 conf/fileserver.conf %buildroot%_sysconfdir/puppet/fileserver.conf

# Create other configuration directories
mkdir -p %buildroot%_sysconfdir/puppet/ssl/{public_keys,certificate_requests,certs,ca/requests,ca/private,ca/signed,private,private_keys}
mkdir -p %buildroot%_sysconfdir/puppet/code/environments/production/manifests

# Setup tmpfiles.d config
mkdir -p %buildroot%_tmpfilesdir
echo "D /run/%gemname 0755 _%gemname %gemname -" > \
    %buildroot%_tmpfilesdir/%gemname.conf

# Create puppet modules directory for puppet module tool
mkdir -p %buildroot%_sysconfdir/%gemname/code/modules
touch %buildroot%_sysconfdir/puppet/code/modules/.dir

# Create service directory
mkdir -p %buildroot{%_cachedir,%_logdir,/run}/puppet

# Create puppet modules link
ln -s %_libexecdir/puppet-modules %buildroot%ruby_gemlibdir/vendor_modules

# Install NetworkManager dispatcher
install -Dpv %SOURCE3 \
    %buildroot%_sysconfdir/NetworkManager/dispatcher.d/98-%{name}

touch %buildroot%_sysconfdir/puppet/autosign.conf
install -Dm644 %SOURCE4 %buildroot%_sysconfdir/puppet/auto.conf
install -Dm644 %SOURCE5 %buildroot%_sysconfdir/puppet/puppet.conf

# link to gem library code base
ln -s %ruby_gemlibdir %buildroot%_datadir/%gemname

# TODO fix backward link to a foreman ? from theforeman-foreman
ln -s %_libexecdir/puppet-modules/theforeman-foreman/files/foreman-report_v2.rb %buildroot%ruby_gemlibdir/lib/puppet/reports/foreman.rb

# Create public subdirectory
mkdir -p %buildroot%ruby_gemlibdir/public
touch %buildroot%ruby_gemlibdir/public/.dir

# Create locale and modules directories
mkdir -p %buildroot%_datadir/puppet-locale %buildroot%_libexecdir/puppet-modules
touch %buildroot%_datadir/puppet-locale/.dir %buildroot%_libexecdir/puppet-modules/.dir

# Remove demo files
rm -rf %buildroot%_libexecdir/demo %buildroot%_datadir/ri/demo

%check
%ruby_test

%pre           -n puppet
[ ! -d %_sysconfdir/puppetlabs/puppet/ssl ] || (
   cp -rf %_sysconfdir/puppetlabs/puppet/ssl %_sysconfdir/puppet &&
   rm -rf %_sysconfdir/puppetlabs/puppet/ssl)
getent group foreman >/dev/null || %_sbindir/groupadd -r foreman
getent group puppet >/dev/null || %_sbindir/groupadd -r puppet
%_sbindir/useradd -r -N -G puppet,foreman -d %_cachedir/puppet -s /dev/null -c Puppet _puppet >/dev/null 2>&1 ||:

%post          -n puppet
%post_service puppet
sed -e "s,sample.server.name,$(hostname)," \
    -i %_sysconfdir/puppet/puppet.conf

%preun         -n puppet
%preun_service puppet

%files
%doc CODE_OF_CONDUCT.md LICENSE README.md
%ruby_gemspec
%ruby_gemlibdir
%_libexecdir/puppet-modules

%files         -n puppet
%doc CODE_OF_CONDUCT.md LICENSE README.md
%_bindir/puppet
%_initdir/puppet
%_unitdir/puppet.service
%_unitdir/puppetagent.service
%_unitdir/puppet-agent.service
%config(noreplace) %_tmpfilesdir/%gemname.conf
%dir %_sysconfdir/puppet
%attr(0771,_puppet,puppet) %dir %_sysconfdir/puppet/ssl
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/public_keys
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/certificate_requests
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/certs
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/requests
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/private
%attr(0755,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/ca/signed
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/private
%attr(0750,_puppet,puppet) %dir %_sysconfdir/puppet/ssl/private_keys
%dir %_sysconfdir/puppet/code/environments
%dir %_sysconfdir/puppet/code/environments/production
%dir %_sysconfdir/puppet/code/environments/production/manifests
%dir %_sysconfdir/puppet/code
%_sysconfdir/puppet/code
%attr(0664,_puppet,puppet) %config(noreplace) %_sysconfdir/puppet/autosign.conf
%config(noreplace) %_sysconfdir/puppet/auto.conf
%config(noreplace) %_sysconfdir/puppet/puppet.conf
%config(noreplace) %_sysconfdir/sysconfig/puppet
%config(noreplace) %_sysconfdir/puppet/fileserver.conf
%_sysconfdir/NetworkManager/dispatcher.d/98-%{name}
%_datadir/puppet
%_datadir/puppet-locale
%attr(1770,_puppet,puppet) %dir %_cachedir/puppet
%_cachedir/puppet/
%attr(1770,_puppet,puppet) %dir %_logdir/puppet
%attr(1770,_puppet,puppet) %dir /run/puppet
%doc %_man8dir/*
%doc %_man5dir/puppet.conf.5*

%if_enabled    doc
%files         -n gem-puppet-doc
%doc CODE_OF_CONDUCT.md LICENSE README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-puppet-devel
%doc CODE_OF_CONDUCT.md LICENSE README.md
%endif


%changelog
