%define        pkgname net-sftp

Name:          gem-%pkgname
Version:       3.0.0
Release:       alt1
Summary:       A pure Ruby implementation of the SFTP client protocol
Group:         Development/Ruby
License:       MIT
Url:           https://github.com/net-ssh/net-sftp
Vcs:           https://github.com/net-ssh/net-sftp.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(mocha)
BuildRequires: gem(net-ssh)

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%gemname < %EVR
Provides:      ruby-%gemname = %EVR

%description
Net::SFTP is a pure-Ruby implementation of the SFTP protocol (specifically,
versions 1 through 6 of the SFTP protocol). Note that this is the "Secure File
Transfer Protocol", typically run over an SSH connection, and has nothing to
do with the FTP protocol.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir


%changelog
