%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname memcached

Name:          gem-memcached
Version:       2.0.0.21
Release:       alt0.1
Summary:       A Ruby interface to the libmemcached C client
License:       AFL-3.0
Group:         Development/Ruby
Url:           https://github.com/arthurnn/memcached
Vcs:           https://github.com/arthurnn/memcached.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libsasl2-devel
BuildRequires: libstdc++-devel
BuildRequires: libmemcached-devel
BuildRequires: gem(activesupport) >= 0
BuildRequires: gem(minitest) >= 0
BuildRequires: gem(mocha) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(rake-compiler) >= 0

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-memcached < %EVR
Provides:      ruby-memcached = %EVR
Provides:      memcached = %EVR
Provides:      gem(memcached) = 2.0.0.21

%ruby_use_gem_version memcached:2.0.0.21

%description
An interface to the libmemcached C client.

Features:
* clean API
* robust access to all memcached features
* SASL support for the binary protocol
* multiple hashing modes, including consistent hashing
* ludicrous speed, including optional pipelined IO with no_reply

The memcached library wraps the pure-C libmemcached client via SWIG.


%if_enabled    doc
%package       -n gem-memcached-doc
Version:       2.0.0.21
Release:       alt0.1
Summary:       A Ruby interface to the libmemcached C client documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета memcached
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(memcached) = 2.0.0.21

%description   -n gem-memcached-doc
A Ruby interface to the libmemcached C client documentation files.

An interface to the libmemcached C client.

Features:
* clean API
* robust access to all memcached features
* SASL support for the binary protocol
* multiple hashing modes, including consistent hashing
* ludicrous speed, including optional pipelined IO with no_reply

The memcached library wraps the pure-C libmemcached client via SWIG.

%description   -n gem-memcached-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета memcached.
%endif


%if_enabled    devel
%package       -n gem-memcached-devel
Version:       2.0.0.21
Release:       alt0.1
Summary:       A Ruby interface to the libmemcached C client development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета memcached
Group:         Development/Ruby
BuildArch:     noarch

Requires:      libsasl2-devel
Requires:      libstdc++-devel
Requires:      libmemcached-devel
Requires:      gnu-config
Requires:      gem(memcached) = 2.0.0.21
Requires:      gem(activesupport) >= 0
Requires:      gem(minitest) >= 0
Requires:      gem(mocha) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(rake-compiler) >= 0

%description   -n gem-memcached-devel
A Ruby interface to the libmemcached C client development package.

An interface to the libmemcached C client.

Features:
* clean API
* robust access to all memcached features
* SASL support for the binary protocol
* multiple hashing modes, including consistent hashing
* ludicrous speed, including optional pipelined IO with no_reply

The memcached library wraps the pure-C libmemcached client via SWIG.

%description   -n gem-memcached-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета memcached.
%endif


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc CHANGELOG LICENSE README.md
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%if_enabled    doc
%files         -n gem-memcached-doc
%doc CHANGELOG LICENSE README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-memcached-devel
%doc CHANGELOG LICENSE README.md
%ruby_includedir/*
%endif


%changelog
