%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname highline

Name:          gem-highline
Epoch:         1
Version:       3.1.2
Release:       alt1
Summary:       HighLine is a high-level command-line IO Ruby library
License:       Ruby
Group:         Development/Ruby
Url:           https://github.com/JEG2/highline
Vcs:           https://github.com/jeg2/highline.git
Packager:      Baltix Maintaining Team <baltix@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Autoprov:      yes,noruby
Autoreq:       yes,noruby
BuildRequires(pre): rpm-build-ruby
%if_enabled check
BuildRequires: gem(bundler) >= 0
BuildRequires: gem(dry-types) >= 0
BuildRequires: gem(minitest) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(reline) >= 0
BuildRequires: gem(simplecov) >= 0
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Requires:      ruby >= 3.0
Requires:      gem(reline) >= 0
Obsoletes:     ruby-highline < %EVR
Provides:      ruby-highline = %EVR
Provides:      gem(highline) = 3.1.2

%description
A high-level IO library that provides validation, type conversion, and more for
command-line interfaces. HighLine also includes a complete menu system that can
crank out anything from simple list selection to complete shells with just
minutes of work.


%if_enabled    doc
%package       -n gem-highline-doc
Version:       3.1.2
Release:       alt1
Summary:       HighLine is a high-level command-line IO Ruby library documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета highline
Group:         Development/Documentation
BuildArch:     noarch

Autoprov:      yes,noruby
Autoreq:       yes,noruby
Requires:      gem(highline) = 3.1.2

%description   -n gem-highline-doc
HighLine is a high-level command-line IO Ruby library documentation files.

A high-level IO library that provides validation, type conversion, and more for
command-line interfaces. HighLine also includes a complete menu system that can
crank out anything from simple list selection to complete shells with just
minutes of work.

%description   -n gem-highline-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета highline.
%endif


%if_enabled    devel
%package       -n gem-highline-devel
Version:       3.1.2
Release:       alt1
Summary:       HighLine is a high-level command-line IO Ruby library development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета highline
Group:         Development/Ruby
BuildArch:     noarch

Autoprov:      yes,noruby
Autoreq:       yes,noruby
Requires:      gem(highline) = 3.1.2
Requires:      gem(bundler) >= 0
Requires:      gem(dry-types) >= 0
Requires:      gem(minitest) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(simplecov) >= 0

%description   -n gem-highline-devel
HighLine is a high-level command-line IO Ruby library development package.

A high-level IO library that provides validation, type conversion, and more for
command-line interfaces. HighLine also includes a complete menu system that can
crank out anything from simple list selection to complete shells with just
minutes of work.

%description   -n gem-highline-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета highline.
%endif


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc COPYING Changelog.md LICENSE README.md
%ruby_gemspec
%ruby_gemlibdir

%if_enabled    doc
%files         -n gem-highline-doc
%doc COPYING Changelog.md LICENSE README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-highline-devel
%doc COPYING Changelog.md LICENSE README.md
%endif


%changelog
