# vim: set ft=spec: -*- rpm-spec -*-
%define        _unpackaged_files_terminate_build 1
%def_enable    doc
%def_enable    devel
%define        gemname gpgme

Name:          gem-gpgme
Version:       2.0.24.4
Release:       alt0.2
Summary:       Ruby interface to GnuPG Made Easy
License:       LGPL-2.1+
Group:         Development/Ruby
Url:           https://github.com/ueno/ruby-gpgme
Vcs:           https://github.com/ueno/ruby-gpgme.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libgpgme-devel
%if_enabled check
BuildRequires: gem(byebug) >= 0
BuildRequires: gem(coveralls_reborn) >= 0
BuildRequires: gem(mini_portile2) >= 2.7
BuildRequires: gem(minitest) >= 2.1.0
BuildRequires: gem(mocha) >= 0.9.12
BuildRequires: gem(rake) >= 0
BuildRequires: gem(yard) >= 0.9.11
BuildConflicts: gem(mini_portile2) >= 3
BuildConflicts: gem(minitest) >= 6
BuildConflicts: gem(mocha) >= 3
BuildConflicts: gem(yard) >= 1
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency mocha >= 2.7.1,mocha < 3
%ruby_use_gem_dependency minitest >= 5.17.0,minitest < 6
%ruby_use_gem_dependency yard >= 0.9.34,yard < 1
Requires:      gem(mini_portile2) >= 2.7
Conflicts:     gem(mini_portile2) >= 3
Obsoletes:     ruby-gpgme < %EVR
Provides:      ruby-gpgme = %EVR
Provides:      gem(gpgme) = 2.0.24.4

%ruby_use_gem_version gpgme:2.0.24.4

%description
Ruby interface to GnuPG Made Easy (GPGME).


%if_enabled    doc
%package       -n gem-gpgme-doc
Version:       2.0.24.4
Release:       alt0.2
Summary:       Ruby interface to GnuPG Made Easy documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета gpgme
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(gpgme) = 2.0.24.4
Obsoletes:     ruby-gpgme-doc < %EVR
Provides:      ruby-gpgme-doc = %EVR

%description   -n gem-gpgme-doc
Ruby interface to GnuPG Made Easy documentation files.

Ruby interface to GnuPG Made Easy (GPGME).

%description   -n gem-gpgme-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета gpgme.
%endif


%if_enabled    devel
%package       -n gem-gpgme-devel
Version:       2.0.24.4
Release:       alt0.2
Summary:       Ruby interface to GnuPG Made Easy development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета gpgme
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(gpgme) = 2.0.24.4
Requires:      gem(byebug) >= 0
Requires:      gem(coveralls_reborn) >= 0
Requires:      gem(minitest) >= 2.1.0
Requires:      gem(mocha) >= 0.9.12
Requires:      gem(rake) >= 0
Requires:      gem(yard) >= 0.9.11
Conflicts:     gem(minitest) >= 6
Conflicts:     gem(mocha) >= 3
Conflicts:     gem(yard) >= 1

%description   -n gem-gpgme-devel
Ruby interface to GnuPG Made Easy development package.

Ruby interface to GnuPG Made Easy (GPGME).

%description   -n gem-gpgme-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета gpgme.
%endif


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc COPYING COPYING.LESSER README.rdoc
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%if_enabled    doc
%files         -n gem-gpgme-doc
%doc COPYING COPYING.LESSER README.rdoc
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-gpgme-devel
%doc COPYING COPYING.LESSER README.rdoc
%endif


%changelog
