%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%def_enable    devel
%define        gemname dynflow

Name:          gem-dynflow
Version:       1.9.3
Release:       alt1
Summary:       DYNamic workFLOW orchestration engine
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/Dynflow/dynflow
Vcs:           https://github.com/dynflow/dynflow.git
Packager:      Baltix Maintaining Team <baltix@packages.altlinux.org>
BuildArch:     noarch

Source3:       dynflow.service
Source2:       dynflow.sysconfig
Source1:       dynflow
Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
%if_enabled check
BuildRequires: gem(activejob) >= 0
BuildRequires: gem(activerecord) >= 0
BuildRequires: gem(algebrick) >= 0.7.0
BuildRequires: gem(concurrent-ruby) >= 1.1.3
BuildRequires: gem(concurrent-ruby-edge) >= 0.6.0
BuildRequires: gem(csv) >= 3.1
BuildRequires: gem(drb) >= 0
BuildRequires: gem(minitest-reporters) >= 0
BuildRequires: gem(minitest-stub-const) >= 0
BuildRequires: gem(mocha) >= 0
BuildRequires: gem(msgpack) >= 1.3
BuildRequires: gem(multi_json) >= 0
BuildRequires: gem(mutex_m) >= 0
BuildRequires: gem(ostruct) >= 0
BuildRequires: gem(rack-test) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(sequel) >= 4.0.0
BuildRequires: gem(sinatra) >= 0
BuildRequires: gem(sqlite3) >= 0
BuildRequires: gem(syslog) >= 0
BuildConflicts: gem(algebrick) >= 0.8
BuildConflicts: gem(concurrent-ruby) >= 2
BuildConflicts: gem(concurrent-ruby-edge) >= 1
BuildConflicts: gem(csv) >= 4
BuildConflicts: gem(minitest) >= 6
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency concurrent-ruby >= 1.2.3,concurrent-ruby < 2
%ruby_use_gem_dependency concurrent-ruby-edge >= 0.7,concurrent-ruby-edge < 1
%ruby_use_gem_dependency msgpack >= 1.7.2,msgpack < 2
%ruby_use_gem_dependency minitest >= 5.17.0,minitest < 6
%ruby_use_gem_dependency rails >= 7.1,rails < 8
Requires:      ruby >= 2.7.0
Requires:      gem(algebrick) >= 0.7.0
Requires:      gem(concurrent-ruby) >= 1.1.3
Requires:      gem(concurrent-ruby-edge) >= 0.6.0
Requires:      gem(csv) >= 3.1
Requires:      gem(msgpack) >= 1.3
Requires:      gem(multi_json) >= 0
Requires:      gem(sequel) >= 4.0.0
Conflicts:     gem(algebrick) >= 0.8
Conflicts:     gem(concurrent-ruby) >= 2
Conflicts:     gem(concurrent-ruby-edge) >= 1
Conflicts:     gem(csv) >= 4
Obsoletes:     ruby-dynflow < %EVR
Provides:      ruby-dynflow = %EVR
Provides:      gem(dynflow) = 1.9.3

%description
Dynflow [DYN(amic work)FLOW] is a workflow engine written in Ruby that allows
to:
* keep track of the progress of running process
* run the code asynchronously
* resume the process when something goes wrong, skip some steps when needed
* detect independent parts and run them concurrently
* compose simple actions into more complex scenarios
* extend the workflows from third-party libraries
* keep consistency between local transactional database and external services
* suspend the long-running steps, not blocking the thread pool
* cancel steps when possible
* extend the actions behavior with middlewares
* define the input/output interface between the building blocks (planned)
* define rollback for the workflow (planned)
* have multiple workers for distributing the load (planned)

Dynflow doesn't try to choose the best tool for the jobs, as the right tool
depends on the context. Instead, it provides interfaces for persistence,
transaction layer or executor implementation, giving you the last word in
choosing the right one (providing default implementations as well).


%if_enabled    doc
%package       -n gem-dynflow-doc
Version:       1.9.3
Release:       alt1
Summary:       DYNamic workFLOW orchestration engine documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета dynflow
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(dynflow) = 1.9.3

%description   -n gem-dynflow-doc
DYNamic workFLOW orchestration engine documentation files.

Dynflow [DYN(amic work)FLOW] is a workflow engine written in Ruby that allows
to:
* keep track of the progress of running process
* run the code asynchronously
* resume the process when something goes wrong, skip some steps when needed
* detect independent parts and run them concurrently
* compose simple actions into more complex scenarios
* extend the workflows from third-party libraries
* keep consistency between local transactional database and external services
* suspend the long-running steps, not blocking the thread pool
* cancel steps when possible
* extend the actions behavior with middlewares
* define the input/output interface between the building blocks (planned)
* define rollback for the workflow (planned)
* have multiple workers for distributing the load (planned)

Dynflow doesn't try to choose the best tool for the jobs, as the right tool
depends on the context. Instead, it provides interfaces for persistence,
transaction layer or executor implementation, giving you the last word in
choosing the right one (providing default implementations as well).

%description   -n gem-dynflow-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета dynflow.
%endif


%if_enabled    devel
%package       -n gem-dynflow-devel
Version:       1.9.3
Release:       alt1
Summary:       DYNamic workFLOW orchestration engine development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета dynflow
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(dynflow) = 1.9.3
Requires:      gem(activejob) >= 0
Requires:      gem(activerecord) >= 0
Requires:      gem(drb) >= 0
Requires:      gem(minitest-reporters) >= 0
Requires:      gem(minitest-stub-const) >= 0
Requires:      gem(mocha) >= 0
Requires:      gem(mutex_m) >= 0
Requires:      gem(ostruct) >= 0
Requires:      gem(rack-test) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(sinatra) >= 0
Requires:      gem(sqlite3) >= 0
Requires:      gem(syslog) >= 0
Conflicts:     gem(minitest) >= 6

%description   -n gem-dynflow-devel
DYNamic workFLOW orchestration engine development package.

Dynflow [DYN(amic work)FLOW] is a workflow engine written in Ruby that allows
to:
* keep track of the progress of running process
* run the code asynchronously
* resume the process when something goes wrong, skip some steps when needed
* detect independent parts and run them concurrently
* compose simple actions into more complex scenarios
* extend the workflows from third-party libraries
* keep consistency between local transactional database and external services
* suspend the long-running steps, not blocking the thread pool
* cancel steps when possible
* extend the actions behavior with middlewares
* define the input/output interface between the building blocks (planned)
* define rollback for the workflow (planned)
* have multiple workers for distributing the load (planned)

Dynflow doesn't try to choose the best tool for the jobs, as the right tool
depends on the context. Instead, it provides interfaces for persistence,
transaction layer or executor implementation, giving you the last word in
choosing the right one (providing default implementations as well).

%description   -n gem-dynflow-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета dynflow.
%endif


%package       -n dynflow
Version:       1.9.3
Release:       alt1
Summary:       DYNamic workFLOW engine executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета dynflow
Group:         Development/Other
BuildArch:     noarch

Requires:      gem(dynflow) = 1.9.3
Requires:      gem-dynflow = %EVR

%description   -n dynflow
Ruby workflow/orchestration engine


%prep
%setup

%build
%ruby_build

%install
%ruby_install
install -Dm0755 %SOURCE1 %buildroot%_sbindir/dynflow
install -Dm0644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/dynflow
install -Dm0644 %SOURCE3 %buildroot%_unitdir/dynflow.service
mkdir -p %buildroot%_sharedstatedir/dynflow %buildroot%_logdir/dynflow %buildroot/run/dynflow

%pre           -n dynflow
# Add the "dynflow" user and group
getent group dynflow >/dev/null || %_sbindir/groupadd -r dynflow
getent passwd _dynflow >/dev/null || \
   %_sbindir/useradd -r -g dynflow -d %_sharedstatedir/dynflow -s /bin/bash -c "Dynflow service" _dynflow
exit 0

%post          -n dynflow
%post_service dynflow

%preun         -n dynflow
%preun_service dynflow

%check
%ruby_test

%files
%doc MIT-LICENSE README.md
%ruby_gemspec
%ruby_gemlibdir

%if_enabled    doc
%files         -n gem-dynflow-doc
%doc MIT-LICENSE README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-dynflow-devel
%doc MIT-LICENSE README.md
%endif

%files         -n dynflow
%doc MIT-LICENSE README.md
%_sbindir/dynflow
%_unitdir/dynflow.service
%config(noreplace) %_sysconfdir/sysconfig/dynflow
%attr(770,_dynflow,dynflow) %_sharedstatedir/dynflow
%attr(770,_dynflow,dynflow) %_logdir/dynflow
%attr(770,_dynflow,dynflow) /run/dynflow


%changelog
