Name: geany-plugins
Version: 2.0
Release: alt2
%define geany_ver 2.0

Summary: Plugins for Geany

License: GPLv2
Group: Development/Tools
Url: http://plugins.geany.org/

Packager: Fr. Br. George <george@altlinux.org>

Source: %name-%version.tar.bz2

# https://github.com/geany/geany-plugins/pull/1315
Patch1: geany-plugins-pr1315-eliminate-some-compiler-warnings.patch

BuildRequires(pre): geany geany-devel intltool
# Hack out self-providing symbols
%add_python_req_skip app
%add_python_req_skip dialogs
%add_python_req_skip document
%add_python_req_skip encoding
%add_python_req_skip filetypes
%add_python_req_skip glog
%add_python_req_skip highlighting
%add_python_req_skip keybindings
%add_python_req_skip main
%add_python_req_skip msgwindow
%add_python_req_skip navqueue
%add_python_req_skip prefs
%add_python_req_skip project
%add_python_req_skip scintilla
%add_python_req_skip search
%add_python_req_skip ui_utils
%add_python_req_skip templates

Requires: geany-plugins-vc

# Automatically added by buildreq on Mon Nov 09 2020
# optimized out: at-spi2-atk fontconfig geany glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libat-spi2-core libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libenchant2-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libgpg-error-devel libgtk+3-devel libharfbuzz-devel libjavascriptcoregtk4-devel liblua5.1-devel libpango-devel libsoup-devel libwayland-client libwayland-cursor libwayland-egl perl perl-XML-Parser pkg-config python-modules python2-base python3 python3-base sh4 shared-mime-info vala xorg-proto-devel
BuildRequires: cppcheck geany-devel intltool libcheck-devel libctpl-devel libgit2-devel libgpgme-devel libgtkspell3-devel libvte3-devel libwebkit2gtk-devel libxml2-devel python3-dev

BuildRequires: liblua5.1-devel

%description
This is Geany plugin collection

%package common
Group: Development/Tools
Requires: geany = %geany_ver
Summary: Localization and other platform independent stuff of geany-plugins
BuildArch: noarch

%description common
Common files of geany-plugins, including localization

%package vc
Group: Development/Tools
Requires: geany-plugins-common = %version-%release
Summary: Geany VC integration plugin

%description vc
Various VCS integration (Git, SVN, ...) for Geany

%prep
%setup
%autopatch -p1
sed -i '/^geanyluadir/s@.*@geanyluadir = %_libdir/geany@' geanylua/Makefile.am

%build
export PYTHON_VERSION=2
%autoreconf
%configure
%make_build

%install
%makeinstall_std --silent --no-print-directory
%find_lang %name

%files
%doc %_defaultdocdir/%name
%_libdir/geany/*
%_libdir/lib*
%_datadir/geany-plugins/*
#dir #_libexecdir/geany-plugins
#_libexecdir/geany-plugins/*
#_iconsdir/hicolor/*/apps/*
%exclude %_libdir/geany/geanyvc*
%exclude %_libdir/geany/*.la
#exclude %_libdir/geany-plugins/*/*.la

%files common -f %name.lang
%files vc
%_libdir/geany/geanyvc*
%exclude %_libdir/geany/*.la

%changelog
