Name: gdbm
Version: 1.8.3
Release: alt10

Summary: A GNU set of database routines which use extensible hashing
License: GPLv2+
Group: System/Libraries
Url: http://www.gnu.org/software/gdbm/

# ftp://ftp.gnu.org/pub/gnu/gdbm/gdbm-%version.tar.gz
Source: gdbm-%version.tar
Patch1: gdbm-1.8.3-alt-texinfo.patch
Patch2: gdbm-1.8.3-alt-makefile.patch
Patch3: gdbm-1.8.3-alt-configure.patch
Patch4: gdbm-1.8.3-alt-read_loop.patch
Patch11: gdbm-1.8.3-deb-texinfo.patch
Patch12: gdbm-1.8.3-deb-zero-headers.patch
Patch13: gdbm-1.8.3-deb-man.patch
Patch14: gdbm-1.8.3-rh-GDBM_FILE.patch
Patch15: gdbm-1.8.3-deb-texinfo-null.patch

%def_disable static

BuildRequires: makeinfo

%package -n lib%name
Summary: A GNU set of database routines which use extensible hashing
Group: System/Libraries
Provides: %name = %version-%release
#Obsoletes: %name

%package -n lib%name-devel
Summary: Development libraries and header files for the gdbm library
Group: Development/Databases
Provides: %name-devel = %version-%release
Obsoletes: %name-devel
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: The gdbm static library
Group: Development/Databases
Provides: %name-devel-static = %version-%release
Obsoletes: %name-devel-static
Requires: lib%name-devel = %version-%release

%description
gdbm is a GNU database indexing library, including routines which use
extensible hashing.  gdbm works in a similar way to standard Unix dbm
routines.  gdbm is useful for developers who write C applications and
need access to a simple and efficient database or who are building C
applications which will use such a database.

%description -n lib%name
gdbm is a GNU database indexing library, including routines which use
extensible hashing.  gdbm works in a similar way to standard Unix dbm
routines.  gdbm is useful for developers who write C applications and
need access to a simple and efficient database or who are building C
applications which will use such a database.

%description -n lib%name-devel
This package contains the development libraries and header files for
gdbm, the GNU database system.  These libraries and header files are
necessary if you plan to do development using the gdbm database.

%description -n lib%name-devel-static
This package contains the GDBM development static library necessary
if you plan to do development of statically linked software using
the gdbm database.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
rm aclocal.m4

%build
export ac_cv_lib_dbm_main=no
export ac_cv_lib_ndbm_main=no
%autoreconf
%configure %{subst_enable static} --includedir=%_includedir/gdbm
%make_build

%install
%makeinstall_std install-compat \
	INSTALL_ROOT=%buildroot \
	BINOWN=`id -u` \
	BINGRP=`id -g` \
	#
ln -s gdbm/gdbm.h %buildroot%_includedir/

%files -n lib%name
%_libdir/*so.*
%doc README NEWS

%files -n lib%name-devel
%_libdir/*so
%_includedir/*
%_infodir/*.info*
%_mandir/man?/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
