%def_disable snapshot

%define _name gcr
%define _libexecdir %_prefix/libexec
%define ver_major 4.4
%define gcr_api_ver 4
%define gck_api_ver 2

%def_enable ssh_agent
%def_enable introspection
%def_enable gtk_doc
%def_enable check

Name: gcr%gcr_api_ver
Version: %ver_major.0.1
Release: alt1.1

Summary: A GNOME crypto viewer and prompter
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/GnomeKeyring

Vcs: https://gitlab.gnome.org/GNOME/gcr.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
Source1: gcr-ssh-agent.sh

Requires: %name-libs = %EVR
Requires: libtasn1-utils
%{?_enable_ssh_agent:Requires: %_bindir/ssh-agent %_bindir/ssh-add}
%{?_disable_ssh_agent:Conflicts: gcr < 3.41.1-alt2}

%define meson_ver 0.59
%define glib_ver 2.74.0
%define p11kit_ver 0.19.0
%define vala_ver 0.18.1
%define gnutls_ver 3.8.5
%define gcrypt_ver 1.4.5
%define secret_ver 0.20

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-systemd
BuildRequires: meson >= %meson_ver glib2-devel >= %glib_ver
BuildRequires: libp11-kit-devel >= %p11kit_ver
BuildRequires: libgtk4-devel
BuildRequires: pkgconfig(gnutls) >= %gnutls_ver
BuildRequires: libgcrypt-devel >= %gcrypt_ver libtasn1-devel libtasn1-utils libtasn1-utils gnupg2-gpg
BuildRequires: libvala-devel >= %vala_ver vala-tools
BuildRequires: libsecret-devel >= %secret_ver %_bindir/ssh-agent %_bindir/ssh-add
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_check:BuildRequires: /proc xvfb-run dbus-tools-gui %_bindir/ssh-keygen}

%description
GCR is a library for displaying certificates, and crypto UI, accessing
key stores. It also provides the viewer for crypto files on the GNOME
desktop.

GCK is a library for accessing PKCS#11 modules like smart cards, in a
(G)object oriented way.

%package libs
Summary: Development files for GCR
Group: System/Libraries

%description libs
GCR is a library for displaying certificates, and crypto UI, accessing
key stores. It also provides the viewer for crypto files on the GNOME
desktop.

GCK is a library for accessing PKCS#11 modules like smart cards, in a
(G)object oriented way.

%package libs-devel
Summary: Development files for GCR
Group: Development/C
Requires: %name-libs = %EVR

%description libs-devel
The gcr-devel package includes the header files for the GCR libraries.

%package libs-gir
Summary: GObject introspection data for GCR libraries
Group: System/Libraries
Requires: %name-libs = %EVR

%description libs-gir
GObject introspection data for GCR libraries.

%package libs-gir-devel
Summary: GObject introspection devel data for the GCR libraries
Group: System/Libraries
BuildArch: noarch
Requires: %name-libs-gir = %EVR
Requires: %name-libs-devel = %EVR

%description libs-gir-devel
GObject introspection devel data for the GCR libraries.

%package libs-vala
Summary: Vala language bindings for the GCR libraries
Group: Development/Other
BuildArch: noarch
Requires: %name-libs = %EVR

%description libs-vala
This package provides Vala language bindings for the GCR libraries.

%package libs-devel-doc
Summary: Development documentation for GCR libraries
Group: Development/Documentation
Conflicts: %name-libs < %version-%release
BuildArch: noarch

%description libs-devel-doc
This package contains development documentation for GCR libraries.


%prep
%setup -n %_name-%version

%build
%meson \
    %{subst_enable_meson_bool ssh_agent ssh_agent} \
    %{subst_enable_meson_bool introspection introspection} \
    %{subst_enable_meson_bool gtk_doc gtk_doc}
%nil
%meson_build

%install
%meson_install
install -pD -m755 %SOURCE1 %buildroot%_sysconfdir/profile.d/gcr-ssh-agent.sh
%find_lang %_name-%gcr_api_ver

%check
xvfb-run %__meson_test -t 8

%files -f %_name-%gcr_api_ver.lang
%_bindir/%_name-viewer-gtk4
%_libexecdir/%name-ssh-askpass
%{?_enable_ssh_agent:
%_sysconfdir/profile.d/gcr-ssh-agent.sh
%_libexecdir/%_name-ssh-agent
%_userunitdir/%_name-ssh-agent.service
%_userunitdir/%_name-ssh-agent.socket}

%files libs
%_libdir/libgck-%gck_api_ver.so.*
%_libdir/lib%_name-%gcr_api_ver.so.*

%files libs-devel
%_includedir/gck-%gck_api_ver
%_includedir/%_name-%gcr_api_ver
%_libdir/libgck-%gck_api_ver.so
%_libdir/lib%_name-%gcr_api_ver.so
%_pkgconfigdir/gck-%gck_api_ver.pc
%_pkgconfigdir/%_name-%gcr_api_ver.pc

%if_enabled gtk_doc
%files libs-devel-doc
%_datadir/doc/%_name-%gcr_api_ver
%_datadir/doc/gck-%gck_api_ver
%endif

%if_enabled introspection
%files libs-gir
%_typelibdir/Gck-%gck_api_ver.typelib
%_typelibdir/Gcr-%gcr_api_ver.typelib

%files libs-gir-devel
%_girdir/Gck-%gck_api_ver.gir
%_girdir/Gcr-%gcr_api_ver.gir
%endif

%files libs-vala
%_vapidir/gck-%gck_api_ver.deps
%_vapidir/gck-%gck_api_ver.vapi
%_vapidir/%_name-%gcr_api_ver.deps
%_vapidir/%_name-%gcr_api_ver.vapi

%changelog
