%define repo resclasses

Name: gap-resclasses
Version: 4.7.4
Release: alt1
Summary: GAP: Set-Theoretic Computations with Residue Classes
License: GPL-2.0+
Group: Sciences/Mathematics
Url: https://gap-packages.github.io/resclasses/
VCS: https://github.com/gap-packages/resclasses

# Source-url: https://github.com/gap-packages/resclasses/releases/download/v%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch: %repo-%version-%release.patch

BuildArch: noarch

BuildRequires: rpm-macros-gap

# PackageInfo.g
Requires: gap >= 4.11.1
Requires: gap-gapdoc >= 1.5.1
Requires: gap-polycyclic >= 2.11
Requires: gap-utils >= 0.40
#Recommends: gap-io >= 4.4.5

%description
ResClasses is a package for set-theoretic computations with residue
classes of the integers and a couple of other rings. The class of
sets which ResClasses can deal with includes the open and the closed
sets in the topo- logy on the respective ring which is induced by
taking the set of all residue classes as a basis, as far as the usual
restrictions imposed by the finite- ness of computing resources
permit this.

Recommends: gap-io >= 4.4.5.

%prep
%setup -n resclasses
%patch -p1

%build
%install
%gappkg_simple_install

%files -f %name.files
%gap_sitelib/%repo/

%changelog
