%define repo crisp

Name: gap-crisp
Version: 1.4.8
Release: alt1
Summary: GAP: Computing with Radicals, Injectors, Schunck classes and Projectors
License: BSD-2-Clause
Group: Sciences/Mathematics
Url: https://github.com/bh11/crisp
VCS: https://github.com/bh11/crisp

# Source-url: https://github.com/bh11/crisp/archive/refs/tags/CRISP-%version.tar.gz
Source: crisp-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-macros-gap
BuildRequires: xz

BuildArch: noarch
Requires: gap >= 4.12

%description
The GAP package "CRISP" provides algorithsmf roc omputing subgroups
of finite solvable groups related to a group class 'C'. In
particular, it allows to compute 'C' radicals and 'C'-injectors for
Fitting (and Fitting sets) 'C', 'C'-residuals for formations 'C', and
'C'-projectors for Schunck classes 'C'.

Moreover, CRISP contains algorithms for the computation of normal
subgroups invariant under a prescribed set of automorphisms and
belonging to a given group class.

%prep
%setup -n crisp
%patch -p1

%build
%install
%gappkg_simple_install

%files -f %name.files
%gap_sitelib/%repo/

%changelog
