%define        _unpackaged_files_terminate_build 1
%def_enable    check
%def_enable    doc
%define        _gammu_docdir %_defaultdocdir/%name-%version

Name:          gammu
Version:       1.42.0.290
Release:       alt0.1
Summary:       Mobile phones management utility
Summary(ru_RU.UTF-8): Программа для работы с мобильными телефонами
License:       GPLv2
Group:         Communications
Url:           https://wammu.eu/gammu/
Vcs:           https://github.com/gammu/gammu.git

Source:        %name-%version.tar
BuildRequires: cmake
BuildRequires: ctest
BuildRequires: pkg-config
BuildRequires: doxygen
BuildRequires: libMySQL-devel
BuildRequires: libbluez-devel
BuildRequires: zlib-devel
BuildRequires: glib2-devel
BuildRequires: libcurl-devel
BuildRequires: libgudev-devel
BuildRequires: libdbi-devel
BuildRequires: libusb-devel
BuildRequires: python3-devel

%description
Gammu can do such things with cellular phones as making data
calls, updating the address book, changing calendar and ToDo
entries, sending and receiving SMS messages, loading and getting
ring tones and pictures (different types of logos), synchronizing
time, enabling NetMonitor, managing WAP settings and bookmarks
and much more (available functions depend on the phone model).
It can also make full backups and restore them.

It currently supports many Nokia phones and AT devices (such as
Siemens, Alcatel, Falcom, WaveCom, IPAQ, and other).

%description -l ru_RU.UTF-8
Gammu - это программа для работы с мобильными телефонами.
В зависимости от модели телефона Gammu умеет: передавать данные,
обновлять телефонную книжку, управлять записями календаря и
списка дел, принимать и отправлять короткие сообщения (SMS),
загружать в аппарат а также считывать с него мелодии и картинки
(различные виды логотипов), синхронизировать время, включать
NetMonitor, управлять настройками WAP, закладками и ещё много
всего другого.  Кроме того, Gammu позволяет делать полные
резервные копии данных телефона c возможностью их восстановления
в случае необходимости.

На данный момент поддерживается множество моделей телефонов
Nokia, а также аппаратов, понимающих AT-команды (таких как
телефоны Siemens, Alcatel, Falcom, WaveCom, IPAQ и т.д.)


%package       -n lib%name
Summary:       Libraries used by %name
Summary(ru_RU.UTF-8): Динамические библиотеки %name
Group:         System/Libraries

%description   -n lib%name
Libraries needed for %name.

%description   -n lib%name -l ru_RU.UTF-8
Библиотеки, необходимые для %name.


%package       -n lib%name-devel
Summary:       Headers to compile against the lib%name library
Summary(ru_RU.UTF-8): Заголовочные файлы для сборки с библиотекой lib%name
Group:         Development/C
#Requires:a lib%name = %version-%release

%description   -n lib%name-devel
This package contains all files which one needs to compile
programs using the lib%name library.

%description   -n lib%name-devel -l ru_RU.UTF-8
Данный пакет содержит файлы, необходимые для сборки программ,
использующих библиотеку lib%name.


%package       -n bash-completion-%name
Summary:       bash completion for gammu
Group:         Shells
BuildArch:     noarch
Requires:      bash-completion
Requires:      %name = %EVR

%description -n bash-completion-%name
Bash completion for gammu


%prep
%setup
# this is ALT specific, no sense to maintain a patch
sed -i 's,/var/lock/LCK\.\.,/var/lock/serial/LCK..,' \
	libgammu/device/devfunc.c

%build
%cmake \
   -DCMAKE_INSTALL_PREFIX="%_usr" \
   -DINSTALL_LIB_DIR=%_libdir \
   -DINSTALL_LIBDATA_DIR=%_libdir \
   -DINSTALL_DOC_DIR=%_gammu_docdir \
   -DMYSQL_CONFIG="%_bindir/mysql_config" \
   -DBUILD_PYTHON:FILEPATH=%_bindir/python3 \
   -DCMAKE_C_FLAGS:STRING="%optflags" \
   -DCMAKE_CXX_FLAGS:STRING="%optflags" \
   -DENABLE_SHARED=ON \
   -DBUILD_SHARED_LIBS=ON \
   %nil
%cmake_build

%install
%cmake_install

mkdir -p %buildroot%_sysconfdir
sed -e 's|^port =.*$|port = /dev/ttyS0|' \
         -e 's|^connection =.*$|connection = dlr3|' \
         -e 's|^#use_locking =.*$|use_locking = yes|' \
         -e 's/
$//' \
         < docs/config/gammurc > %buildroot%_sysconfdir/%{name}rc
chmod 644 %buildroot%_sysconfdir/%{name}rc

mkdir -p %buildroot%_gammu_docdir/other/
cp -R contrib/bash-completion %buildroot%_gammu_docdir/other/

%find_lang --output=%name.lang gammu
%find_lang --output=%name.lang --append libgammu

%check
%ctest -V -E "smsd-inject|smsd-null|gammu-dummy|gammu-copyringtone|gammu-displaybitmap|smsd-daemon-null"

%files -f %name.lang
%_bindir/*
%config(noreplace) %_sysconfdir/%{name}rc
%_man1dir/*
%_man5dir/*
%_man7dir/*
%_datadir/%name/
%docdir %_gammu_docdir
%dir %_gammu_docdir
%_gammu_docdir/ChangeLog
%_gammu_docdir/COPYING
%_gammu_docdir/README*
%_gammu_docdir/examples
%_gammu_docdir/other

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%dir %_gammu_docdir
%_gammu_docdir/manual

%files -n bash-completion-%name
%_sysconfdir/bash_completion.d/%name


%changelog
