%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Name: gamescope
Version: 3.16.4
Release: alt1

Summary: Micro-compositor for video games on Wayland

Group: System/X11
License: BSD-2-Clause
Url: https://github.com/Plagman/gamescope

Source: %name-%version.tar
Source1: submodules-%name-%version.tar
Source2: stb.pc

Patch1: gamescope-alt-NestedRefresh60.patch
Patch2: 0001-cstdint.patch
Patch3: Allow-to-use-system-wlroots.patch
Patch4: Switch-wlroots-to-the-new-pc-filename.patch
Patch5: Add-pixman-dependency.patch
Patch6: Add-libudev-dependency.patch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libstb-devel
BuildRequires: libliftoff-devel
BuildRequires: libbenchmark-devel
BuildRequires: libglm-devel
BuildRequires: hwdata-devel
BuildRequires: libwlroots0.18-devel
BuildRequires: pipewire-libs-devel
BuildRequires: libX11-devel
BuildRequires: libXdamage-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXrender-devel
BuildRequires: libXext-devel
BuildRequires: libXfixes-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libXtst-devel
BuildRequires: libXres-devel
BuildRequires: libdrm-devel
BuildRequires: libvulkan-devel
BuildRequires: libwayland-server-devel
BuildRequires: libwayland-client-devel
BuildRequires: wayland-protocols
BuildRequires: libxkbcommon-devel
BuildRequires: libcap-devel
BuildRequires: libSDL2-devel
BuildRequires: glslang-devel
BuildRequires: libinput-devel
BuildRequires: libXmu-devel
BuildRequires: libdisplay-info-devel
BuildRequires: libXcursor-devel
BuildRequires: libavif-devel
BuildRequires: spirv-headers
BuildRequires: libopenvr-devel
BuildRequires: libpixman-devel
BuildRequires: libseat1-devel
BuildRequires: xorg-xwayland-devel
BuildRequires: libxcbutil-devel
BuildRequires: libxcbutil-errors-devel
BuildRequires: pkgconfig(libdecor-0)
BuildRequires: pkgconfig(xcb-ewmh)
BuildRequires: libei-devel
BuildRequires: git-core
BuildRequires: libluajit-devel
BuildRequires: libudev-devel

ExclusiveArch: %ix86 x86_64 aarch64

%description
Gamescope is the micro-compositor optimized for running video games on Wayland.

%prep
%setup -a1
%autopatch -p1

mkdir -p pkgconfig
cp -v %SOURCE2 pkgconfig/stb.pc

# use system spirv headers
sed -i 's^../thirdparty/SPIRV-Headers/include/spirv/^/usr/include/spirv/^' src/meson.build
rm -rv thirdparty/SPIRV-Headers

# use system libraries
rm -rv subprojects/{libdisplay-info,libliftoff,openvr,wlroots}

%build
export PKG_CONFIG_PATH=pkgconfig
%meson \
    -Davif_screenshots=enabled \
    -Dbenchmark=enabled \
    -Ddrm_backend=enabled \
    -Denable_gamescope=true \
    -Denable_gamescope_wsi_layer=true \
    -Denable_openvr_support=true \
    -Dforce_fallback_for=[] \
    -Dinput_emulation=enabled \
    -Dpipewire=enabled \
    -Drt_cap=disabled \
    -Dsdl2_backend=enabled \
    %nil

%meson_build -v

%install
DESTDIR=%buildroot meson install -C %_cmake__builddir --skip-subprojects

%files
%doc LICENSE README.md
%_bindir/gamescope
%_bindir/gamescopectl
%_bindir/gamescopereaper
%_bindir/gamescopestream
%_libdir/libVkLayer_FROG_gamescope_wsi_*.so
%_datadir/vulkan/implicit_layer.d/VkLayer_FROG_gamescope_wsi.*.json
%_datadir/%name/

%changelog
