%def_enable snapshot
%define _name g4music
%define ver_major 4.6
%define rdn_name com.github.neithern.%_name

%def_disable check

Name: %_name
Version: %ver_major
Release: alt1

Summary: Play your music elegantly
License: GPL-3.0-or-later
Group: Sound
Url: https://gitlab.gnome.org/neithern/g4music

Vcs: https://gitlab.gnome.org/neithern/g4music.git

%if_disabled snapshot
Source: %url/-/archive/v%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%define gtk_ver 4.16
%define adwaita_ver 1.6
%define gst_ver 1.24

Requires: gst-plugins-base1.0 >= %gst_ver
Requires: gst-plugins-bad1.0 >= %gst_ver

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools
BuildRequires: desktop-file-utils /usr/bin/appstreamcli
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: pkgconfig(gstreamer-1.0)
BuildRequires: pkgconfig(gstreamer-tag-1.0)

%description
Gapless (AKA: G4Music) is a fast fluent lightweight music player written
in GTK4, with a beautiful and adaptive user interface, focuses on high
performance for large music collection.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang %_name

appstreamcli metainfo-to-news --format text data/app.metainfo.xml.in NEWS

%check
%__meson_test

%files -f %_name.lang
%_bindir/%_name
%_desktopdir/%rdn_name.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/dbus-1/services/%rdn_name.service
%_iconsdir/hicolor/*/apps/%{rdn_name}*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README* NEWS


%changelog
