%global _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

Name:		fscrypt
Version: 0.3.6
Release: alt1
Summary:	A tool for managing Linux filesystem encryption

Group:		System/Kernel and hardware
License:	Apache-2.0
URL:		https://github.com/google/fscrypt

Source:     %name-%version.tar

ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-macros-golang
BuildRequires: libpam0-devel
# older cgo versions can't handle LTO
BuildRequires: golang >= 1.17
%{?!_without_check:%{?!_disable_check:BuildRequires: rpm-build-vm e2fsprogs expect keyutils}}

%description
fscrypt is a high-level tool for the management of Linux native filesystem
encryption[1]. fscrypt manages metadata, key generation, key wrapping,
PAM integration, and provides a uniform interface for creating and
modifying encrypted directories.

[1] https://www.kernel.org/doc/html/latest/filesystems/fscrypt.html

%prep
%setup

# Delete -trimpath from GO_FLAGS or else we'll miss .go sources from
# debuginfo.
sed -i '/-trimpath/d' Makefile

%build
%make_build \
    CFLAGS="%optflags" \
    GO_FLAGS="-buildmode=pie -x" \
    GO_LINK_FLAGS="" \
    TAG_VERSION="v%version-%release"

%install
%makeinstall_std \
    PREFIX="/usr" \
    PAM_MODULE_DIR="/%_lib/security"
rm -r %buildroot%_datadir/pam-configs
install -Dm0644 .gear/%name.pam %buildroot%_sysconfdir/pam.d/%name

%check
sed -i 's/go test /\0 -mod=vendor /' Makefile
vm-run --kvm=cond --sbin --user --udevd \
	make test-setup test test-teardown

%files
%_bindir/%name
/%_lib/security/*.so
%_datadir/bash-completion/completions/%name
%_sysconfdir/pam.d/%name
%doc *.md

%changelog
