Name: friture
Version: 0.54
Release: alt1

Summary: Realtime audio data visualizer
License: GPLv3
Group: Sound
Url: https://friture.org/

Source: %name-%version-%release.tar

BuildRequires: rpm-build-pyproject
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(numpy)
BuildRequires: python3(Cython)
BuildRequires: pkgconfig(portaudio-2.0)
BuildRequires: libnumpy-py3-devel

%description
Friture is an application to visualize and analyze live audio data
in real-time. Friture displays audio data in several widgets, such as
a scope, a spectrum analyzer, or a rolling 2D spectrogram.
This program can be useful to analyze and equalize the audio response
of a hall, or for educational purposes, etc.
The name *Friture* is a french word for *frying*, also used for *noise*
in a sound.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install
install -pm0644 -D resources/images-src/window-icon.svg \
	%buildroot%_iconsdir/hicolor/scalable/apps/friture.svg

# extensions built against stable API, drop versioned ABI req
%filter_from_requires /%python3_ABI_dep/d

%files
%doc README* INSTALL* COPYING*
%_bindir/friture
%_desktopdir/friture.desktop
%_iconsdir/*/*/*/friture.*
%python3_sitelibdir/friture
%python3_sitelibdir/friture_extensions
%python3_sitelibdir/friture-%version.dist-info

%changelog
