%define _unpackaged_files_terminate_build 1
%def_with ffmpeg
%def_with x264
%def_without directfb
%def_with gss
# Conflicts with openssl
%def_without mbedtls
%def_with SDL
%def_without uwac
%define sover 3
%define oname freerdp

Name: freerdp%sover
Version: 3.17.2
Release: alt1

Group: Networking/Remote access
Summary: Remote Desktop Protocol functionality
License: Apache-2.0
URL: http://www.freerdp.com

ExcludeArch: armh

Source: %oname-%version.tar
Source1: freerdp-server.service
Source2: freerdp-login.sh
Source3: freerdp-logout.sh
Source4: freerdp.sysconfig
Source5: freerdp-server.pam
Source6: locker.sh
Source7: freerdp-locker.service
Source8: freerdp-locker.timer

Patch0: freerdp-alt-pam-check.patch
Patch1: freerdp-alt-connection-scripts.patch
Patch2: freerdp-alt-use-pam-module-freerdp-server.patch

Requires: xfreerdp%sover = %EVR
Requires: wlfreerdp%sover = %EVR

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: extra-cmake-modules
BuildRequires: docbook-style-xsl git-core xmlto libpcre-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(libpcsclite)
BuildRequires: pkgconfig(libsystemd)
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-scanner)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xinerama)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xkbfile)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xv)
BuildRequires: pkgconfig(gstreamer-1.0)
BuildRequires: pkgconfig(gstreamer-plugins-base-1.0)
BuildRequires: pkgconfig(libpulse)
%{?_with_directfb:BuildRequires: pkgconfig(directfb)}
BuildRequires: libcups-devel libjpeg-devel zlib-devel
%{?_with_ffmpeg:BuildRequires: libavcodec-devel libavutil-devel libswresample-devel}
%{?_with_x264:BuildRequires: libx264-devel}
BuildRequires: libkrb5-devel
BuildRequires: wayland-devel
%if_with mbedtls
BuildRequires: libmbedtls-compat-devel
%endif
BuildRequires: libgsm-devel
BuildRequires: liblame-devel
BuildRequires: libfaad-devel
BuildRequires: libfaac-devel
BuildRequires: libsoxr-devel
BuildRequires: libffi-devel
BuildRequires: liborc-devel
BuildRequires: libicu-devel
BuildRequires: libcairo-devel
BuildRequires: libpixman-devel
BuildRequires: libexpat-devel
BuildRequires: libXdmcp-devel
BuildRequires: bzlib-devel
BuildRequires: libuuid-devel
BuildRequires: libudev-devel
BuildRequires: libusb-devel
BuildRequires: libpam-devel
BuildRequires: libdbus-glib-devel
BuildRequires: patchelf
%if_with SDL
BuildRequires: libSDL2-devel
BuildRequires: libSDL2_ttf-devel
BuildRequires: libwebkit2gtk-devel
%endif
BuildRequires: libcjson-devel
BuildRequires: libfuse3-devel
BuildRequires: libopenh264-devel
BuildRequires: libpkcs11-helper-devel
BuildRequires: libswscale-devel
BuildRequires: liburiparser-devel

%description
freerdp implements Remote Desktop Protocol (RDP), used in a number of Microsoft
products. Rdesktop analog.

This is metapackage.

%package -n xfreerdp%sover
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
Requires: lib%name = %EVR
Conflicts: xfreerdp

%description -n xfreerdp%sover
xfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains X11 UI.

%package -n dfreerdp%sover
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
Requires: lib%name = %EVR
Conflicts: dfreerdp

%description -n dfreerdp%sover
dfbfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains DirectFB UI.

%package -n wlfreerdp%sover
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
Requires: lib%name = %EVR
Conflicts: wlfreerdp

%description -n wlfreerdp%sover
wlfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains Wayland UI.

%package -n lib%name
Summary: Core libraries implementing the RDP protocol
Group: System/Libraries

%description -n lib%name
libfreerdp can be embedded in applications.

%package -n lib%name-server
Summary: Remote Desktop Viewer server library
Group: System/Libraries

%description -n lib%name-server
FreeRDP is a client-side implementation of the Remote Desktop Protocol (RDP)
following the Microsoft Open Specifications. This package provides the shared
libraries used by the server.

%package -n libwinpr%sover
Summary: Windows Portable Runtime
Group: System/Libraries

%description -n libwinpr%sover
WinPR provides API compatibility for applications targeting non-Windows
environments. When on Windows, the original native API is being used instead of
the equivalent WinPR implementation, without having to modify the code using it.

%package -n libwinpr%sover-devel
Summary: Windows Portable Runtime development files
Group: Development/C
Requires: libwinpr%sover = %EVR

%description -n libwinpr%sover-devel
The libwinpr-devel package contains libraries and header files for
developing applications that use libwinpr.

%package -n libuwac%sover
Summary: Use wayland as a client
Group: System/Libraries

%description -n libuwac%sover
Remote Desktop Toolkit library. Contains the libuwac libraries.

%package -n libuwac%sover-devel
Summary: Remote Desktop Toolkit libuwac development files
Group: Development/C
Requires: libuwac%sover = %EVR

%description -n libuwac%sover-devel
The libuwac-devel package contains libraries and header files for
developing applications that use libuwac.

%package -n librdtk%sover
Summary: Use wayland as a client
Group: System/Libraries

%description -n librdtk%sover
Remote Desktop Toolkit library. Contains the librdtk libraries.

%package -n librdtk%sover-devel
Summary: Remote Desktop Toolkit librdtk development files
Group: Development/C
Requires: librdtk%sover = %EVR

%description -n librdtk%sover-devel
The librdtk-devel package contains libraries and header files for
developing applications that use librdtk.

%package -n lib%name-devel
Summary: Libraries and header files for embedding and extending freerdp
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Header files and unversioned libraries for libfreerdp.

%package -n %name-server
Summary: Server support for %{name}
Group: Networking/Remote access
Requires: lib%name = %EVR
Requires: lib%name-server = %EVR
Conflicts: freerdp-server

%description -n %name-server
The %{name}-server package contains servers which can export a desktop via
the RDP protocol.

%prep
%setup -n %oname-%version
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%cmake \
  -GNinja \
  -DBUILD_TESTING=OFF \
  -DWINPR_HAVE_AIO_H=1 \
  -DWINPR_HAVE_EXECINFO_BACKTRACE=1 \
  -DWINPR_HAVE_EXECINFO_BACKTRACE_SYMBOLS=1 \
  -DWINPR_HAVE_EXECINFO_BACKTRACE_SYMBOLS_FD=1 \
  -DWINPR_HAVE_EXECINFO_HEADER=1 \
  -DWINPR_HAVE_FCNTL_H=1 \
  -DWINPR_HAVE_GETLOGIN_R=1 \
  -DWINPR_HAVE_GETPWUID_R=1 \
  -DWINPR_HAVE_INTTYPES_H=1 \
  -DWINPR_HAVE_POLL_H=1 \
  -DWINPR_HAVE_PTHREAD_MUTEX_TIMEDLOCK_LIB=1 \
  -DWINPR_HAVE_PTHREAD_MUTEX_TIMEDLOCK_LIBS= \
  -DWINPR_HAVE_PTHREAD_MUTEX_TIMEDLOCK_SYMBOL=1 \
  -DWINPR_HAVE_STDBOOL_H=1 \
  -DWINPR_HAVE_STDINT_H=1 \
  -DWINPR_HAVE_STRERROR_R=1 \
  -DWINPR_HAVE_STRNDUP=1 \
  -DWINPR_HAVE_SYSLOG_H=1 \
  -DWINPR_HAVE_SYS_EVENTFD_H=1 \
  -DWINPR_HAVE_SYS_FILIO_H= \
  -DWINPR_HAVE_SYS_SELECT_H=1 \
  -DWINPR_HAVE_SYS_SOCKIO_H= \
  -DWINPR_HAVE_SYS_TIMERFD_H=1 \
  -DWINPR_HAVE_TM_GMTOFF=1 \
  -DWINPR_HAVE_UNISTD_H=1 \
  -DWINPR_HAVE_UNWIND_H=1 \
  -DWITH_ABSOLUTE_PLUGIN_LOAD_PATHS=ON \
  -DWITH_ADD_PLUGIN_TO_RPATH=OFF \
  -DWITH_AVX2=ON \
  -DWITH_AVX2_AVAILABLE=1 \
  -DWITH_BINARY_VERSIONING=OFF \
  -DWITH_CCACHE=ON \
  -DWITH_CHANNELS=ON \
  -DWITH_CJSON_REQUIRED=OFF \
  -DWITH_CLANG_FORMAT=ON \
  -DWITH_CLIENT=ON \
  -DWITH_CLIENT_AVAILABLE=1 \
  -DWITH_CLIENT_CHANNELS=ON \
  -DWITH_CLIENT_CHANNELS_AVAILABLE=1 \
  -DWITH_CLIENT_COMMON=ON \
  -DWITH_CLIENT_INTERFACE=OFF \
  -DWITH_CLIENT_SDL=ON \
  -DWITH_CLIENT_SDL2=ON \
  -DWITH_CLIENT_SDL3=OFF \
  -DWITH_CLIENT_SDL_AVAILABLE=1 \
  -DWITH_CLIENT_SDL_VERSIONED=OFF \
  -DWITH_CUPS=ON \
  -DWITH_DEBUG_ALL=OFF \
  -DWITH_DEBUG_CAPABILITIES=OFF \
  -DWITH_DEBUG_CERTIFICATE=OFF \
  -DWITH_DEBUG_CHANNELS=OFF \
  -DWITH_DEBUG_CLIPRDR=OFF \
  -DWITH_DEBUG_CODECS=OFF \
  -DWITH_DEBUG_DVC=OFF \
  -DWITH_DEBUG_EVENTS=OFF \
  -DWITH_DEBUG_KBD=OFF \
  -DWITH_DEBUG_LICENSE=OFF \
  -DWITH_DEBUG_MUTEX=OFF \
  -DWITH_DEBUG_NEGO=OFF \
  -DWITH_DEBUG_NLA=OFF \
  -DWITH_DEBUG_NTLM=OFF \
  -DWITH_DEBUG_RAIL=OFF \
  -DWITH_DEBUG_RDP=OFF \
  -DWITH_DEBUG_RDPDR=OFF \
  -DWITH_DEBUG_RDPEI=OFF \
  -DWITH_DEBUG_RDPGFX=OFF \
  -DWITH_DEBUG_REDIR=OFF \
  -DWITH_DEBUG_RFX=OFF \
  -DWITH_DEBUG_RINGBUFFER=OFF \
  -DWITH_DEBUG_SCARD=OFF \
  -DWITH_DEBUG_SCHANNEL=OFF \
  -DWITH_DEBUG_SDL_EVENTS=OFF \
  -DWITH_DEBUG_SDL_KBD_EVENTS=OFF \
  -DWITH_DEBUG_SND=OFF \
  -DWITH_DEBUG_SVC=OFF \
  -DWITH_DEBUG_SYMBOLS=OFF \
  -DWITH_DEBUG_THREADS=OFF \
  -DWITH_DEBUG_TIMEZONE=OFF \
  -DWITH_DEBUG_TRANSPORT=OFF \
  -DWITH_DEBUG_TSG=OFF \
  -DWITH_DEBUG_TSMF=OFF \
  -DWITH_DEBUG_TSMF_AVAILABLE=0 \
  -DWITH_DEBUG_URBDRC=OFF \
  -DWITH_DEBUG_WND=OFF \
  -DWITH_DEBUG_X11=OFF \
  -DWITH_DEBUG_X11_LOCAL_MOVESIZE=OFF \
  -DWITH_DEBUG_XV=OFF \
  -DWITH_DIRECTFB=OFF \
  -DWITH_DOCUMENTATION=OFF \
  -DWITH_DSP_EXPERIMENTAL=OFF \
  -DWITH_DSP_FFMPEG=ON \
  -DWITH_DSP_FFMPEG_AVAILABLE=1 \
  -DWITH_EVENTFD_READ_WRITE=1 \
  -DWITH_FDK_AAC=OFF \
  -DWITH_FFMPEG=ON \
  -DWITH_FREERDP_DEPRECATED=OFF \
  -DWITH_FREERDP_DEPRECATED_COMMANDLINE=OFF \
  -DWITH_FULL_CONFIG_PATH=OFF \
  -DWITH_FUSE=ON \
  -DWITH_GFX_FRAME_DUMP=OFF \
  -DWITH_GFX_H264=ON \
  -DWITH_GPROF=OFF \
  -DWITH_GSTREAMER_1_0=ON \
  -DWITH_ICU=ON \
  -DWITH_INTERNAL_MD4=OFF \
  -DWITH_INTERNAL_MD5=OFF \
  -DWITH_INTERNAL_RC4=OFF \
  -DWITH_IPP=OFF \
  -DWITH_JPEG=ON \
  -DWITH_JSONC_REQUIRED=OFF \
  -DWITH_JSON_DISABLED=OFF \
  -DWITH_KEYBOARD_LAYOUT_FROM_FILE=OFF \
  -DWITH_KRB5=ON \
  -DWITH_KRB5_NO_NTLM_FALLBACK=OFF \
  -DWITH_LIBRARY_VERSIONING=ON \
  -DWITH_LIBRESSL=OFF \
  -DWITH_LODEPNG=OFF \
  -DWITH_MACAUDIO=OFF \
  -DWITH_MACAUDIO_AVAILABLE=0 \
  -DWITH_MANPAGES=ON \
  -DWITH_MBEDTLS=OFF \
  -DWITH_NATIVE_SSPI=OFF \
  -DWITH_NEON=OFF \
  -DWITH_OPENCL=OFF \
  -DWITH_OPENH264_LOADING=OFF \
  -DWITH_OPENSSL=ON \
  -DWITH_OPUS=OFF \
  -DWITH_OSS=ON \
  -DWITH_PCSC=ON \
  -DWITH_PKCS11=ON \
  -DWITH_PLATFORM_SERVER=ON \
  -DWITH_POLL=ON \
  -DWITH_PROFILER=OFF \
  -DWITH_PROXY=ON \
  -DWITH_PROXY_APP=ON \
  -DWITH_PROXY_EMULATE_SMARTCARD=OFF \
  -DWITH_PROXY_MODULES=ON \
  -DWITH_PULSE=ON \
  -DWITH_RDTK=ON \
  -DWITH_SAMPLE=ON \
  -DWITH_SANITIZE_ADDRESS=OFF \
  -DWITH_SANITIZE_ADDRESS_AVAILABLE=1 \
  -DWITH_SANITIZE_MEMORY=OFF \
  -DWITH_SANITIZE_MEMORY_AVAILABLE=1 \
  -DWITH_SANITIZE_THREAD=OFF \
  -DWITH_SANITIZE_THREAD_AVAILABLE=1 \
  -DWITH_SDL_IMAGE_DIALOGS=OFF \
  -DWITH_SDL_LINK_SHARED=ON \
  -DWITH_SERVER=ON \
  -DWITH_SERVER_CHANNELS=ON \
  -DWITH_SERVER_INTERFACE=ON \
  -DWITH_SHADOW=ON \
  -DWITH_SHADOW_MAC=ON \
  -DWITH_SHADOW_X11=ON \
  -DWITH_SMARTCARD_EMULATE=ON \
  -DWITH_SMARTCARD_INSPECT=OFF \
  -DWITH_SMARTCARD_PCSC=ON \
%ifarch x86_64 %e2k
  -DWITH_SSE2=ON \
%else
  -DWITH_SSE2=OFF \
%endif
%ifarch armh
  -DARM_FP_ABI=hard \
  -DWITH_NEON=OFF \
%endif
  -DWITH_SWSCALE=ON \
  -DWITH_SYSTEMD=ON \
  -DWITH_THIRD_PARTY=OFF \
  -DWITH_TIMEZONE_COMPILED=ON \
  -DWITH_TIMEZONE_FROM_FILE=OFF \
  -DWITH_TIMEZONE_ICU=OFF \
  -DWITH_UNICODE_BUILTIN=OFF \
  -DWITH_VAAPI=O \
%if_without uwac
  -DUWAC_FORCE_STATIC_BUILD=ON \
%endif
%ifarch %e2k
  -DCMAKE_C_FLAGS_RELEASE="-O%_optlevel -DNDEBUG"
%endif


%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"

rm -f %buildroot%_libdir/*.a \
      %buildroot%_libdir/freerdp/*.a

%ifnarch %e2k
# Set rpath to %_libdir/freerdp3 for freerdp-proxy executable
# (NB: patchelf damages e2k binaries but is unneeded as of 3.16.0)
patchelf --set-rpath %_libdir/freerdp3 %buildroot%_bindir/freerdp-proxy
%endif

# Install services and timers
install -Dpm0644 %SOURCE1 %buildroot%_libexecdir/systemd/user/freerdp-server.service
install -Dpm0644 %SOURCE7 %buildroot%_libexecdir/systemd/user/freerdp-locker.service
install -Dpm0644 %SOURCE8 %buildroot%_libexecdir/systemd/user/freerdp-locker.timer

# Remove sample server
rm -f %buildroot%_bindir/sfreerdp*

# Remove icons
rm -rf %buildroot%_datadir/FreeRDP/images/test_*.*

%if_with SDL
rm -f %buildroot%_bindir/sdl-freerdp %buildroot%_man1dir/sdl-freerdp.1*
%endif

# Install connection scripts
install -Dpm0755 %SOURCE2 %buildroot%_sysconfdir/freerdp/freerdp-login.sh
install -Dpm0755 %SOURCE3 %buildroot%_sysconfdir/freerdp/freerdp-logout.sh
install -Dpm0755 %SOURCE6 %buildroot%_sysconfdir/freerdp/freerdp-locker.sh

# Install default configuration for freerdp-server.service
install -Dpm0644 %SOURCE4 %buildroot%_sysconfdir/sysconfig/freerdp-server

# Install PAM module
install -Dpm0644 %SOURCE5 %buildroot%_sysconfdir/pam.d/freerdp-server

%files

%files -n xfreerdp%sover
%_bindir/xfreerdp
%_man1dir/xfreerdp*
%_bindir/winpr-*
%_man1dir/winpr-*
%_man7dir/wlog*

%files -n wlfreerdp%sover
%_bindir/wlfreerdp
%_man1dir/wlfreerdp*

%if_with directfb
%files -n dfreerdp%sover
%_bindir/dfreerdp
%endif

%files -n %name-server
%_bindir/freerdp-proxy
%config(noreplace) %_libexecdir/systemd/user/freerdp-server.service
%config(noreplace) %_libexecdir/systemd/user/freerdp-locker.service
%config(noreplace) %_libexecdir/systemd/user/freerdp-locker.timer
%config(noreplace) %attr(0755, root, root) %_sysconfdir/freerdp/freerdp-login.sh
%config(noreplace) %attr(0755, root, root) %_sysconfdir/freerdp/freerdp-logout.sh
%config(noreplace) %attr(0755, root, root) %_sysconfdir/freerdp/freerdp-locker.sh
%config(noreplace) %_sysconfdir/sysconfig/freerdp-server
%config(noreplace) %_sysconfdir/pam.d/freerdp-server
%attr(2711, root, chkpwd) %_bindir/freerdp-shadow-cli
%_man1dir/freerdp-shadow-cli.1*
%_man1dir/freerdp-proxy.1*
%_libdir/freerdp*/proxy

%files -n lib%name
%doc LICENSE README.md ChangeLog
%_libdir/lib%{oname}3.so.*
%_libdir/lib%{oname}-client3.so.*
%dir %_libdir/freerdp*

%files -n lib%name-server
%_libdir/lib%{oname}-server3.so.*
%_libdir/lib%{oname}-server-proxy3.so.*
%_libdir/lib%{oname}-shadow-subsystem3.so.*
%_libdir/lib%{oname}-shadow3.so.*

%files -n libwinpr%sover
%_libdir/libwinpr3.so.*
%_libdir/libwinpr-tools3.so.*

%files -n libwinpr%sover-devel
%_libdir/cmake/WinPR*
%_includedir/winpr*
%_libdir/libwinpr3.so
%_libdir/libwinpr-tools3.so
%_pkgconfigdir/winpr*.pc

%if_with uwac
%files -n libuwac%sover
%_libdir/libuwac0.so.*

%files -n libuwac%sover-devel
%_libdir/cmake/uwac*
%_includedir/uwac*
%_libdir/libuwac0.so
%_pkgconfigdir/uwac*.pc
%endif

%files -n librdtk%sover
%_libdir/librdtk0.so.*

%files -n librdtk%sover-devel
%_libdir/cmake/rdtk*
%_includedir/rdtk*
%_libdir/librdtk0.so
%_pkgconfigdir/rdtk*.pc

%files -n lib%name-devel
%_libdir/cmake/FreeRDP*
%_includedir/%{name}*
%_libdir/libfreerdp*.so
%_pkgconfigdir/freerdp*.pc

%changelog
