# build defines
%define _unpackaged_files_terminate_build 1
%define bash_completions_dir %_datadir/bash-completion/completions

%ifarch %ix86 armh
%def_with only_client
%else
%def_without only_client
%endif

%def_without docs

%if_without only_client
%def_with fasttest
# don't remove: it's used on local build
%def_without lint
%endif

%if_with lint
    %define linter_options --enable-pylint
%else
    %define linter_options --disable-pylint
%endif

# paths defines
%define _libexecdir /usr/libexec
%define plugin_dir %_libdir/dirsrv/plugins
%define _localstatedir %_var
%define _runtimedir /run
%define plugin_dir %_libdir/dirsrv/plugins
%define etc_systemd_dir %_sysconfdir/systemd/system

# versions defines
# https://bugzilla.altlinux.org/40688
%define apache_version 1:2.4.48-alt5

%define bind_version 9.11
%define bind_dyndb_ldap_version 11.1-alt7
%define certmonger_version 0.79.17
# https://www.freeipa.org/release-notes/4-12-5.html
# CVE-2025-7493 requires https://github.com/389ds/389-ds-base/issues/6857
%define ds_version 3.1.3-alt3
%define gssproxy_version 0.8.0-alt2
%define krb5_version 1.16.3
%define pki_version 10.10.5
%define python_ldap_version 3.2.0
%define samba_version 4.7.6
# RHBZ#1958909, RHBZ#1967906
%define slapi_nis_version 0.56.7-alt2
%define sssd_version 2.7.0
%define openldap_version 2.4.47-alt2
%define opendnssec_version 2.1.9-alt1
%define libp11_version 0.4.10-alt2

Name: freeipa
# don't forget to update .gear/rules
Version: 4.12.5
Release: alt3

Summary: The Identity, Policy and Audit system
License: GPLv3+
Group: System/Base

Url: http://www.freeipa.org/
Source0: %name-%version.tar
Source1: freeipa-server.filetrigger
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: libcmocka-devel
BuildRequires: libini_config-devel
BuildRequires: libkrb5-devel >= %krb5_version
BuildRequires: libpopt-devel
BuildRequires: libsasl2-devel
BuildRequires: libssl-devel
BuildRequires: libsystemd-devel
BuildRequires: libjansson-devel
BuildRequires: libcurl-devel
BuildRequires: openldap-devel >= %openldap_version

%if_without only_client
BuildRequires(pre): rpm-macros-apache2

BuildRequires: libuuid-devel
BuildRequires: libsss_idmap-devel
BuildRequires: libsss_certmap-devel
BuildRequires: libsss_nss_idmap-devel >= %sssd_version
BuildRequires: libunistring-devel

BuildRequires: 389-ds-base-devel >= %ds_version
BuildRequires: samba-devel >= %samba_version
BuildRequires: nodejs
BuildRequires: python3(rjsmin)
BuildRequires: python3-module-argcomplete
%endif # only_client

# python
BuildRequires: python3-module-lesscpy
BuildRequires: python3-module-setuptools
#
# Build dependencies for makeapi/makeaci
#
BuildRequires: python3-module-cffi
BuildRequires: python3-module-dns
BuildRequires: python3-module-ldap >= %python_ldap_version
BuildRequires: python3-module-netaddr
BuildRequires: python3-module-pyasn1
BuildRequires: python3-module-pyasn1-modules
BuildRequires: python3-module-six
BuildRequires: python3-module-sss_nss_idmap

#
# Build dependencies for wheel packaging and PyPI upload
#
%if_with wheels
BuildRequires: python3(tox)
BuildRequires: python3(twine)
BuildRequires: python3(wheel)
%endif

%if_with docs
BuildRequires: python3(sphinx)
BuildRequires: plantuml
BuildRequires: fontconfig
BuildRequires: fonts-ttf-google-noto-sans-vf
%endif

%if 0%{?_with_fasttest:1}%{?_with_lint:1}
BuildRequires: python3(cryptography)
BuildRequires: python3(dbus)
BuildRequires: python3(gssapi)
BuildRequires: python3(pysss_murmur)
BuildRequires: python3(lxml)
BuildRequires: python3-module-pki-base >= %pki_version
BuildRequires: python3-module-ldap >= %python_ldap_version
BuildRequires: python3(polib)
BuildRequires: python3(pytest)
BuildRequires: python3(pytest-multihost)
BuildRequires: python3-module-sssdconfig >= %sssd_version
BuildRequires: python3(ifaddr)
BuildRequires: python3(jwcrypto)
BuildRequires: python3(augeas)
BuildRequires: python3(sqlite3)
BuildRequires: python3(pexpect)
BuildRequires: python3(psutil)
BuildRequires: python3(netaddr)
BuildRequires: python3(jinja2)
BuildRequires: python3(pyasn1)
BuildRequires: python3(pyasn1_modules)
BuildRequires: python3(pysss_nss_idmap)
BuildRequires: python3(yubico)
BuildRequires: python3(requests)
# urllib3.util.ssl_match_hostname
BuildRequires: python3-module-urllib3 >= 1.26.8
BuildRequires: python3(dateutil)
BuildRequires: python3(dns)
BuildRequires: python3(pyhbac)
BuildRequires: python3(yaml)
BuildRequires: python3(systemd)
BuildRequires: python3(pysss)
BuildRequires: python3(pytest_sourceorder)
BuildRequires: python3-module-lib389 >= %ds_version
BuildRequires: python3(qrcode)
# python3(samba) has multiple providers
BuildRequires: python3-module-samba
%endif

%if_with fasttest
BuildRequires: chrony
BuildRequires: keyutils
BuildRequires: systemd
BuildRequires: softhsm
BuildRequires: nss-utils
BuildRequires: gnupg2
%endif

%if_with lint
BuildRequires: git-core
BuildRequires: python3(pylint)
BuildRequires: python3(pycodestyle)
BuildRequires: python3(docker)
BuildRequires: python3(sphinx)
BuildRequires: python3-module-paramiko
%endif

%description
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).

###############################################################################

%if_without only_client
%package server
Summary: The IPA authentication server
Group: System/Base
Requires: %name-client = %EVR
Requires: acl
Requires: gssproxy >= %gssproxy_version
Requires: sssd-dbus >= %sssd_version
Requires: pki-ca >= %pki_version
Requires: pki-kra >= %pki_version
Requires: pki-acme >= %pki_version
Requires: certmonger >= %certmonger_version
Requires: 389-ds-base >= %ds_version
# https://pagure.io/freeipa/issue/8632
Requires: openssl > 1.1.1j
Requires: softhsm
Requires: libp11-kit
Requires: gzip
Requires: oddjob
Requires: 389-ds-base >= %ds_version
Requires: openldap-clients >= %openldap_version
Requires: nss-utils
Requires: krb5-kdc >= %krb5_version
Requires: libsasl2-plugin-gssapi
Requires: fonts-font-awesome
Requires: fonts-ttf-open-sans
Requires: apache2-mod_auth_gssapi
Requires: apache2-mod_ssl
Requires: apache2-mod_lookup_identity
Requires: apache2-mod_wsgi-py3
Requires: python3-module-ipaserver = %EVR
Requires: python3-module-ldap >= %python_ldap_version
Requires: python3-module-gssapi
Requires: python3-module-systemd
Requires: slapi-nis >= %slapi_nis_version

# Versions of nss-pam-ldapd < 0.8.4 require a mapping from uniqueMember to
# member.
Conflicts: nss-ldapd < 0.8.4

%add_python3_path %_datadir/ipa/
%add_python3_compile_exclude %_datadir/ipa/
# not public packages and modules
%filter_from_provides /python3(wsgi\(\..*\)\?)/d
%filter_from_provides /python3(migration\(\..*\)\?)/d

%description server
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If you are installing an IPA server, you need to install this package.

###############################################################################

%package -n python3-module-ipaserver
Summary: Python libraries used by IPA server
Group: System/Libraries
Requires: %name-server-common = %EVR
Requires: python3-module-augeas
Requires: python3-module-gssapi
Requires: python3-module-ipaclient = %EVR
Requires: python3-module-kdcproxy
Requires: python3-module-ldap >= %python_ldap_version
Requires: python3-module-pki-base >= %pki_version
Requires: python3-module-sssdconfig >= %sssd_version
Requires: python3-module-samba
Requires: python3-module-psutil
# urllib3.util.ssl_match_hostname
Requires: python3-module-urllib3 >= 1.26.8
Requires: python3-module-packaging
Requires: librpm
Obsoletes: python3-module-ipaserver-ntp < %EVR
Provides: python3-module-ipaserver-ntp = %EVR

%description -n python3-module-ipaserver
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If you are installing an IPA server, you need to install this package.

###############################################################################

%package server-common
Summary: Common files used by IPA server
Group: System/Base
Requires: %name-client-common = %EVR
Requires: apache2-base >= %apache_version

%description server-common
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If you are installing an IPA server, you need to install this package.

###############################################################################

%package server-dns
Summary: IPA integrated DNS server with support for automatic DNSSEC signing
Group: System/Base
Requires: %name-server = %EVR
Requires: bind-dyndb-ldap >= %bind_dyndb_ldap_version
Requires: bind >= %bind_version
Requires: bind-utils >= %bind_version
Requires: opendnssec >= %opendnssec_version
Requires: libp11 >= %libp11_version

%description server-dns
IPA integrated DNS server with support for automatic DNSSEC signing.
Integrated DNS server is BIND 9. OpenDNSSEC provides key management.

###############################################################################

%package server-trust-ad
Summary: Virtual package to install packages required for Active Directory trusts
Group: System/Base
Requires: %name-server = %EVR
Requires: %name-common = %EVR
# see https://bugzilla.altlinux.org/50444
# deps: ipaserver/install/adtrustinstance.py:check_inst
# /usr/sbin/smbd
Requires: samba >= %samba_version
# /usb/bin/net
Requires: samba-common-tools >= %samba_version
Requires: samba-winbind
Requires: python3-module-samba
Requires: python3-module-sss_nss_idmap
Requires: python3-module-sss
# only works with mit samba (/usr/sbin/smbd)
Conflicts: samba-dc

%description server-trust-ad
Cross-realm trusts with Active Directory in IPA require working Samba 4
installation. This package is provided for convenience to install all required
dependencies at once.

%endif # only_client
###############################################################################

%package client
Summary: IPA authentication for use on clients
Group: System/Base
# Requires: authselect >= 0.4-2
Requires: libsasl2-plugin-gssapi
Requires: curl
Requires: sssd-krb5
Requires: sssd-idp >= %sssd_version
Requires: sssd-ipa >= %sssd_version
Requires: sssd-tools >= %sssd_version
Requires: libsss_sudo
Requires: certmonger >= %certmonger_version
Requires: nss-utils
Requires: bind-utils
Requires: oddjob-mkhomedir
Requires: python3-module-gssapi
Requires: python3-module-ipaclient = %EVR
Requires: python3-module-ldap >= %python_ldap_version
Requires: python3-module-sssdconfig >= %sssd_version

Obsoletes: %name-admintool < 4.4.1
Provides: %name-admintools = %EVR

%description client
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If your network uses IPA for authentication, this package should be
installed on every client machine.
This package provides command-line tools for IPA administrators.

###############################################################################

%package client-samba
Summary: Tools to configure Samba on IPA client
Group: System/Base
Requires: %name-client = %EVR
Requires: python3-module-samba
Requires: samba-client
Requires: samba-winbind
Requires: samba-common-tools
Requires: samba
Requires: sssd-winbind-idmap
Requires: tdb-utils
Requires: cifs-utils

%description client-samba
This package provides command-line tools to deploy Samba domain member
on the machine enrolled into a FreeIPA environment

###############################################################################

%package client-epn
Summary: Tools to configure Expiring Password Notification in IPA
Group: System/Base
Requires: %name-client = %EVR

%description client-epn
This package provides a service to collect and send expiring password
notifications via email (SMTP).

###############################################################################

%package client-automount
Summary: IPA Automount for use on clients
Group: System/Base
Requires: %name-client = %EVR
Requires: autofs-sss
Requires: libsss_autofs
Requires: sssd-nfs-idmap
Requires: nfs-clients

%description client-automount
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If your network uses IPA for authentication and you would like to use
Automount, this package should be installed.

###############################################################################

%package -n python3-module-ipaclient
Summary: Python libraries used by IPA client
Group: System/Libraries
Requires: %name-client-common = %EVR
Requires: python3-module-freeipa = %EVR
Requires: python3-module-dns
Obsoletes: python3-module-ipaclient-ntp < %EVR
Provides: python3-module-ipaclient-ntp = %EVR

%description -n python3-module-ipaclient
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If your network uses IPA for authentication, this package should be
installed on every client machine.

###############################################################################

%package client-common
Summary: Common files used by IPA client
Group: System/Base
Requires: ca-trust

%description client-common
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If your network uses IPA for authentication, this package should be
installed on every client machine.

###############################################################################

%package -n python3-module-freeipa
Summary: Python3 libraries used by IPA
Group: System/Libraries
Requires: %name-common = %EVR
Requires: gnupg2
Requires: keyutils
Requires: less
Requires: krb5-kinit >= %krb5_version
Requires: python3-module-cffi
Requires: python3-module-ipa_hbac
Requires: python3-module-ldap >= %python_ldap_version
Requires: python3-module-pyusb
Requires: python3-module-qrcode
Requires: python3-module-requests
# urllib3.util.ssl_match_hostname
Requires: python3-module-urllib3 >= 1.26.8
Requires: python3-module-sss-murmur
Requires: python3-module-yubico
Requires: python3-module-systemd
Requires: python3-module-packaging
%py3_provides ipaplatform
%py3_provides ipaplatform.constants
%py3_provides ipaplatform.osinfo
%py3_provides ipaplatform.paths
%py3_provides ipaplatform.services
%py3_provides ipaplatform.tasks
%py3_provides ipaplatform._importhook

%description -n python3-module-freeipa
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If you are using IPA with Python 3, you need to install this package.

###############################################################################

%package common
Summary: Common files used by IPA
Group: System/Libraries

%description common
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If you are using IPA, you need to install this package.

###############################################################################

%package -n python3-module-ipatests
Summary: IPA tests and test tools
Group: System/Base
Requires: python3-module-ipaclient = %EVR
Requires: python3-module-ipaserver = %EVR
Requires: tar
Requires: xz
Requires: python3-module-sssdconfig >= %sssd_version
Requires: openssh-clients
Requires: sshpass
Requires: iptables
Requires: drill
Requires: python3-module-paramiko
Requires: python3-module-packaging
# Tests have a huge amount useless Provides
%filter_from_provides /python3(ipatests\(\..*\)\?)/d

%description -n python3-module-ipatests
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
This package contains tests that verify IPA functionality under Python 3.

###############################################################################

%prep
%setup -n %name-%version
%if_with lint
# we need it to generate cumulative patch without context
git init
git config user.email "you@example.com"
git config user.name "Your Name"
git add .
git commit -m "upstream version"
git checkout -b "patch"
%endif # lint

%patch -p1

%if_with lint
git add .
git commit -am 'with our changes'
%endif

# Port 8080 is used by alterator-ahttpd-server
if grep -rE --exclude-dir=.gear '(\W|^)8080(\W|$)' ; then
    printf '%%s\n' 'Please change port 8080 to 8090 and commit'
    exit 1
else
    [ "$?" -ne 1 ] && exit 1
fi

%build

export PYTHON=%__python3
%autoreconf
%configure --with-vendor-suffix=-%release \
%if_without only_client
           --enable-server \
           --with-password-quality-lib=no \
           --with-ipatests \
%else
           --disable-server \
           --without-ipatests \
%endif
           %linter_options
%make_build

%install
%makeinstall_std

%if_without only_client
# don't package ipasphinx for now
rm -r \
    %buildroot%python3_sitelibdir_noarch/ipasphinx \
    %buildroot%python3_sitelibdir_noarch/ipasphinx-%version-py%_python3_version.egg-info \
    %nil
%endif

# remove files which are useful only for make uninstall
find %buildroot -wholename '*/site-packages/*/install_files.txt' -exec rm {} \;

# since we package python modules as arch dependent
%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

%find_lang ipa

%if_without only_client
# Remove .la files from libtool - we don't want to package these files
rm %buildroot/%plugin_dir/libipa_pwd_extop.la
rm %buildroot/%plugin_dir/libipa_enrollment_extop.la
rm %buildroot/%plugin_dir/libipa_winsync.la
rm %buildroot/%plugin_dir/libipa_repl_version.la
rm %buildroot/%plugin_dir/libipa_uuid.la
rm %buildroot/%plugin_dir/libipa_modrdn.la
rm %buildroot/%plugin_dir/libipa_lockout.la
rm %buildroot/%plugin_dir/libipa_cldap.la
rm %buildroot/%plugin_dir/libipa_dns.la
rm %buildroot/%plugin_dir/libipa_sidgen.la
rm %buildroot/%plugin_dir/libipa_sidgen_task.la
rm %buildroot/%plugin_dir/libipa_extdom_extop.la
rm %buildroot/%plugin_dir/libipa_range_check.la
rm %buildroot/%plugin_dir/libipa_otp_counter.la
rm %buildroot/%plugin_dir/libipa_otp_lasttoken.la
rm %buildroot/%plugin_dir/libipa_graceperiod.la
rm %buildroot/%plugin_dir/libtopology.la
rm %buildroot/%_libdir/krb5/plugins/kdb/ipadb.la
rm %buildroot/%_libdir/samba/pdb/ipasam.la

# So we can own our Apache configuration
mkdir -p %buildroot%apache2_confdir/{sites-available,extra-available,extra-enabled}
/bin/touch %buildroot%apache2_sites_available/ipa.conf
/bin/touch %buildroot%apache2_extra_enabled/{ipa-kdc-proxy.conf,ipa-pki-proxy.conf,ipa-rewrite.conf}
/bin/touch %buildroot%_datadir/ipa/html/{ca.crt,krb.con,krb5.ini,krbrealm.con}

mkdir -p %buildroot%etc_systemd_dir/httpd2.service.d
touch %buildroot%etc_systemd_dir/httpd2.service.d/ipa.conf

mkdir -p %buildroot%_sysconfdir/cron.d

# bind configuration is bootstrapped by ipa installer
mkdir -p %buildroot%_sysconfdir/bind
touch %buildroot%_sysconfdir/bind/ipa-ext.conf
touch %buildroot%_sysconfdir/bind/ipa-options-ext.conf
mkdir -p %buildroot%_sharedstatedir/bind/zone/dyndb-ldap/ipa/
mkdir -p %buildroot%_sharedstatedir/bind/data
mkdir -p %buildroot%_sharedstatedir/bind/dynamic

mkdir -p %buildroot%_sharedstatedir/ipa/backup
mkdir -p %buildroot%_sharedstatedir/ipa/gssproxy
mkdir -p %buildroot%_sharedstatedir/ipa/sysrestore
mkdir -p %buildroot%_sharedstatedir/ipa/sysupgrade
mkdir -p %buildroot%_sharedstatedir/ipa/pki-ca
mkdir -p %buildroot%_sharedstatedir/ipa/certs
mkdir -p %buildroot%_sharedstatedir/ipa/private
mkdir -p %buildroot%_sharedstatedir/ipa/passwds
touch %buildroot%_sharedstatedir/ipa/pki-ca/publish
touch %buildroot%_sysconfdir/ipa/kdcproxy/ipa-kdc-proxy.conf

# install filetrigger
mkdir -p %buildroot%_rpmlibdir
install -D -p -m 0755 %SOURCE1 %buildroot%_rpmlibdir/freeipa-server.filetrigger

# We use alternatives to divert winbind_krb5_locator.so plugin to libkrb5
# on the installes where server-trust-ad subpackage is installed because
# IPA AD trusts cannot be used at the same time with the locator plugin
# since Winbindd will be configured in a different mode
mkdir -p %buildroot%_altdir
printf '%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so\t/dev/null\t90\n' > %buildroot%_altdir/winbind_krb5_locator.so

# generate bash completions
for clitool in ipa-migrate
do
    register-python-argcomplete "$clitool" > "$clitool"
    install -p -m 0644 -D -t '%buildroot%bash_completions_dir' "$clitool"
done

%endif # only_client

/bin/touch %buildroot%_sysconfdir/ipa/{default.conf,ca.crt}
# NSS
## new sql format
touch %buildroot%_sysconfdir/ipa/nssdb/pwdfile.txt
touch %buildroot%_sysconfdir/ipa/nssdb/cert9.db
touch %buildroot%_sysconfdir/ipa/nssdb/key4.db
touch %buildroot%_sysconfdir/ipa/nssdb/pkcs11.txt

mkdir -p %buildroot%_sysconfdir/pki/ca-trust/source
touch %buildroot%_sysconfdir/pki/ca-trust/source/ipa.p11-kit

mkdir -p %buildroot%_sharedstatedir/ipa-client
mkdir -p %buildroot%_sharedstatedir/ipa-client/pki
mkdir -p %buildroot%_sharedstatedir/ipa-client/sysrestore

%check
# run tests in upstream PR manner
%{?_with_lint:make "GIT_BRANCH=master" fastlint}
%{?_with_fasttest:make fasttest}
%{?_with_lint:make lint}
%make check VERBOSE=yes LIBDIR=%_libdir

%if_without only_client

%post server
/bin/systemctl daemon-reload 2>&1 ||:
# upgrade
if [ $1 -gt 1 ] ; then
    /bin/systemctl condrestart certmonger.service 2>&1 ||:
fi
/bin/systemctl try-reload-or-restart \
    dbus \
    oddjobd ||:

systemd-tmpfiles --create ipa.conf >/dev/null 2>&1 ||:

%preun server
# removal
if [ $1 -eq 0 ]; then
    /bin/systemctl -q --no-reload disable ipa.service ||:
    /bin/systemctl -q stop ipa.service ||:
    /bin/systemctl try-reload-or-restart \
        dbus \
        oddjobd ||:
fi

%pre server
# Stop ipa_kpasswd if it exists before upgrading so we don't have a
# zombie process when we're done.
if [ -e /usr/sbin/ipa_kpasswd ]; then
    /bin/systemctl stop ipa_kpasswd.service >/dev/null 2>&1 ||:
fi

%pre server-common
# create users and groups
# create kdcproxy group and user
getent group kdcproxy >/dev/null || groupadd -f -r kdcproxy ||:
getent passwd kdcproxy >/dev/null || useradd -r -g kdcproxy -s /sbin/nologin -d / -c "IPA KDC Proxy User" kdcproxy ||:
# create ipaapi group and user
getent group ipaapi >/dev/null || groupadd -f -r ipaapi ||:
getent passwd ipaapi >/dev/null || useradd -r -g ipaapi -s /sbin/nologin -d / -c "IPA Framework User" ipaapi ||:
# add apache to ipaaapi group
id -Gn apache2 | grep '\bipaapi\b' >/dev/null || usermod apache2 -a -G ipaapi ||:

%post server-dns
# first installation
if [ $1 -eq 1 ] ; then
    /bin/systemctl -q preset \
        ipa-dnskeysyncd \
        ipa-ods-exporter.socket \
        ipa-ods-exporter.service ||:
fi

%preun server-dns
# removal
# preun_service(P9) doesn't handle not *.service systemd names
if [ $1 -eq 0 ] ; then
    /bin/systemctl --no-reload disable --now \
        ipa-dnskeysyncd \
        ipa-ods-exporter.socket \
        ipa-ods-exporter.service ||:
fi

%post server-trust-ad
/bin/systemctl try-reload-or-restart \
    dbus \
    oddjobd ||:

%preun server-trust-ad
if [ $1 -eq 0 ]; then
    /bin/systemctl try-reload-or-restart \
        dbus \
        oddjobd ||:
fi
%endif # only_client

%post client
if [ $1 -gt 1 ] ; then
    # Has the client been configured?
    restore=0
    IPA_UPGRADE_LOG="/var/log/ipaupgrade.log"
    test -f '/var/lib/ipa-client/sysrestore/sysrestore.index' && restore=$(wc -l '/var/lib/ipa-client/sysrestore/sysrestore.index' | awk '{print $1}') ||:

    if [ -f '/etc/sssd/sssd.conf' -a $restore -ge 2 ]; then
        if grep -E -q '/var/lib/sss/pubconf/krb5.include.d/' /etc/krb5.conf  2>/dev/null ; then
            sed -i '\;includedir /var/lib/sss/pubconf/krb5.include.d;d' /etc/krb5.conf
        fi
    fi

    if [ $restore -ge 2 ]; then
        if grep -E -q '\s*pkinit_anchors = FILE:/etc/ipa/ca.crt$' /etc/krb5.conf 2>/dev/null; then
            sed -E 's|(\s*)pkinit_anchors = FILE:/etc/ipa/ca.crt$|\1pkinit_anchors = FILE:/var/lib/ipa-client/pki/kdc-ca-bundle.pem\n\1pkinit_pool = FILE:/var/lib/ipa-client/pki/ca-bundle.pem|' /etc/krb5.conf >/etc/krb5.conf.ipanew
            mv -Z /etc/krb5.conf.ipanew /etc/krb5.conf
            cp /etc/ipa/ca.crt /var/lib/ipa-client/pki/kdc-ca-bundle.pem
            cp /etc/ipa/ca.crt /var/lib/ipa-client/pki/ca-bundle.pem
        fi
        %__python3 -c 'from ipaclient.install.client import configure_krb5_snippet; configure_krb5_snippet()' >>"$IPA_UPGRADE_LOG" 2>&1
        %__python3 -c 'from ipaclient.install.client import update_ipa_nssdb; update_ipa_nssdb()' >>"$IPA_UPGRADE_LOG" 2>&1
        chmod 0600 "$IPA_UPGRADE_LOG"
        SSH_CLIENT_SYSTEM_CONF='/etc/openssh/ssh_config'
        if [ -f "$SSH_CLIENT_SYSTEM_CONF" ]; then
            if grep -E -q '^HostKeyAlgorithms ssh-rsa,ssh-dss$' "$SSH_CLIENT_SYSTEM_CONF" 2>/dev/null; then
                sed -E --in-place=.orig 's/^(HostKeyAlgorithms ssh-rsa,ssh-dss)$/# disabled by ipa-client update\n# \1/' "$SSH_CLIENT_SYSTEM_CONF"
            fi
        fi
    fi
fi

%triggerin client -- sssd >= 2.10
# Has the client been configured?
restore=0
test -f '/var/lib/ipa-client/sysrestore/sysrestore.index' && restore=$(wc -l '/var/lib/ipa-client/sysrestore/sysrestore.index' | awk '{print $1}') ||:
SSH_CLIENT_SYSTEM_CONF='/etc/openssh/ssh_config'
if [ -f "$SSH_CLIENT_SYSTEM_CONF" -a $restore -ge 2 ]; then
    # https://pagure.io/freeipa/issue/9536
    # upgrade sss_ssh_knownhostsproxy with sss_ssh_knownhosts
    if grep -E -q '^GlobalKnownHostsFile /var/lib/sss/pubconf/known_hosts$' "$SSH_CLIENT_SYSTEM_CONF" 2>/dev/null; then
        sed -E --in-place=.orig 's/^(GlobalKnownHostsFile \/var\/lib\/sss\/pubconf\/known_hosts)$/# disabled by ipa-client update\n# \1/' "$SSH_CLIENT_SYSTEM_CONF"
    fi
    if grep -E -q '^ProxyCommand /usr/bin/sss_ssh_knownhostsproxy -p %%p %%h$' "$SSH_CLIENT_SYSTEM_CONF" 2>/dev/null; then
        sed -E --in-place=.orig 's/^(ProxyCommand \/usr\/bin\/sss_ssh_knownhostsproxy -p %%p %%h)$/# replaced by ipa-client update\n# \1\nKnownHostsCommand \/usr\/bin\/sss_ssh_knownhosts %%H/' "$SSH_CLIENT_SYSTEM_CONF"
    fi
fi

%triggerin client -- openssh-server
# Has the client been configured?
restore=0
test -f '/var/lib/ipa-client/sysrestore/sysrestore.index' && restore=$(wc -l '/var/lib/ipa-client/sysrestore/sysrestore.index' | awk '{print $1}') ||:

if [ -f '/etc/openssh/sshd_config' -a $restore -ge 2 ]; then
    if grep -E -q '^(AuthorizedKeysCommand /usr/bin/sss_ssh_authorizedkeys|PubKeyAgent /usr/bin/sss_ssh_authorizedkeys %%u)$' /etc/openssh/sshd_config 2>/dev/null; then
        sed -r '
            /^(AuthorizedKeysCommand(User|RunAs)|PubKeyAgentRunAs)[ \t]/ d
        ' /etc/openssh/sshd_config >/etc/openssh/sshd_config.ipanew

        if /usr/sbin/sshd -t -f /dev/null -o 'AuthorizedKeysCommand=/usr/bin/sss_ssh_authorizedkeys' -o 'AuthorizedKeysCommandUser=nobody' 2>/dev/null; then
            sed -ri '
                s/^PubKeyAgent (.+) %%u$/AuthorizedKeysCommand \1/
                s/^AuthorizedKeysCommand .*$/\0\nAuthorizedKeysCommandUser nobody/
            ' /etc/openssh/sshd_config.ipanew
        elif /usr/sbin/sshd -t -f /dev/null -o 'AuthorizedKeysCommand=/usr/bin/sss_ssh_authorizedkeys' -o 'AuthorizedKeysCommandRunAs=nobody' 2>/dev/null; then
            sed -ri '
                s/^PubKeyAgent (.+) %%u$/AuthorizedKeysCommand \1/
                s/^AuthorizedKeysCommand .*$/\0\nAuthorizedKeysCommandRunAs nobody/
            ' /etc/openssh/sshd_config.ipanew
        elif /usr/sbin/sshd -t -f /dev/null -o 'PubKeyAgent=/usr/bin/sss_ssh_authorizedkeys %%u' -o 'PubKeyAgentRunAs=nobody' 2>/dev/null; then
            sed -ri '
                s/^AuthorizedKeysCommand (.+)$/PubKeyAgent \1 %%u/
                s/^PubKeyAgent .*$/\0\nPubKeyAgentRunAs nobody/
            ' /etc/openssh/sshd_config.ipanew
        fi

        mv -Z /etc/openssh/sshd_config.ipanew /etc/openssh/sshd_config
        chmod 600 /etc/openssh/sshd_config

        /bin/systemctl condrestart sshd.service 2>&1 ||:
    fi
fi

%post client-epn
# first installation
if [ $1 -eq 1 ]; then
    systemctl -q preset ipa-epn.{service,timer} ||:
fi

%preun client-epn
# removal (not upgrade)
if [ $1 -eq 0 ]; then
    systemctl --no-reload -q disable --now ipa-epn.{service,timer} ||:
fi

%if_without only_client
%files server
%_sbindir/ipa-backup
%_sbindir/ipa-restore
%_sbindir/ipa-ca-install
%_sbindir/ipa-kra-install
%_sbindir/ipa-server-install
%_sbindir/ipa-replica-conncheck
%_sbindir/ipa-replica-install
%_sbindir/ipa-replica-manage
%_sbindir/ipa-csreplica-manage
%_sbindir/ipa-server-certinstall
%_sbindir/ipa-server-upgrade
%_sbindir/ipa-ldap-updater
%_sbindir/ipa-otptoken-import
%_sbindir/ipa-compat-manage
%_sbindir/ipa-nis-manage
%_sbindir/ipa-managed-entries
%_sbindir/ipactl
%_sbindir/ipa-advise
%_sbindir/ipa-cacert-manage
%_sbindir/ipa-winsync-migrate
%_sbindir/ipa-pkinit-manage
%_sbindir/ipa-crlgen-manage
%_sbindir/ipa-cert-fix
%_sbindir/ipa-acme-manage
%_sbindir/ipa-migrate
%_libexecdir/certmonger/dogtag-ipa-ca-renew-agent-submit
%_libexecdir/certmonger/ipa-server-guard
%_libexecdir/ipa/ipa-ccache-sweeper
%_libexecdir/ipa/ipa-custodia
%_libexecdir/ipa/ipa-custodia-check
%_libexecdir/ipa/ipa-httpd-kdcproxy
%_libexecdir/ipa/ipa-httpd-pwdreader
%_libexecdir/ipa/ipa-pki-retrieve-key
%_libexecdir/ipa/ipa-pki-wait-running
%_libexecdir/ipa/ipa-otpd
%_libexecdir/ipa/ipa-print-pac
%_libexecdir/ipa/ipa-subids
%dir %_libexecdir/ipa/custodia
%attr(755,root,root) %_libexecdir/ipa/custodia/ipa-custodia-dmldap
%attr(755,root,root) %_libexecdir/ipa/custodia/ipa-custodia-pki-tomcat
%attr(755,root,root) %_libexecdir/ipa/custodia/ipa-custodia-pki-tomcat-wrapped
%attr(755,root,root) %_libexecdir/ipa/custodia/ipa-custodia-ra-agent
%dir %_libexecdir/ipa/oddjob
%attr(0755,root,root) %_libexecdir/ipa/oddjob/org.freeipa.server.conncheck
%attr(0755,root,root) %_libexecdir/ipa/oddjob/org.freeipa.server.trust-enable-agent
%attr(0755,root,root) %_libexecdir/ipa/oddjob/org.freeipa.server.config-enable-sid
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.freeipa.server.conf
%config(noreplace) %_sysconfdir/oddjobd.conf.d/ipa-server.conf
%dir %_libexecdir/ipa/certmonger
%attr(755,root,root) %_libexecdir/ipa/certmonger/*
# NOTE: systemd specific section
%attr(644,root,root) %_unitdir/ipa.service
%attr(644,root,root) %_unitdir/ipa-otpd.socket
%attr(644,root,root) %_unitdir/ipa-otpd@.service
%attr(644,root,root) %_unitdir/ipa-ccache-sweep.service
%attr(644,root,root) %_unitdir/ipa-ccache-sweep.timer
%attr(644,root,root) %_unitdir/ipa-custodia.service
%ghost %attr(644,root,root) %etc_systemd_dir/httpd2.service.d/ipa.conf
%_tmpfilesdir/ipa.conf
%attr(644,root,root) %_journal_catalogdir/ipa.catalog
# END
%attr(755,root,root) %plugin_dir/libipa_pwd_extop.so
%attr(755,root,root) %plugin_dir/libipa_enrollment_extop.so
%attr(755,root,root) %plugin_dir/libipa_winsync.so
%attr(755,root,root) %plugin_dir/libipa_repl_version.so
%attr(755,root,root) %plugin_dir/libipa_uuid.so
%attr(755,root,root) %plugin_dir/libipa_modrdn.so
%attr(755,root,root) %plugin_dir/libipa_lockout.so
%attr(755,root,root) %plugin_dir/libipa_dns.so
%attr(755,root,root) %plugin_dir/libipa_range_check.so
%attr(755,root,root) %plugin_dir/libipa_otp_counter.so
%attr(755,root,root) %plugin_dir/libipa_otp_lasttoken.so
%attr(755,root,root) %plugin_dir/libtopology.so
%attr(755,root,root) %plugin_dir/libipa_sidgen.so
%attr(755,root,root) %plugin_dir/libipa_sidgen_task.so
%attr(755,root,root) %plugin_dir/libipa_extdom_extop.so
%attr(755,root,root) %plugin_dir/libipa_graceperiod.so
%attr(755,root,root) %_libdir/krb5/plugins/kdb/ipadb.so
%_man1dir/ipa-replica-conncheck.1*
%_man1dir/ipa-replica-install.1*
%_man1dir/ipa-replica-manage.1*
%_man1dir/ipa-csreplica-manage.1*
%_man1dir/ipa-server-certinstall.1*
%_man1dir/ipa-server-install.1*
%_man1dir/ipa-server-upgrade.1*
%_man1dir/ipa-ca-install.1*
%_man1dir/ipa-kra-install.1*
%_man1dir/ipa-compat-manage.1*
%_man1dir/ipa-nis-manage.1*
%_man1dir/ipa-managed-entries.1*
%_man1dir/ipa-ldap-updater.1*
%_man1dir/ipa-backup.1*
%_man1dir/ipa-restore.1*
%_man1dir/ipa-advise.1*
%_man1dir/ipa-otptoken-import.1*
%_man1dir/ipa-cacert-manage.1*
%_man1dir/ipa-winsync-migrate.1*
%_man1dir/ipa-pkinit-manage.1*
%_man1dir/ipa-crlgen-manage.1*
%_man1dir/ipa-cert-fix.1*
%_man1dir/ipa-acme-manage.1*
%_man1dir/ipa-migrate.1*
%_man8dir/ipactl.8*
# WSGI applications
%_datadir/ipa/wsgi.py
%_datadir/ipa/migration/migration.py
%_datadir/ipa/kdcproxy.wsgi
%_datadir/ipa/wsgi/plugins.py

%bash_completions_dir/ipa-migrate

%_rpmlibdir/freeipa-server.filetrigger

%files -n python3-module-ipaserver
%python3_sitelibdir/ipaserver/
%python3_sitelibdir/ipaserver-%version-py%_python3_version.egg-info/

%files server-common
%dir %attr(0755,root,root) %_sysconfdir/ipa/kdcproxy
%config(noreplace) %_sysconfdir/ipa/kdcproxy/kdcproxy.conf
%_datadir/ipa/ipaca*.ini
%_datadir/ipa/*.ldif
%exclude %_datadir/ipa/ipa-cldap-conf.ldif
%_datadir/ipa/*.uldif
%_datadir/ipa/*.template
%_datadir/ipa/advise/
%_datadir/ipa/profiles/
%dir %_datadir/ipa/html
%_datadir/ipa/html/*.html
%dir %_datadir/ipa/migration/
%_datadir/ipa/migration/index.html
%_datadir/ipa/ui/
%dir %_datadir/ipa/wsgi/
%dir %_sysconfdir/ipa
%dir %_sysconfdir/ipa/html
%config(noreplace) %_sysconfdir/ipa/html/ssbrowser.html
%config(noreplace) %_sysconfdir/ipa/html/unauthorized.html
%ghost %attr(0644,root,root) %config(noreplace) %apache2_sites_available/ipa.conf
%ghost %attr(0644,root,root) %config(noreplace) %apache2_extra_enabled/ipa-rewrite.conf
%ghost %attr(0644,root,root) %config(noreplace) %apache2_extra_enabled/ipa-kdc-proxy.conf
%ghost %attr(0640,root,root) %config(noreplace) %apache2_extra_enabled/ipa-pki-proxy.conf
%ghost %attr(0644,root,root) %config(noreplace) %_sysconfdir/ipa/kdcproxy/ipa-kdc-proxy.conf
%ghost %attr(0644,root,root) %config(noreplace) %_datadir/ipa/html/ca.crt
%ghost %attr(0644,root,root) %_datadir/ipa/html/krb.con
%ghost %attr(0644,root,root) %_datadir/ipa/html/krb5.ini
%ghost %attr(0644,root,root) %_datadir/ipa/html/krbrealm.con
%dir %_datadir/ipa/updates/
%_datadir/ipa/updates/*
%dir %_sharedstatedir/ipa
%attr(700,root,root) %dir %_sharedstatedir/ipa/backup
%ghost %attr(770,root,_gssproxy) %dir %_sharedstatedir/ipa/gssproxy
%attr(711,root,root) %dir %_sharedstatedir/ipa/sysrestore
%attr(700,root,root) %dir %_sharedstatedir/ipa/sysupgrade
%attr(755,root,root) %dir %_sharedstatedir/ipa/pki-ca
%attr(755,root,root) %dir %_sharedstatedir/ipa/certs
%attr(700,root,root) %dir %_sharedstatedir/ipa/private
%attr(700,root,root) %dir %_sharedstatedir/ipa/passwds
%ghost %attr(775,root,pkiuser) %_sharedstatedir/ipa/pki-ca/publish

%dir %attr(0700,root,root) %_sysconfdir/ipa/custodia
%dir %_datadir/ipa/schema.d
%attr(0644,root,root) %_datadir/ipa/schema.d/README
%attr(0644,root,root) %_datadir/ipa/gssapi.login
%_datadir/ipa/ipakrb5.aug

%files server-dns
%ghost %attr(0640,root,named) %config(noreplace) %_sysconfdir/bind/ipa-ext.conf
%ghost %attr(0640,root,named) %config(noreplace) %_sysconfdir/bind/ipa-options-ext.conf
%attr(770,root,named) %dir %_sharedstatedir/bind/data/
%attr(770,root,named) %dir %_sharedstatedir/bind/dynamic/
%ghost %attr(770,named,named) %dir %_sharedstatedir/bind/zone/dyndb-ldap/ipa/
%config(noreplace) %_sysconfdir/sysconfig/ipa-dnskeysyncd
%config(noreplace) %_sysconfdir/sysconfig/ipa-ods-exporter
%dir %attr(0755,root,root) %_sysconfdir/ipa/dnssec
%_libexecdir/ipa/ipa-dnskeysyncd
%_libexecdir/ipa/ipa-dnskeysync-replica
%_libexecdir/ipa/ipa-ods-exporter
%_man1dir/ipa-dns-install.1*
%_sbindir/ipa-dns-install
%attr(644,root,root) %_unitdir/ipa-dnskeysyncd.service
%attr(644,root,root) %_unitdir/ipa-ods-exporter.socket
%attr(644,root,root) %_unitdir/ipa-ods-exporter.service

%files server-trust-ad
%_sbindir/ipa-adtrust-install
%_datadir/ipa/smb.conf.empty
%attr(755,root,root) %_libdir/samba/pdb/ipasam.so
%attr(755,root,root) %plugin_dir/libipa_cldap.so
%_datadir/ipa/ipa-cldap-conf.ldif
%_man1dir/ipa-adtrust-install.1*
%_sysconfdir/dbus-1/system.d/oddjob-ipa-trust.conf
%_sysconfdir/oddjobd.conf.d/oddjobd-ipa-trust.conf
%_libexecdir/ipa/oddjob/com.redhat.idm.trust-fetch-domains
%_altdir/winbind_krb5_locator.so

%files -n python3-module-ipatests
%python3_sitelibdir/ipatests/
%python3_sitelibdir/ipatests-%version-py%_python3_version.egg-info/
%_bindir/ipa-run-tests
%_bindir/ipa-test-config
%_bindir/ipa-test-task
%_man1dir/ipa-run-tests.1*
%_man1dir/ipa-test-config.1*
%_man1dir/ipa-test-task.1*

%endif # only_client

%files client
%_sbindir/ipa-client-install
%_sbindir/ipa-certupdate
%_sbindir/ipa-getkeytab
%_sbindir/ipa-rmkeytab
%_sbindir/ipa-join
%_bindir/ipa
%dir %_libexecdir/ipa/acme
%_libexecdir/ipa/acme/certbot-dns-ipa
%bash_completions_dir/ipa
%config %_sysconfdir/sysconfig/certmonger
%_mandir/man1/ipa.1*
%_mandir/man1/ipa-getkeytab.1*
%_mandir/man1/ipa-rmkeytab.1*
%_mandir/man1/ipa-client-install.1*
%_mandir/man1/ipa-certupdate.1*
%_mandir/man1/ipa-join.1*

%files client-samba
%_sbindir/ipa-client-samba
%_man1dir/ipa-client-samba.1*

%files client-epn
%_sbindir/ipa-epn
%_man1dir/ipa-epn.1*
%_man5dir/epn.conf.5*
%attr(644,root,root) %_unitdir/ipa-epn.service
%attr(644,root,root) %_unitdir/ipa-epn.timer
%dir %attr(0755,root,root) %_sysconfdir/ipa/epn
%attr(600,root,root) %config(noreplace) %_sysconfdir/ipa/epn.conf
%attr(644,root,root) %config(noreplace) %_sysconfdir/ipa/epn/expire_msg.template

%files client-automount
%_sbindir/ipa-client-automount
%_mandir/man1/ipa-client-automount.1*
%python3_sitelibdir/ipaclient/install/ipa_client_automount.py

%files -n python3-module-ipaclient
%python3_sitelibdir/ipaclient/
%exclude %python3_sitelibdir/ipaclient/install/ipa_client_automount.py
%python3_sitelibdir/ipaclient-%version-py%_python3_version.egg-info/

%files client-common
%dir %attr(0755,root,root) %_sysconfdir/ipa/
%ghost %attr(0644,root,root) %config(noreplace) %_sysconfdir/ipa/default.conf
%ghost %attr(0644,root,root) %config(noreplace) %_sysconfdir/ipa/ca.crt
%dir %attr(0755,root,root) %_sysconfdir/ipa/nssdb
# new sql format
%ghost %attr(644,root,root) %config(noreplace) %_sysconfdir/ipa/nssdb/cert9.db
%ghost %attr(644,root,root) %config(noreplace) %_sysconfdir/ipa/nssdb/key4.db
%ghost %attr(644,root,root) %config(noreplace) %_sysconfdir/ipa/nssdb/pkcs11.txt
%ghost %attr(600,root,root) %config(noreplace) %_sysconfdir/ipa/nssdb/pwdfile.txt
%ghost %attr(644,root,root) %config(noreplace) %_sysconfdir/pki/ca-trust/source/ipa.p11-kit
%dir %_sharedstatedir/ipa-client
%dir %_sharedstatedir/ipa-client/pki
%dir %_sharedstatedir/ipa-client/sysrestore
%_man5dir/default.conf.5*
%dir %_datadir/ipa/client
%_datadir/ipa/client/*.template

%files common -f ipa.lang
%doc COPYING README.md Contributors.txt
%dir %_datadir/ipa
%dir %_libexecdir/ipa

%files -n python3-module-freeipa
%python3_sitelibdir/ipapython/
%python3_sitelibdir/ipalib/
%python3_sitelibdir/ipaplatform/
%python3_sitelibdir/ipapython-%version-py%_python3_version.egg-info/
%python3_sitelibdir/ipalib-%version-py%_python3_version.egg-info/
%python3_sitelibdir/ipaplatform-%version-py%_python3_version.egg-info/

%changelog
