Name: fotocx
Version: 25.5
Release: alt1

%define app_id kornelix.%name

Summary: Software for digital image editing, HDR composites, and panoramas
Group: Graphics
License: GPL-3.0-or-later
Url: https://www.kornelix.net/fotocx/fotocx.html

#Vcs: https://gitlab.com/fotoxx/fotoxx.git

Source: https://www.kornelix.net/downloads/downloads/%name-%version-source.tar.gz
Source1: %name.desktop
Source2: %{name}16.png
Source3: %{name}32.png

Requires: %name-data = %EVR

# fotoxx uses xdg-open executable to launch HTML docs viewer:
Requires: xdg-utils
Requires: dcraw /usr/bin/exiftool
Requires: libwebp-tools openjpeg-tools2.0

Obsoletes: fotox
Provides: fotox
Obsoletes: fotoxx < 24.70
Provides: fotoxx = %EVR

BuildRequires: gcc-c++ libgtk+3-devel libtiff-devel libjpeg-devel
BuildRequires: liblcms2-devel perl-Image-ExifTool xdg-utils
BuildRequires: libchamplain-gtk3-devel libclutter-gtk3-devel libappstream-glib-devel

%description
Fotox is a program for improving digital photos. Navigate through large image
directories using a window of thumbnail images. Create HDR (high dynamic range)
images by combining bright and dark images to improve details visible in both
bright and dark areas. Create panorama (extra wide) images by joining overlapped
images. Adjust brightness and color intensity independently for different
underlying brightness levels. Reduce fog or haze by removing "whiteness" and
intensifying colors. Rotate an image (level a tilted image or turn 90 degrees).
Remove the red-eye effect from electronic flash photos. Resize or crop an image.

%package data
Summary: Arch independent files for Fotox
Group: Graphics
BuildArch: noarch
Obsoletes: fotoxx-data < 24.70
Provides: fotoxx-data = %EVR

%description data
This package provides noarch data needed for Fotox to work.

%prep
%setup -n %name
chmod -x doc/*
sed -i 's/opj_decompress/opj2_decompress/' %name.cc f.pixmap.cc

%build
%make_build PREFIX=/usr CXXFLAGS="%optflags %(getconf LFS_CFLAGS)"

%install
%make_install install DESTDIR=%buildroot PREFIX=%_prefix

install -pD -m644 %SOURCE1 %buildroot%_desktopdir/%name.desktop
install -pD -m644 images/%name.png %buildroot%_liconsdir/%name.png
install -pD %_sourcedir/%{name}32.png %buildroot%_niconsdir/%name.png
install -pD %_sourcedir/%{name}16.png %buildroot%_miconsdir/%name.png

%files
%_bindir/%name

%files data
%_desktopdir/%name.desktop
%_iconsdir/%name.png
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_datadir/%name/
%_man1dir/%name.1*
%_datadir/metainfo/%app_id.metainfo.xml
%doc doc/changelog doc/copyright

%exclude %_datadir/doc/%name

%changelog
