Group: System/Configuration/Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Font/TTF/Font.pm) perl(Unicode/UCD.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 0
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name fontpackages
%global spectemplatedir %{_sysconfdir}/rpmdevtools/
%global ftcgtemplatedir %{_datadir}/fontconfig/templates/

# Use the same directory of the main package for subpackage licence and docs
%global _docdir_fmt %{name}

Name:    fontpackages
Version: 1.44
Release: alt8_24
Summary: Common directory and macro definitions used by font packages

# Mostly means the scriptlets inserted via this package do not change the
# license of the packages they're inserted in
License:   LGPLv3+
URL:       http://fedoraproject.org/wiki/fontpackages
Source0:   http://fedorahosted.org/releases/f/o/%{name}/%{name}-%{version}.tar.xz
Patch0:    dnf.patch
Patch1:    %{name}-drop-fccache.patch
Patch2:    %{name}-add-ghost-uuid.patch

BuildArch: noarch
BuildRequires: rpm-build-perl
Source44: import.info
Patch33: macros.fonts.diff
Conflicts: rpm-build-fedora-compat-fonts

%description
This package contains the basic directory layout, spec templates, rpm macros
and other materials used to create font packages.


%package filesystem
Group: System/Configuration/Other
Summary: Directories used by font packages
License: Public Domain

%description filesystem
This package contains the basic directory layout used by font packages,
including the correct permissions for the directories.


%package devel
Group: System/Configuration/Other
Summary: Templates and macros used to create font packages

Requires: fontconfig
Requires: rpm-macros-fontpackages rpm-build-fonts xorg-font-encodings

%description devel
This package contains spec templates, rpm macros and other materials used to
create font packages.


%package tools
Group: System/Configuration/Other
Summary: Tools used to check fonts and font packages

Requires: fontconfig fontforge libfontforge
Requires: curl, make, mutt
Requires: dnf-command(repoquery)
Requires: createrepo_c

# repo-font-audit script need to run fedoradev-pkgowners command
# which is available on Fedora only and not on RHEL.
%if 0%{?fedora}
Requires: fedora-packager
%endif

%description tools
This package contains tools used to check fonts and font packages.

%package -n rpm-macros-%{name}
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other
BuildArch: noarch

%description -n rpm-macros-%{name}
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%files -n rpm-macros-%{name}
%_rpmmacrosdir/*



%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

%if 0%{?rhel}
sed -i 's|/usr/bin/fedoradev-pkgowners|""|g' bin/repo-font-audit
%endif

# Drop obosolete %defattr (#1047031)
sed -i '/^%%defattr/d' rpm/macros.fonts
%patch33 -p0

%build
sed -i "s|^DATADIR\([[:space:]]*\)\?=\(.*\)$|DATADIR=%{_datadir}/%{name}|g" \
  bin/repo-font-audit bin/compare-repo-font-audit

%install
# Pull macros out of macros.fonts and emulate them during install
for dir in fontbasedir        fontconfig_masterdir \
           fontconfig_confdir fontconfig_templatedir ; do
  export _${dir}=$(rpm --eval $(grep -E "^%_${dir}\b" \
    rpm/macros.fonts | gawk '{ print $2 }'))
done

install -m 0755 -d %{buildroot}${_fontbasedir} \
                   %{buildroot}${_fontconfig_masterdir} \
                   %{buildroot}${_fontconfig_confdir} \
                   %{buildroot}${_fontconfig_templatedir} \
                   %{buildroot}%{spectemplatedir} \
                   %{buildroot}%{_rpmmacrosdir} \
                   %{buildroot}%{_datadir}/fontconfig/templates \
                   %{buildroot}/%_datadir/%{name} \
                   %{buildroot}%{_bindir}
install -m 0644 -p spec-templates/*.spec       %{buildroot}%{spectemplatedir}
install -m 0644 -p fontconfig-templates/*      %{buildroot}%{ftcgtemplatedir}
install -m 0644 -p rpm/macros*                 %{buildroot}%{_rpmmacrosdir}
install -m 0644 -p private/repo-font-audit.mk  %{buildroot}/%{_datadir}/%{name}
install -m 0755 -p private/core-fonts-report \
                   private/font-links-report \
                   private/fonts-report \
                   private/process-fc-query \
                   private/test-info           %{buildroot}/%{_datadir}/%{name}
install -m 0755 -p bin/*                       %{buildroot}%{_bindir}

cat <<EOF > %{name}-%{version}.files
%dir ${_fontbasedir}
%dir ${_fontconfig_masterdir}
%dir ${_fontconfig_confdir}
%dir ${_fontconfig_templatedir}
%ghost ${_fontbasedir}/.uuid
EOF
rm -rf %buildroot%{spectemplatedir}
# rename macros.xxx
mv %buildroot%_rpmmacrosdir/macros.fonts  %buildroot%_rpmmacrosdir/%name

%files devel
%doc --no-dereference license.txt
%doc readme.txt
%dir %{ftcgtemplatedir}
%{ftcgtemplatedir}/*conf
%{ftcgtemplatedir}/*txt

%changelog
