%def_disable snapshot

%define api_ver 2
%define sover %api_ver

%def_disable static
%def_disable ladcca
%def_enable lash
%def_enable ladspa
%def_enable jack
%def_enable pulseaudio
%def_disable portaudio
%def_enable sdl2
%def_enable libinstpatch
%def_enable dbus
%def_enable systemd
%def_disable docs
%def_enable check

Name: fluidsynth
Version: 2.5.1
Release: alt1

Summary: Software real-time synthesizer
Summary(ru_RU.UTF-8): Программный синтезатор, работающий в режиме реального времени
License: LGPL-2.1-or-later
Group: Sound
Url: http://www.fluidsynth.org

Vcs: https://github.com/FluidSynth/fluidsynth.git

%if_disabled snapshot
Source: https://github.com/FluidSynth/%name/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %EVR
# default soundfont
Requires: fluid-soundfont-gm

%define cmake_ver 3.0.2
%define glib_ver 2.30
%define jack_ver 0.75.0
%define ladcca_ver 0.4.0
%define alsa_ver 0.9.8-alt2
%define instpatch_ver 1.1.0

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake >= %cmake_ver gcc-c++ libgomp-devel
BuildRequires: doxygen graphviz xsltproc docbook-dtds docbook-style-xsl
BuildRequires: glib2-devel >= %glib_ver libsndfile-devel libalsa-devel >= %alsa_ver
BuildRequires: libalsa-devel >= %alsa_ver libe2fs-devel
BuildRequires: libncurses-devel libreadline-devel
# since 2.5.0
BuildRequires: gcem-devel
%{?_enable_static:BuildRequires: glibc-devel-static}
%{?_enable_ladcca:BuildRequires: libladcca-devel >= %ladcca_ver}
%{?_enable_lash:BuildRequires: liblash-devel}
%{?_enable_ladspa:BuildRequires: ladspa_sdk}
%{?_enable_jack:BuildRequires: libjack-devel >= %jack_ver}
%{?_enable_pulseaudio:BuildRequires: libpulseaudio-devel}
%{?_enable_dbus:BuildRequires: libdbus-devel}
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}
%{?_enable_portaudio:BuildRequires: libportaudio-devel}
%{?_enable_sdl2:BuildRequires: libSDL2-devel}
%{?_enable_libinstpatch:BuildRequires: libinstpatch-devel >= %instpatch_ver}
%{?_enable_check:BuildRequires: ctest}

%description
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

%description -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

%package -n lib%name
Summary: Shared libraries for %name
Summary(ru_RU.UTF-8): Разделяемые библиотеки для %name
Group: System/Libraries

%description -n lib%name
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains libraries for %name package

%description -n lib%name -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

Этот пакет содержит разделяемые библиотеки, необходимые для работы %name

%package -n lib%name-devel
Summary: Development environment for %name
Summary(ru_RU.UTF-8): Среда разработки для %name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains headers and development files for lib%name package

%description -n lib%name-devel -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

Этот пакет содержит файлы, необходимы для разработки с использованием 
%name

%package -n lib%name-devel-static
Summary: Static %name library
Summary(ru_RU.UTF-8): Статические библиотеки для %name
Group: Development/C
Obsoletes: libiiwusynth-devel-static
Provides: libiiwusynth-devel-static = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains static libraries for %name package

%description -n lib%name-devel-static -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

Этот пакет содержит статические библиотеки для %name

%prep
%setup
%ifarch %e2k
sed -i 's/ALIGNMENT (64U)/ALIGNMENT 64U/' src/utils/fluid_sys.h
%endif

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
    -DLIB_INSTALL_DIR:PATH=%_lib \
    -DINCLUDE_INSTALL_DIR:PATH=include \
    -DDEFAULT_SOUNDFONT:STRING="%_datadir/soundfonts/default.sf2" \
    -DCMAKE_BUILD_TYPE:STRING="Release" \
    %{?_enable_lash:-Denable-lash:bool=true} \
    %{?_enable_ladcca:-Denable-ladcca:bool=true} \
    %{?_enable_ladspa:-Denable-ladspa:bool=true} \
    %{?_enable_jack:-Denable-jack:bool=true} \
    %{?_enable_pulseaudio:-Denable-pulseaudio:bool=true} \
    %{?_enable_dbus:-Denable-dbus:bool=true} \
    %{?_disable_systemd:-Denable-systemd:bool=false} \
    %{?_enable_portaudio:-Denable-portaudio:bool=true} \
    %{?_enable_sdl2:-Denable-sdl2:bool=true}
%nil
%cmake_build
%{?_enable_docs:%cmake_build -t doxygen}

%install
%cmake_install
%{?_enable_docs:cp -r %_cmake__builddir/doc/api/html ./}

%check
%cmake_build -t check

%files
%_bindir/%name
%_man1dir/%name.1.*

%files -n lib%name
%_libdir/lib%name.so.*
%doc AUTHORS README.md THANKS

%files -n lib%name-devel
%_includedir/*
%_libdir/lib%name.so
%_pkgconfigdir/%name.pc
%_libdir/cmake/%name/FluidSynthConfig.cmake
%_libdir/cmake/%name/FluidSynthConfigVersion.cmake
%_libdir/cmake/%name/FluidSynth-shared-targets.cmake
%_libdir/cmake/%name/FluidSynth-shared-targets-release.cmake
%{?_enable_docs:%doc html}
%doc TODO

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
