%define desc FlatBuffers is a cross platform serialization library architected \
for maximum memory efficiency. It allows you to directly access serialized data \
without parsing/unpacking it first, while still having great forwards/backwards \
compatibility.

Name: flatbuffers
Version: 25.9.23
Release: alt1

Summary: Memory Efficient Serialization Library
License: APL
Group: System/Libraries

Url: https://google.github.io/%name/
Vcs: https://github.com/google/%name

# https://github.com/google/%name/archive/v%version/%name-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-devel
BuildRequires:  python3-module-setuptools
BuildRequires: cmake ctest gcc-c++

%description
%desc

%package -n lib%name
Summary: Memory Efficient Serialization Library
Group: System/Libraries

%description -n lib%name
%desc

%package  -n lib%name-devel
Summary: Memory Efficient Serialization Library
Group: Development/C++

%description -n lib%name-devel
%desc
This package contains development part of FlatBuffers.

%package -n python3-module-%name
Summary: Python3 files for %name
Group: Development/Python3
Requires: lib%name = %EVR

%description -n python3-module-%name
This package contains python files for %name.

%prep
%setup
%add_optflags -Wno-class-memaccess -Wno-stringop-overflow
%ifarch %e2k
sed -i 's,-Werror -Wextra -Werror=shadow,,' CMakeLists.txt
# get rid of abstractions that break the compiler
sed -i 's/int &...ExplicitArgumentBarrier,//;s/int &...,//' \
	include/flatbuffers/flatbuffer_builder.h
%endif

%build
cmake  	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_CXX_FLAGS:STRING='%optflags' \
	-DCMAKE_INSTALL_PREFIX=%prefix \
	-DFLATBUFFERS_BUILD_FLATC=ON \
	-DFLATBUFFERS_BUILD_FLATLIB=OFF \
	-DFLATBUFFERS_BUILD_SHAREDLIB=ON \
	-DFLATBUFFERS_BUILD_TESTS=ON \
	.

%make_build

pushd python
%python3_build
popd

%ifnarch %ix86 %arm
%check
make test
%endif

%install
%makeinstall_std
pushd python
%python3_install
popd
[ %python3_sitelibdir = %python3_sitelibdir_noarch ] ||
  (
    mkdir -p %buildroot%python3_sitelibdir
    mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir
  )

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_bindir/flatc
%_includedir/%name
%_libdir/cmake/%name
%_libdir/lib%name.so
%_pkgconfigdir/%name.pc

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
