%define _unpackaged_files_terminate_build 1
%ifarch %arm
%def_disable check
%else
%def_enable check
%endif

Name: fish
Version: 4.2.0
Release: alt1

Summary: A friendly interactive shell
License: GPLv2+
Group: Shells

Url: http://fishshell.com/

# https://github.com/fish-shell/fish-shell.git
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: fish-4.0.0-alt_apt_adapter.patch

Requires: man
BuildRequires(pre): rpm-build-rust rpm-build-python3 rpm-macros-cmake rpm-macros-ninja-build
BuildRequires: rust-cargo >= 1.85
BuildRequires: cargo-license gcc
BuildRequires: terminfo
BuildRequires: libpcre2-devel >= 10.22
BuildRequires: cmake ninja-build rpm-build-ninja rpm-build-cmake
BuildRequires: python3-module-sphinx-sphinx-build-symlink
# for check
BuildRequires: ctest
BuildRequires: /proc /dev/pts
BuildRequires: procps
BuildRequires: python3-module-pexpect
BuildRequires: tmux
BuildRequires: git-core

%description
fish is a shell geared towards interactive use. Its features are
focused on user friendliness and discoverability. The language syntax
is simple but incompatible with other shell languages.

%prep
%setup
%rust_prep
cat >> .cargo/config.toml <<EOF
[source."git+https://github.com/fish-shell/rust-pcre2?tag=0.2.9-utf32"]
git = "https://github.com/fish-shell/rust-pcre2"
tag = "0.2.9-utf32"
replace-with = "vendored-sources"
EOF

%patch0 -p1
%patch1 -p1
echo "%version" > version


# Change the bundled scripts to invoke the python binary directly.
for f in $(find share/tools -type f -name '*.py'); do
    sed -i -e '1{s@^#!.*@#!%__python3@}' "$f"
done

%build
export CARGO_NET_OFFLINE=true
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir \
    -DCMAKE_INSTALL_DOCDIR=%_docdir/%name
%cmake_build -t all doc
cargo license > LICENSE.dependencies

%install
%cmake_install
%find_lang %name

rm -f %buildroot%_datadir/fish/completions/docker.fish
rm -f %buildroot%_desktopdir/fish.desktop
rm -f %buildroot%_pixmapsdir/fish.png
rm -rf %buildroot%_datadir/pkgconfig

%check
export SHOW_INTERACTIVE_LOG=1
%cmake_build --target fish_run_tests

%post
grep -q %_bindir/fish %_sysconfdir/shells ||
	echo %_bindir/fish >>%_sysconfdir/shells

%postun
. shell-quote
if [ "$1" = 0 ]; then
	sed -i "/^$(quote_sed_regexp %_bindir/fish)$/ d" %_sysconfdir/shells
fi

%files -f %name.lang
%_bindir/*
%dir %_sysconfdir/fish
%config %_sysconfdir/fish/config.fish
%_datadir/fish
%doc %_docdir/%name
%doc LICENSE.dependencies
%_man1dir/*

%changelog
