%define _unpackaged_files_terminate_build 1

Name: firmware-linux
Version: 20251125
Release: alt1
Summary: Firmware files used by the Linux kernel
License: GPL-2.0-or-later and MIT and Redistributable, no modification permitted

Group: System/Kernel and hardware
Url: https://gitlab.com/kernel-firmware/linux-firmware
# https://lore.kernel.org/linux-firmware/

Source: %name-%version.tar

BuildArch: noarch
Provides: linux-firmware

BuildRequires: hardlink
BuildRequires: parallel /proc
BuildRequires: python3
Requires: udev
AutoReqProv: no

%add_verify_elf_skiplist /lib/firmware/*

%description
Kernel-firmware includes firmware files
required for some devices to operate.

%package netronome
Group: System/Kernel and hardware
Summary: firmware for Agilio SmartNICs
AutoProv: no
AutoReq: no symlinks

%description netronome
firmware for Agilio SmartNICs

%package liquidio
Group: System/Kernel and hardware
Summary: firmware for LiquidIO Smart NICs
AutoProv: no
AutoReq: no symlinks

%description liquidio
firmware for LiquidIO II Smart NICs

%package qcom
Group: System/Kernel and hardware
Summary: firmware for Qualcomm platforms
AutoProv: no
AutoReq: no symlinks

%description qcom
firmware for Qualcomm platforms (most of it)

%package mrvl
Group: System/Kernel and hardware
Summary: firmware for Marvell Prestera
AutoProv: no
AutoReq: no symlinks

%description mrvl
firmware for Marvell Prestera switchdev

%package mellanox
Group: System/Kernel and hardware
Summary: firmware for Mellanox Spectrum
AutoProv: no
AutoReq: no symlinks

%description mellanox
firmware for Mellanox Spectrum switchdev

%prep
%setup
awk /mellanox/ RS=^-{74} WHENCE > LICENSE.Mellanox

%install
DESTDIR=%buildroot FIRMWAREDIR=lib/firmware %make_build install-xz
du -shc %buildroot/lib/firmware
hardlink -y memcmp -c %buildroot/lib/firmware

## *TODO* check these too
rm -rf %buildroot/lib/firmware{ess,korg,sb16,yamaha}

%check
# Ensure that compression mode is correct.
xz -l %buildroot/lib/firmware/i915/mtl_gsc_1.bin.xz | grep -w CRC32
grep -c Mellanox LICENSE.Mellanox

%pretrans -p <lua>
paths = {
  "/lib/firmware/nvidia/ad103",
  "/lib/firmware/nvidia/ad104",
  "/lib/firmware/nvidia/ad106",
  "/lib/firmware/nvidia/ad107"
}
for _, path in ipairs(paths) do
  st = posix.stat(path)
  if st and st.type == "directory" then
    status = os.rename(path, path .. ".rpmmoved")
    if not status then
      suffix = 0
      while not status do
        suffix = suffix + 1
        status = os.rename(path .. ".rpmmoved", path .. ".rpmmoved." .. suffix)
      end
    os.rename(path, path .. ".rpmmoved")
    end
  end
end

%files
%doc WHENCE LICEN?E.* Apache-2 GPL-2 GPL-3
/lib/firmware
%exclude /lib/firmware/netronome
%exclude /lib/firmware/liquidio
%exclude /lib/firmware/qcom/*
%exclude /lib/firmware/mrvl/*
%exclude /lib/firmware/mellanox

%files netronome
%doc LICENCE.Netronome
/lib/firmware/netronome

%files liquidio
%doc LICENCE.cavium_liquidio
/lib/firmware/liquidio

%files qcom
%doc LICENSE.qcom LICENSE.qcom_yamato qcom/NOTICE.txt LICENCE.linaro
/lib/firmware/qcom

%files mrvl
%doc LICENCE.Marvell LICENCE.NXP
/lib/firmware/mrvl

%files mellanox
%doc LICENSE.Mellanox
/lib/firmware/mellanox

%changelog
