%global _firmwarepath  /lib/firmware
%define version_major 2025.05.1
Summary: Firmware and topology files for Sound Open Firmware project
Name: firmware-alsa-sof
Version: %version_major
Release: alt1
# See later in the spec for a breakdown of licensing
License: BSD
Group: Sound
Url: https://thesofproject.github.io
Vcs: https://github.com/thesofproject/sof-bin
BuildRequires: alsa-utils alsa-topology-conf
Source: %name-%version.tar
Source3: sof-cml-es8336.tplg
Provides: alsa-sof-firmware = %EVR
# noarch, since the package is firmware
BuildArch: noarch

%description
This package contains the firmware binaries for the Sound Open Firmware project.

%package debug
Requires: alsa-sof-firmware
Summary: Debug files for Sound Open Firmware project
Group: Sound

%description debug
This package contains the debug files for the Sound Open Firmware project.

%prep
%setup

%build
# build generic topology file from alsa-topology
alsatplg -c /usr/share/alsa/topology/hda-dsp/skl_hda_dsp_generic-tplg.conf \
         -o skl_hda_dsp_generic-tplg.bin

%install
mkdir -p  %buildroot%_firmwarepath/intel/
for d in sof sof-ipc4 sof-ace-tplg sof-ipc4-tplg sof-ipc4-lib sof-tplg; do \
  cp -a "${d}" %buildroot%_firmwarepath/intel/; \
done
install %SOURCE3 %buildroot%_firmwarepath/intel/sof-tplg/
install -m0644 skl_hda_dsp_generic-tplg.bin %buildroot%_firmwarepath/

# gather files and directories
FILEDIR=$(pwd)
pushd %buildroot/%_firmwarepath
find -P . -name "*.ri" | sed -e '/^.$/d' > $FILEDIR/alsa-sof-firmware.files
find -P . -name "*.bin" | sed -e '/^.$/d' >> $FILEDIR/alsa-sof-firmware.files
find -P . -name "*.llext" | sed -e '/^.$/d' >> $FILEDIR/alsa-sof-firmware.files
find -P . -name "*.tplg" | sed -e '/^.$/d' >> $FILEDIR/alsa-sof-firmware.files
find -P . -name "*.ldc" | sed -e '/^.$/d' > $FILEDIR/alsa-sof-firmware.debug-files
find -P . -type d | sed -e '/^.$/d' > $FILEDIR/alsa-sof-firmware.dirs
popd
sed -i -e 's:^./::' alsa-sof-firmware.{files,debug-files,dirs}
sed -i -e 's!^!/lib/firmware/!' alsa-sof-firmware.{files,debug-files,dirs}
sed -e 's/^/%%dir /' alsa-sof-firmware.dirs >> alsa-sof-firmware.files
cat alsa-sof-firmware.files

%pretrans -p <lua>
path = "%{_firmwarepath}/intel/sof-tplg"
st = posix.stat(path)
if st and st.type == "link" then
  os.remove(path)
end


%files -f alsa-sof-firmware.files
%doc LICENCE*  README*
%dir %_firmwarepath
%_firmwarepath/intel/sof-ace-tplg
%_firmwarepath/skl_hda_dsp_generic-tplg.bin

%files debug -f alsa-sof-firmware.debug-files

%changelog
