%define fst_version 2.5
%define est_version 2.5
%define est_soversion 2.5.0
%define estsuffix 2.5
%define festival_user _festival
%define festival_group audio
%define festival_home '/'
%def_disable static
%def_without legacy_server_scripts
%def_without bootstrap
%def_disable speech_tools_test
%define festival_libexec_dir /usr/lib/festival

Summary:	general multi-lingual speech synthesis system
Name:		festival
Version:	%{fst_version}
Release:	alt0.6
Group:		Sound
Packager:	Igor Vlasenko <viy@altlinux.ru>
# the emacs el file is GPL+, there is one TCL licensed source file, and
# the hts_engine module is covered by the three-clause BSD license.
License:	MIT and GPLv2+ and TCL and BSD

URL:		http://www.cstr.ed.ac.uk/projects/festival.html
%define srcURL0  http://www.cstr.ed.ac.uk/downloads/festival/%{fst_version}
%define srcURL1  http://festvox.org/packed/festival/%{fst_version}
%define srcURL2  http://www.speech.cs.cmu.edu/awb/fftest

Source0:	%srcURL1/festival-%{fst_version}.tar
Source1:	%srcURL1/speech_tools-%{est_version}.tar
Source2:	speech-tools.manpages.tar
Source3:	festival.init
Source4:	festival-2.5-alt-server.scm
Source5:	festival-2.5-alt-siteinit.scm
Source7:	README.ALTLinux
Source8:	README.Debian
Source9:	README.testing
Source10:	50festival.el
Source11:	festival.service

### TODO: update README.alt

# adds /usr/lib/festival to PATH inside festival.
# It makes /usr/lib/festival useful place for external progs like mbrola.
Patch0:		festival-2.0.95-alt-fix-path-audsp.patch
# is not too nesessary if alt-fix-path-audsp.patch is applied
Patch1:		festival-1.4.1-audsp.patch
Patch4:		festival-2.0.95-alt-shared-lib-support-in-install.patch
Patch5:		festival-1.96-alt-unsafe-tmp-usage.patch
# soversion should have X.Y.Z - add or remove .1 if nesessary
Patch6:		festival-2.5-libFestival-soversion.patch

# misc alt patches
# use /etc/festival/*.scm
# clashes of 11-siteinit.diff
Patch20: festival-1.96-alt-sysconfdir-base.diff

################################################
# festival debian patches
# from festival_2.5.0-4
################################################
# ------ generated by debian-patches-series2spec.in ----------
# not applied; we directly echo variables in config;
Patch21: 01-config_config.diff
Patch22: 02-spelling.diff
Patch23: 03-security-access_list.diff
Patch24: 04-codec-add-alaw.diff
Patch25: 05-performance-combine-waves.diff
Patch26: 06-audio-add-pulseaudio.diff
Patch27: 07-doc-festival-doc.diff
Patch28: 08-doc-text2wave.diff
Patch29: 09-usability-language-detection.diff
Patch30: 10-fix-memory-allocations.diff
# TODO merge with Patch20: festival-1.96-alt-sysconfdir-base.diff
# to use /etc/festival/siteinit.scm
Patch31: 11-siteinit.diff
# the piece of fixed libestools location is not needed
# because we do not split festival and speech_tools
# for speech_tools in separate package; not applied
Patch32: 12-build-include-absolute-paths.diff
#Patch33: #12b-disabled-float_to_long.diff
Patch33: 13-performance-single-cdebug-output.diff
Patch34: 14-fix-emacs-utf8.diff
Patch35: 15-hts21compat.diff
Patch36: 16-audio-disable-esd.diff
Patch37: 17-performance-hts.diff
# if used, we move dtds; needs datadir (20-debian-filesystem-standard.diff)
Patch38: 18-debian-sgml.diff
# ?
Patch39: 19-debian-build.diff
# 1)not applied; we do not apply --datadir for estools too
# 2)not applied; breaks alt-fix-path-audsp.patch
# removes append ftlibdir/etc/$(OSTYPE):ftlibdir/etc to PATH
Patch40: 20-debian-filesystem-standard.diff
Patch41: 21-audio-choose-default.diff
Patch42: 22-hts-buffer-bounds-check.diff
# ------ end generated by debian-patches-series2spec.in ------
Patch43: festival-2.5-after-debian-07-doc-festival-doc-no-datadir.diff


################################################
# SuSE patches
################################################
Patch102:         festival-1.95-examples.patch
# it is safe to remove, as we set FTLIBDIR manually
Patch104:         festival-1.95-libdir.patch
# TODO: apply changes to init script too
Patch108:         festival-1.96-chroot.patch
# end festival SuSE patches

# Gentoo patches
Patch120:         festival-2.0.95-asterisk.patch

################################################
# festival mageia patches
################################################

# Fix linking problem because of multiple definitions
Patch421:	festival-2.4-mga-hts-multidef.patch



# -------- speech_tools patches --------------------------
# pre/debian
Patch45: speech-tools-2.5-alt-major-minor-for-debian.patch
# edited debian patches
Patch46: speech-tools-2.5-debian_build-wo-liblink.diff
# replace debian
# somehow this rule is also used in festival build (due to a patch?)
Patch47: speech-tools-2.5-alt-bettersonamehack.patch
Patch48: speech-tools-2.5-alt-link-libs-rule.patch

Patch250: speech-tools-2.5-debian_build-liblink-not-applied.diff

#------------------------------------
# from: speech-tools_2.5.0-9.debian
# ----------- generated by debian-patches-series2spec.in -----------
#n/a
Patch50: debian_build.diff
Patch51: config_config.in.diff
#n/a
Patch52: datadir_fhs.diff
Patch53: use_standard_headers.diff
Patch54: include_EST_TIterator.h.diff
Patch55: alaw.diff
Patch56: pulseaudio_and_alsa.diff
Patch57: Makefile.diff
Patch58: copyright_4clausefix.diff
Patch59: lintianspell.diff
Patch60: templatefixes.diff
Patch61: dontbuildesd.diff
Patch62: tokenstream_istream.diff
Patch63: wave_save_parts.diff
Patch64: wave_save_parts_alaw.diff
Patch65: check_fread.diff
Patch66: memory_bugs.diff
Patch67: ch_wave-LONGEST.diff
#n/a
Patch68: hardening.diff
Patch69: timestamp
Patch70: more-lintian-spelling.patch
#n/a
Patch71: link_estools_openmp.diff
Patch72: test_failure
Patch73: no-common
# ----------- end generated by debian-patches-series2spec.in -------



# SuSE patches (as of festival-1.96-101)
#Origname112:        speech_tools-1.2.95-config.patch
Patch112:        speech_tools-1.2.95-config-warn-on-suse.patch

%if_without bootstrap
Requires:	festvox
Requires:	mbrola
%endif

# Automatically added by buildreq on Mon Sep 25 2006
BuildRequires: gcc-c++ libstdc++-devel libncurses-devel libtinfo-devel
BuildRequires: libalsa-devel libpulseaudio-devel
# esound is deprecated and we disabled it
#BuildRequires: esound-devel libaudiofile-devel
# explicitly added texinfo for info files
BuildRequires: texinfo
BuildRequires(pre): rpm-macros-emacs

# TODO: for test
# No default voice found in ("../lib/voices/")
#(nitech_us_slt_arctic_hts nitech_us_awb_arctic_hts nitech_us_bdl_arctic_hts nitech_us_clb_arctic_hts nitech_us_jmk_arctic_hts nitech_us_rms_arctic_hts kal_diphone ked_diphone cstr_us_awb_arctic_multisyn cstr_us_jmk_arctic_multisyn)

# upgrade to 2.5
Conflicts: festvox_cmu_us_awb_cg < 2.5
Conflicts: festvox_cmu_us_rms_cg < 2.5
Conflicts: festvox_cmu_us_awb_arctic_hts < 2.1
Conflicts: festvox_cmu_us_bdl_arctic_hts < 2.1
Conflicts: festvox_cmu_us_jmk_arctic_hts < 2.1
Conflicts: festvox_cmu_us_slt_arctic_hts < 2.1
Conflicts: festvox_nitech_us_awb_arctic_hts <= 0.20080627-alt1
Conflicts: festvox_nitech_us_bdl_arctic_hts <= 0.20080627-alt1
Conflicts: festvox_nitech_us_clb_arctic_hts <= 0.20080627-alt1
Conflicts: festvox_nitech_us_jmk_arctic_hts <= 0.20080627-alt1
Conflicts: festvox_nitech_us_rms_arctic_hts <= 0.20080627-alt1
Conflicts: festvox_nitech_us_slt_arctic_hts <= 0.20080627-alt1

%description
Festival is a general purpose text-to-speech system.  As well as
simply rendering text as speech it can be used in an interactive
command mode for testing and developing various aspects of speech
synthesis technology.

Festival offers a full text to speech system with various APIs, as
 well an environment for development and research of speech synthesis
 techniques. It includes a Scheme-based command interpreter.

 Besides research into speech synthesis, festival is useful as a
 stand-alone speech synthesis program. It is capable of producing
 clearly understandable speech from text.

%package -n libfestival-devel
Summary: development kit for the Festival speech synthesis system
Group: Development/C
Requires: %name = %fst_version-%release
Provides: festival-devel = %fst_version-%release
Obsoletes: festival-devel < 1.96-alt3

%description -n libfestival-devel
This package contains the library and headers that can be used to
 develop programs that use Festival.  Documentation is now contained in the
 separate festival-doc package

%if_enabled static
%package -n libfestival-devel-static
Summary: development kit for the Festival speech synthesis system
Group: Development/C
Requires: libfestival-devel = %fst_version-%release

%description -n libfestival-devel-static
This package contains the static library that can be used to
 develop programs that use Festival.
%endif

%package -n speech_tools
Summary: Edinburgh Speech Tools - user binaries
Group:          Development/Other
Version: %est_version
Requires: libestools%estsuffix  = %est_version-%release

%description -n speech_tools
This package contains the various highly useful (to speech scientists, at
 least) utility programs that use and accompany the Edinburgh Speech Tools
 Library.

%package -n libestools%estsuffix
Summary: Edinburgh Speech Tools Library
Version: %est_version
License: MIT
Group: Sound
URL: http://www.cstr.ed.ac.uk/projects/festival.html

%description -n libestools%estsuffix
A library for use in speech software, such as the festival speech synthesis
 system.

%package -n libestools-devel
Summary: Edinburgh Speech Tools Library - developer's libraries and docs
# emacs syntax color cheat '
Version: %est_version
Group:          Development/C
Requires: libestools%estsuffix  = %est_version-%release

%description -n libestools-devel
This package contains the header files, static libraries, and documentation
 that developers using the Edinburgh Speech Tools Library will need.

%if_enabled static
%package -n libestools-devel-static
Summary: Edinburgh Speech Tools Library - static libraries
Group:          Development/C
Version: %est_version
Requires: libestools-devel  = %est_version-%release

%description -n libestools-devel-static
This package contains the static libraries
 that developers using the Edinburgh Speech Tools Library may need.
%endif

%prep
%setup -q -n festival
%setup -q -T -b 1 -a 2 -n speech_tools

cd $RPM_BUILD_DIR/festival
%patch0 -p2
%patch1 -p1
%patch4 -p2
%patch5 -p2
%patch6 -p1 -b .soversion


# /etc/festival dir; part of debian patch31
%patch20 -p1

# --- generated by debian-patches-series2spec.in -------
#%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p1
# might be applied. requires fixing Source5/Source6 scm and it's install?
#%patch31 -p1
# for speech_tools in separate package; not applied
#patch32 -p1
%patch33 -p1
%patch34 -p1
%patch35 -p1
%patch36 -p1
%patch37 -p1
# needs to move to /usr/share/sgml/festival in install
#%patch38 -p1
# ?
#%patch39 -p1
# ?
#%patch40 -p1
%patch41 -p1
%patch42 -p1
# --- end generated by debian-patches-series2spec.in ---
%patch43 -p1
# sed'ing after-debian patch 21-audio-choose-default.diff
sed -i s,/etc/festival.scm,/etc/festival/siteinit.scm,g lib/init.scm

%patch102 -p1
%patch104 -p0
%patch108 -p0

%patch120 -p2

%patch421 -p1



cd $RPM_BUILD_DIR/speech_tools
%patch45 -p1
%patch46 -p1

# somehow this rule is also used in festival build
# due to
#festival/Makefile:include $(EST)/config/rules/top_level.mak
#festival/Makefile:include $(EST)/config/rules/install.mak
# ... so on include $(EST) ...
%patch47 -p1 -b .soname
%patch48 -p1 -b .link-libs-rule
#%patch250 -p1

# --- generated by debian-patches-series2spec.in -------
#%patch50 -p1 -b .debian_build
%patch51 -p1 -b .config_config.in
# # --libdir is used in build process :(
#patch52 -p1 -b .datadir_fhs
%patch53 -p1
%patch54 -p1
%patch55 -p1
%patch56 -p1
%patch57 -p1
%patch58 -p1
%patch59 -p1
%patch60 -p1
%patch61 -p1 -b .dontbuildesd
%patch62 -p1
%patch63 -p1
%patch64 -p1
%patch65 -p1
%patch66 -p1
%patch67 -p1
#patch68 -p1 -b .hardening
%patch69 -p1
%patch70 -p1
#patch71 -p1 -b .link_estools_openmp
%patch72 -p1
%patch73 -p1
# --- end generated by debian-patches-series2spec.in ---

%patch112 -p0

sed -i 's,/usr/local\>,/usr,g' config/systems/default.mak

#sed -i s/'#SHARED='/'SHARED='/ config/config.in config/config

# linking against libraries to avoid unresolved symbols
echo "PROJECT_LIBRARY_NEEDS_SYSLIBS_estbase = 1" >> config/project.mak
echo "PROJECT_LIBRARY_NEEDS_SYSLIBS_esttools = 1" >> config/project.mak
# required for proper linking; tinfo is alt-spccific
echo "PROJECT_LIBRARY_USES_estools = estbase tinfo" >> config/project.mak

%build
# Build Edinburgh Speech Tools
cd $RPM_BUILD_DIR/speech_tools
%add_optflags -Wno-non-template-friend
cp -pv /usr/share/gnu-config/* .
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
sed -i 's,^CXXFLAGS.*$,& -std=c++11,' config/compilers/gcc_defaults.mak
%endif
./configure
#-------------
# parallel build fails, so bare make
make MAKE_SHARED_LIB="g++ -shared -o XXX -Wl,--as-needed -Wl,-soname -Wl,YYY"

# whether links are created depends on patches applied
pushd lib
if [ ! -e libestbase.so.%est_soversion ]; then
    echo est_soversion is bad: %est_soversion
    exit 1
elif [ ! -e libestbase.so.%estsuffix ]; then
    ln -s libestbase.so.%{est_soversion} libestbase.so.%estsuffix
    ln -s libestools.so.%{est_soversion} libestools.so.%estsuffix
    ln -s libeststring.so.%{est_soversion} libeststring.so.%estsuffix
fi

ln -sf libestbase.so.%estsuffix   libestbase.so
ln -sf libestools.so.%estsuffix   libestools.so
ln -sf libeststring.so.%estsuffix libeststring.so
popd

%if_enabled speech_tools_test
make test
%endif

# Build Festival
cd $RPM_BUILD_DIR/festival
cp -pv /usr/share/gnu-config/* .
sed -i 's!main(){return(0);}!int main(){return(0);}!' configure
%configure
cat <<EOF >>config/config
# FESTIVAL_HOME := %_prefix
# INCLUDE_TCL=1
FTLIBDIR := %_datadir/festival
# indicates that speech_tools are built shared
# SHARED = 1
# GCC_MAKE_SHARED_LIB = gcc -shared -o XXX
EOF

# hack...
echo "PROJECT_LIBRARY_NEEDS_SYSLIBS_Festival = 1" >> config/project.mak
echo "PROJECT_LIBRARY_USES_Festival = estbase eststring" >> config/project.mak

make  CXXFLAGS="-fpermissive -Wno-non-template-friend -fPIC" CFLAGS="-fpermissive -Wno-non-template-friend -O3 -fPIC"

# Force fixed %%CreationDate in ps files created by dvips (for a Reproducible Build)
export FORCE_SOURCE_DATE=1

export LD_LIBRARY_PATH=`pwd`/../speech_tools/lib:`pwd`/src/lib
pushd doc
make festival.info
popd

#Upstream states test is only for their local development not a functional test
#no make test

%install

# Install Edinburgh Speech Tools
cd $RPM_BUILD_DIR/speech_tools

S_PROGRAMS="bcat ch_lab ch_track ch_utt ch_wave dp na_play na_record ngram_build \
	ngram_test ols ols_test	pda pitchmark scfg_make scfg_parse scfg_test \
	scfg_train sig2fv sigfilter spectgen tilt_analysis tilt_synthesis \
	viterbi wagon wagon_test wfst_build wfst_run"
S_UNDOC="bcat dp ngram_build \
	ngram_test ols ols_test	pda pitchmark scfg_make scfg_parse scfg_test \
	scfg_train sig2fv sigfilter spectgen tilt_analysis tilt_synthesis \
	viterbi wagon wagon_test wfst_build wfst_run pm make_wagon_desc \
	raw_to_xgraph resynth"
S_SCRIPTS="pm.prl raw_to_xgraph.prl make_wagon_desc.sh resynth.sh"
export S_PROGRAMS S_UNDOC S_SCRIPTS

install -d $RPM_BUILD_ROOT{%_libdir,%_bindir,%_datadir,%_includedir}

# -- Installing package libestoolsXX --
cp -a lib/*.so* $RPM_BUILD_ROOT%_libdir/

# -- Installing package speech_tools --
pushd main
cp $S_PROGRAMS $RPM_BUILD_ROOT%_bindir/
popd
pushd scripts
	for i in $S_SCRIPTS; do \
		dest=`echo $i | sed -e 's/\.\(prl\|sh\)$//'`; \
		sed -e 's,__PERL__,/usr/bin/perl,g' \
			<$i >$RPM_BUILD_ROOT%_bindir/$dest; \
		chmod +x $RPM_BUILD_ROOT%_bindir/$dest; \
	done
popd

# -- Installing package libestools1.2-dev --
install -d $RPM_BUILD_ROOT%_libdir/speech_tools/lib/siod \
	$RPM_BUILD_ROOT%_includedir/speech_tools/{unix,instantiate,sigpr,rxp,ling_class}
cp lib/*.a $RPM_BUILD_ROOT%_libdir/

cp include/*.h $RPM_BUILD_ROOT%_includedir/speech_tools/
cp include/unix/*.h $RPM_BUILD_ROOT%_includedir/speech_tools/unix/
# Note: these are possibly internal headers (C++ lossage)
cp include/instantiate/*.h $RPM_BUILD_ROOT%_includedir/speech_tools/instantiate/

cp include/sigpr/*.h $RPM_BUILD_ROOT%_includedir/speech_tools/sigpr/
cp include/ling_class/*.h $RPM_BUILD_ROOT%_includedir/speech_tools/ling_class/
cp include/rxp/*.h $RPM_BUILD_ROOT%_includedir/speech_tools/rxp/
cp base_class/*.h $RPM_BUILD_ROOT%_includedir/speech_tools/

# Needed to compile things against speech_tools
cp -R config $RPM_BUILD_ROOT%_libdir/speech_tools/config
find $RPM_BUILD_ROOT%_libdir/speech_tools/config/ \
	\( -name SCCS -o -name CVS -o -name RCS \) -print0 | \
	xargs -0r rm -rf
cp make.include $RPM_BUILD_ROOT%_libdir/speech_tools/
cp lib/siod/*.scm $RPM_BUILD_ROOT%_libdir/speech_tools/lib/siod/

chmod +x $RPM_BUILD_ROOT%_libdir/speech_tools/config/rules/modules.sh
chmod +x $RPM_BUILD_ROOT%_libdir/speech_tools/config/system.sh

# we already instantiated templates in libsetools.
# it prevents festival from trying to instantiate it from speech_tools source
sed -i 's/^TEMPLATE_SPECIFIC = -DINSTANTIATE_TEMPLATES/TEMPLATE_SPECIFIC =/' \
$RPM_BUILD_ROOT%_libdir/speech_tools/config/compilers/gcc_defaults.mak

# Compatibility with past packages
ln -sf speech_tools $RPM_BUILD_ROOT%_includedir/estools
ln -sf speech_tools $RPM_BUILD_ROOT%_includedir/est

SBTM=$RPM_BUILD_ROOT%_man1dir
mkdir -p $SBTM
install -m644 debian.manpages/speech-tools.1 $SBTM/speech-tools.1
gzip -9 $SBTM/speech-tools.1
for f in $S_UNDOC ; do ln -sf speech-tools.1.gz $SBTM/$f.1.gz ; done

# installing debian man pages
install -d $RPM_BUILD_ROOT%_man1dir/

install -m644 debian.manpages/ch_track.1 $RPM_BUILD_ROOT%_man1dir/ch_track.1
install -m644 debian.manpages/na_play.1 $RPM_BUILD_ROOT%_man1dir/na_play.1
install -m644 debian.manpages/na_record.1 $RPM_BUILD_ROOT%_man1dir/na_record.1
install -m644 debian.manpages/ch_lab.1 $RPM_BUILD_ROOT%_man1dir/ch_lab.1
install -m644 debian.manpages/ch_utt.1 $RPM_BUILD_ROOT%_man1dir/ch_utt.1
install -m644 debian.manpages/ch_wave.1 $RPM_BUILD_ROOT%_man1dir/ch_wave.1

# Install Festival

cd $RPM_BUILD_DIR/festival
install -d $RPM_BUILD_ROOT%_bindir

# install binarys
install -D bin/text2wave $RPM_BUILD_ROOT%_bindir/text2wave
install -m 755 bin/festival_server* $RPM_BUILD_ROOT%_bindir/
install -m 755 src/main/festival $RPM_BUILD_ROOT%_bindir
install -m 755 src/main/festival_client $RPM_BUILD_ROOT%_bindir
install -m 755 examples/saytime $RPM_BUILD_ROOT%_bindir/
# install configs
#install -D lib/festival.scm $RPM_BUILD_ROOT%_sysconfdir/festival.scm
install -m644 -D %{SOURCE5} $RPM_BUILD_ROOT%_sysconfdir/festival/siteinit.scm
# server config; loaded directly in init script
install -m644 -D %{SOURCE4} $RPM_BUILD_ROOT%_sysconfdir/festival/server.scm

# too unsecure: let it be in docs
#install -m755 -D %{SOURCE3} $RPM_BUILD_ROOT%_initdir/festival
cp %{SOURCE3} .
install -m644 -D %{SOURCE11} $RPM_BUILD_ROOT%_unitdir/festival.service

set `find ./lib/etc -name audsp`
install -D $1 $RPM_BUILD_ROOT%festival_libexec_dir/audsp

install -d $RPM_BUILD_ROOT%_datadir/festival/multisyn
install -m 644 lib/*.scm $RPM_BUILD_ROOT%_datadir/festival/
install -d $RPM_BUILD_ROOT%_datadir/festival/languages
install -m 644 lib/languages/*.scm $RPM_BUILD_ROOT%_datadir/festival/languages/
install -m 644 lib/multisyn/*.scm $RPM_BUILD_ROOT%_datadir/festival/multisyn/

# if applied debian-sgml diff
# install to sgml/festival:
#install -m 644 lib/sable-latin.ent $RPM_BUILD_ROOT%_datadir/sgml/festival
#install -m 644 Singing.v0_1.dtd $RPM_BUILD_ROOT%_datadir/sgml/festival
#install -m 644 lib/Sable.v0_2.dtd $RPM_BUILD_ROOT%_datadir/sgml/festival
#install debian.festival/festival.catalog to /usr/share/sgml/festival/catalog
#else
install -m 644 lib/*.ent $RPM_BUILD_ROOT%_datadir/festival
install -m 644 lib/*.dtd $RPM_BUILD_ROOT%_datadir/festival
#endif

#install -m 644 lib/scfg_wsj_wp20.gram $RPM_BUILD_ROOT%_datadir/festival
#install -m 644 lib/sec.B.hept.ngrambin $RPM_BUILD_ROOT%_datadir/festival
#install -m 644 lib/sec.ts20.quad.ngrambin $RPM_BUILD_ROOT%_datadir/festival
install -m 644 lib/*.gram $RPM_BUILD_ROOT%_datadir/festival
install -m 644 lib/*.ngrambin $RPM_BUILD_ROOT%_datadir/festival

# TODO: 1)bytecompile 2) move to emacs-festival?
install -m 644 -D lib/festival.el $RPM_BUILD_ROOT%_datadir/emacs/site-lisp/festival.el
install -m 644 -D %{SOURCE10} $RPM_BUILD_ROOT%_emacs_sitestart_dir/50festival.el


# install manpages
install -d $RPM_BUILD_ROOT%_man1dir
install -m 644 doc/*.1 $RPM_BUILD_ROOT%_man1dir
# TODO:
#install -D -m 644 doc/festival.1 $RPM_BUILD_ROOT%_man1dir/festival.1
#install -m 644 doc/festival_client.1 $RPM_BUILD_ROOT%_man1dir/
#install -m 644 doc/text2wave.1 $RPM_BUILD_ROOT%_man1dir/

mkdir $RPM_BUILD_ROOT%{_infodir}
cp -p doc/info/* $RPM_BUILD_ROOT%{_infodir}/

# ALTLinux README
cp %{SOURCE7} .
# README.Debian
cp %{SOURCE8} .
# README.testing
cp %{SOURCE9} .

# Install libfestival-devel
install -d $RPM_BUILD_ROOT%_includedir/festival
install -m 644 src/include/*.h $RPM_BUILD_ROOT%_includedir/festival/

%if_enabled static
# Install libfestival-devel-static
install -m 644 src/lib/libFestival.a $RPM_BUILD_ROOT%_libdir/
%endif

install -m 644 src/lib/libFestival.so* $RPM_BUILD_ROOT%_libdir/

# install examples 
# preparing hardcoded path to examples (/usr/share/doc/festival/examples)
mkdir -p $RPM_BUILD_ROOT%_datadir/doc
# cleaning examples dir
ln -s %{name}-%{fst_version} $RPM_BUILD_ROOT%_datadir/doc/%{name}
rm -f examples/Makefile examples/songs/Makefile examples/*.sh


# RedHat Fedora festival-1.95 based
#######################################################################
# Fix up the headers to look for other includes where we want them, not
# where they're supposed to be in the source tree
# There is probably a better way to do this, I'm not (yet) a sed expert.
# What this does is, basically, replacing "EST_*.h" with <speech_tools/EST_*.h>.
for i in `find $RPM_BUILD_ROOT%{_includedir}/speech_tools/ -type f \( -name '*.h' -or -name '*.cc' \)` `find $RPM_BUILD_ROOT%{_includedir}/festival/ -type f \( -name '*.h' -or -name '*.cc' \)`; do
  sed \
	-e 's,"\(EST.*\.h\)",\<speech_tools/\1\>,g' \
	-e 's,"\(siod.*\.h\)",\<speech_tools/\1\>,g' \
	-e 's,"\(instantiate/.*\.h\)",\<speech_tools/\1\>,g' \
	-e 's,"\(ling_class/.*\.h\)",\<speech_tools/\1\>,g' \
	-e 's,"rxp\.h",\<speech_tools/rxp/rxp\.h\>,g' \
	-e 's,"\(rxp/.*\.h\)",\<speech_tools/\1\>,g' \
  	-e 's,"\(sigpr/.*\.h\)",\<speech_tools/\1\>,g' \
	-e 's,"\(unix/.*\.h\)",\<speech_tools/\1\>,g' \
	-e 's,"festival\.h",\<festival/festival.h\>,g' \
  	-e 's,"ModuleDescription\.h",\<festival/ModuleDescription.h\>,g' \
  	-e 's,"Phone\.h",\<festival/Phone.h\>,g' \
      $i >$i-alt
  mv -f $i-alt $i
done

%pre
/usr/sbin/groupadd -r -f %festival_group ||:
grep '^%festival_user:' /etc/passwd >/dev/null || \
/usr/sbin/useradd -N -g %festival_group -c 'The Festival Speech Synthesizer' \
        -d %festival_home -s /dev/null -r %festival_user ||:

%files
%doc ../festival/{README.md,ACKNOWLEDGMENTS,COPYING,NEWS}
%doc ../festival/README.ALTLinux
%doc ../festival/README.Debian
%doc ../festival/README.testing
#%_initdir/festival
%_unitdir/festival.service
%doc ../festival/festival.init
%config(noreplace) %_sysconfdir/festival/server.scm
%dir %_sysconfdir/festival
%config(noreplace) %_sysconfdir/festival/siteinit.scm
# examples
%doc %_datadir/doc/%{name}
%doc ../festival/examples
# end examples
#%_bindir/festival*
%_bindir/festival
%_bindir/festival_client
%if_with legacy_server_scripts
%_bindir/festival_server
%_bindir/festival_server_control
%else
%exclude %_bindir/festival_server
%exclude %_bindir/festival_server_control
%endif
%_bindir/text2wave
%_bindir/saytime
%dir %_datadir/festival/
%dir %festival_libexec_dir
%festival_libexec_dir/audsp
%_datadir/festival/*
%_infodir/festival*
%_man1dir/festival*
%_man1dir/text2wave*
%_datadir/emacs/site-lisp/festival.el
%_libdir/libFestival.so.*

%files -n libestools%estsuffix
%_libdir/libest*.so.%{estsuffix}*

%files -n libfestival-devel
%dir %{_includedir}/festival
%{_includedir}/festival/*
%_libdir/libFestival.so

%if_enabled static
%files -n libfestival-devel-static
%_libdir/libFestival.a
%endif

%files -n libestools-devel
%doc ../speech_tools/README.md
%_includedir/estools
%_includedir/est
%dir %{_includedir}/speech_tools
%{_includedir}/speech_tools/*
%_libdir/speech_tools/*
%_libdir/libest*.so
%if_enabled static
%files -n libestools-devel-static
%_libdir/libest*.a
%else
%exclude %_libdir/libest*.a
%endif

%files -n speech_tools
%doc ../speech_tools/README.md
%_bindir/[^f]*
%_man1dir/[^f]*.1*
%exclude %_bindir/festival*
%exclude %_bindir/text2wave
%exclude %_bindir/saytime
%exclude %_man1dir/text2wave*


%changelog
