Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
#in noarch? why...
%global debug_package %{nil}
#javadoc is empty. Keep building it now with hope for bright future
%global with_javadoc 1

Name:       fernflower
Version:    211.7442.40
Release:    alt1_1jpp11
Summary:    JIdea's java decompiler
License:    ASL 2.0 
URL:        https://github.com/JetBrains/intellij-community/tree/master/plugins/java-decompiler/engine

#Source0:   https://github.com/JetBrains/intellij-community/archive/idea/%%{version}.tar.gz
# this source is 280MB big, so only the decompiler is repacked via create-sources.sh and has 350kB
# generated by source2; `create-sources.sh 183.5153.8`
Source0:    %{name}-%{version}.tar.gz
# launcher
Source1:    %{name}
Source2:    create-sources.sh

Patch0:     remove_main.patch
Patch1:     port_to_java_8.patch

BuildArch:  noarch

BuildRequires:  javapackages-tools
%if %{with_javadoc}
BuildRequires:  zip
%endif
Requires:      javapackages-tools
Provides:      %{name}-decompiler
Source44: import.info

%description
JIdea's decompiler is the first actually working analytical decompiler for Java and probably
for a high-level programming language in general. Naturally it is still under development,
please send your bug reports and improvement suggestions to the issue tracker.

%if %{with_javadoc}
%package javadoc
Group: Development/Java
Summary: %{name} API documentation
Requires: javapackages-filesystem
BuildArch: noarch
Provides:  %{name}-decompiler-javadoc

%description javadoc
The %{name} 100% empty API documentation.
%endif

%prep
%setup
# removing test classes and jars, tests are not run in rpm build anyway (but can be run out of it)
# maybe to pack them as demos?
find | grep "\\.class$"
find | grep "\\.jar$"
rm -rvf test
rm -rvf testData
rm  -vf gradle/wrapper/gradle-wrapper.jar
find | grep "\\.class$" && exit 1
find | grep "\\.jar$"   && exit 1
#removing main method from entry point jar
%patch0
%patch1 -p1

%build
mkdir build
javac  -target 1.8 -source 1.8 -source 8 -target 8 -d build `find src -type f`
cd build
jar -cf ../%{name}.jar  org
cd ..
mkdir build/libs
mv %{name}.jar build/libs/
%if %{with_javadoc}
# this is sad. Javadoc is really 100% empty
mkdir fernflower-javadoc 
cd fernflower-javadoc 
javadoc `find ../src -type f`
cd ..
zip -r %{name}.zip fernflower-javadoc
%endif

%install
mkdir -p $RPM_BUILD_ROOT/%{_bindir}/
cp %{SOURCE1}  $RPM_BUILD_ROOT/%{_bindir}/ # cusotm launcher for main method in main jar
mkdir -p $RPM_BUILD_ROOT/%{_javadir}/
cp  build/libs/%{name}.jar $RPM_BUILD_ROOT/%{_javadir}
%if %{with_javadoc}
mkdir -p $RPM_BUILD_ROOT/%{_javadocdir}/%{name}
cp %{name}.zip $RPM_BUILD_ROOT/%{_javadocdir}/
%endif

%files
%doc --no-dereference LICENSE.txt
%doc README.md
%{_javadir}/%{name}.jar
%attr(755, root, root) %{_bindir}/%{name}

%if %{with_javadoc}
%files javadoc
%doc --no-dereference LICENSE.txt
%doc README.md
%{_javadocdir}/%{name}.zip
%endif

%changelog
