%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lfs=relaxed

Name: fakechroot
Version: 2.20.1
Release: alt4
Summary: Gives a fake chroot environment
Group: Development/Tools
License: LGPL-2.1-or-later
Url: https://github.com/dex4er/fakechroot
# For ldd.fakechroot
Requires: /usr/bin/objdump

Source: %name-%version.tar
BuildRequires: perl-devel
BuildRequires: python3-base
BuildRequires: /usr/bin/pod2man

%description
fakechroot runs a command in an environment were is additionally
possible to use the chroot(8) call without root privileges. This is
useful for allowing users to create their own chrooted environment
with possibility to install another packages without need for root
privileges.

%prep
%setup
# We have even stronger fortify level by default.
grep -Zlr '_FORTIFY_SOURCE' | xargs -0 sed -i '/^#define _FORTIFY_SOURCE 2/d'

%build
%ifarch x86_64
%add_optflags -fanalyzer
%endif
%add_optflags -Wno-unused-variable
%autoreconf
%configure \
	--disable-static \
	--disable-silent-rules \
	%nil
%make_build

# For dependency-clean %%doc.
chmod -x scripts/{relocatesymlinks,restoremode,savemode}.sh

%install
%makeinstall_std
# Drop libtool files
find %buildroot%_libdir -name '*.la' -delete -print

%check
%make_build check || {
	cat test/test-suite.log
	exit 1
}

%files
%doc scripts/{relocatesymlinks,restoremode,savemode}.sh
%doc NEWS.md README.md
%doc COPYING LICENSE
%_bindir/%name
%_bindir/env.%name
%_bindir/ldd.%name
%_sbindir/chroot.%name
%_libdir/%name/
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/chroot.env
%config(noreplace) %_sysconfdir/%name/debootstrap.env
%config(noreplace) %_sysconfdir/%name/rinse.env
%_mandir/man1/%name.1*

%changelog
