%define ABIVERSION 0

Name:          faac
Version:       1.30
Release:       alt2
Summary:       FAAC is a Freeware Advanced Audio Coder
License:       LGPL
Group:         Sound
Url:           https://sourceforge.net/projects/faac/
Vcs:           https://github.com/knik0/faac.git

Source:        %name-%version.tar
BuildRequires: gcc-c++
BuildRequires: libmp4v2-devel
BuildRequires: pkgconfig(sndfile)

%description
FAAC is an Advanced Audio Coder (MPEG2-AAC, MPEG4-AAC). The goal of FAAC is to
explore the possibilities of AAC and exceed the quality of the currently best
MP3 encoders.

%package       -n lib%name
Summary:       Freeware Advanced Audio Coder (FAAC) libraries
Group:         Development/Other

Obsoletes:     lib%{name}%ABIVERSION < %EVR
Provides:      lib%{name}%ABIVERSION = %EVR

%description   -n lib%name
This package contains Freeware Advanced Audio Coder (FAAC) shared
libraries.

FAAC is an Advanced Audio Coder (MPEG2-AAC, MPEG4-AAC). The goal of FAAC is to
explore the possibilities of AAC and exceed the quality of the currently best
MP3 encoders.

%package       -n lib%name-devel
Summary:       Development files for the FAAC AAC coder library
Group:         Development/C

Requires:      gcc-c++
Requires:      libmp4v2-devel
Requires:      pkgconfig(sndfile)

%description   -n lib%name-devel
This package provides header files development libraries and
documentation for lib%name.

FAAC is an Advanced Audio Coder (MPEG2-AAC, MPEG4-AAC). The goal of FAAC is to
explore the possibilities of AAC and exceed the quality of the currently best
MP3 encoders.

%prep
%setup
%ifarch %e2k
sed -i 's/!defined(__clang__)/& \&\& !defined(__EDG__)/' libfaac/quantize.c
%endif

%build
%autoreconf
%configure \
	--with-mp4v2 \
	--disable-static

%make_build

%install
%makeinstall

%files
%doc docs/%name.html
%_bindir/*
%_man1dir/*

%files         -n lib%name
%doc ChangeLog NEWS README TODO
%_libdir/*.so.*

%files         -n lib%name-devel
%doc docs/lib%name.html
%_includedir/*
%_libdir/*.so

%changelog
