%define _unpackaged_files_terminate_build 1
%define pypi_name eyeD3
%define oname eyed3

%def_with check

Name: eyeD3
Version: 0.9.9
Release: alt1

Summary: Console tool that displays and manipulates id3-tags on mp3 files
License: GPL-3.0
Group: Sound
URL: https://pypi.org/project/eyed3
VCS: https://github.com/nicfit/eyeD3

Source0: %name-%version.tar
Source1: http://eyed3.nicfit.net/releases/eyeD3-test-data.tgz

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-coverage
BuildRequires: python3-module-deprecation
BuildRequires: python3-module-filetype
BuildRequires: python3-module-factory_boy
BuildRequires: python3-module-pyaml
%endif
Requires: python3-module-%name = %EVR


%description
eyeD3 manipulates ID3 tags in mp3 files and is able to read/write and
convert between ID3 v1.0, v1.1, v2.3 and v2.4 tags. High-level access
is provided to most frames, including APIC (i.e., images) frames.

%package -n python3-module-%name
Summary: A python module for processing mp3 files
Group: Development/Python3

%description -n python3-module-%name
eyeD3 is a Python module and program for processing ID3 tags.
Information about mp3 files (i.e bit rate, sample frequency,
play time, etc.) is also provided.  The formats supported are ID3
v1.0/v1.1 and v2.3/v2.4.

This module is built for python %_python_version

%prep
%setup
tar xvf %SOURCE1 -C tests
# If you know more beautiful way to do it, FIXME
mv tests/eyeD3-test-data tests/data

%build
%pyproject_build

%install
%pyproject_install

%check
# Seems that it wants some color output in hasher, that we dont have
%pyproject_run_pytest -k 'not test_init_color_enabled'

%files
%doc LICENSE *.rst docs/ examples/
%_bindir/%name

%files -n python3-module-%name
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
