%define _name etr

Name: extreme-tuxracer
Epoch: 1
Version: 0.8.4
Release: alt2

Summary: High speed arctic racing game based on Tux Racer

Group: Games/Arcade
License: GPL-2.0-or-later
Url: https://sourceforge.net/projects/extremetuxracer/

Source: https://downloads.sourceforge.net/extremetuxracer/%_name-%version.tar.xz
# https://sourceforge.net/p/extremetuxracer/discussion/help/thread/6de9a5beae/?limit=25#a5be/4c13/e5b7/26cd
# https://github.com/jcowgill/extremetuxracer/commit/5823ba6c18432e083ec103ce74921270d7e071d6
Patch10: etr-0.8.4-up-SFML3.patch

Requires: %name-data = %EVR

BuildRequires: libappstream-glib-devel
BuildRequires: gcc-c++ libGLU-devel libSFML-devel >= 3.0

%description
Extreme Tux Racer is an open source racing game featuring
Tux the Linux Penguin. ETRacer continues in the tracks of Tux Racer
and its forks.

%package data
Summary: Arch independent files for Extreme Tux Racer
Group: Games/Arcade
BuildArch: noarch

%description data
This package provides noarch data needed for Extreme Tux Racer to work.

%prep
%setup -n %_name-%version
%patch10 -p1
# ++17 required for SFML-3.0
sed -i 's/++14/++17/' configure.ac

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
%find_lang %_name

%files -f %_name.lang
%_bindir/%_name
%_desktopdir/net.sourceforge.extremetuxracer.desktop

%files data
%_pixmapsdir/*
%_datadir/%_name
%_datadir/doc/%_name
%_datadir/metainfo/net.sourceforge.extremetuxracer.metainfo.xml

%changelog
