%define pkgdocdir %_docdir/%name-%version

Name: expat
Version: 2.7.3
Release: alt1

Summary: An XML parser written in C

License: MIT
Group: System/Base
URL: http://www.libexpat.org
VCS: https://github.com/libexpat/libexpat

Source: %name-%version.tar

Requires: lib%name = %version-%release

# for "make check"
BuildRequires: gcc-c++

# for docs
BuildRequires: /usr/bin/xmlto

%package -n lib%name
Summary: XML parser library
Group: System/Libraries

%package -n lib%name-devel
Summary: Development files for Expat, an XML parser library for C
Group: Development/C
Requires: lib%name = %version-%release
Provides: expat-devel = %version
Obsoletes: expat-devel

%description
Expat is a stream-oriented XML parser written in C.

%description -n lib%name
Expat is a stream-oriented XML parser written in C.
This package provides the Expat parser as a shared library.

%description -n lib%name-devel
Expat is a stream-oriented XML parser written in C.
This package is needed if you want to build programs which use Expat
library.

%prep
%setup

%build
pushd %name
%autoreconf
export DOCBOOK_TO_MAN="xmlto man --skip-validation"
%configure --disable-static
%make_build
popd

%install
pushd %name
%makeinstall_std

# Relocate shared library from /usr/lib to /lib.
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/libexpat.so.1* %buildroot/%_lib
rm %buildroot%_libdir/libexpat.so
ln -s ../../%_lib/libexpat.so.1 %buildroot%_libdir/libexpat.so

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS README.md COPYING Changes %buildroot%pkgdocdir/
install -p -m644 doc/*.{html,css} %buildroot%pkgdocdir/
install -d -m755 %buildroot%pkgdocdir/examples
install -p -m644 examples/*.c %buildroot%pkgdocdir/examples/

popd

%check
pushd %name
%make_build check
popd

%files
%_bindir/*
%_man1dir/*

%files -n lib%name
/%_lib/*.so.*
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/Changes
%pkgdocdir/COPYING
%pkgdocdir/README.md

%files -n lib%name-devel
%_libdir/*.so
%_libdir/cmake/expat-%version
%_includedir/*
%_pkgconfigdir/*.pc
%dir %pkgdocdir
%pkgdocdir/*.html
%pkgdocdir/*.css
%pkgdocdir/examples

%changelog
