%set_verify_elf_method rpath=relaxed
%define ver_major 3.58
%define ver_base 3.58
%define evo_ver_base %ver_base

%define xdg_name org.gnome.Evolution

Name: evolution-ews
Version: %ver_major.2
Release: alt1

Summary: Evolution extension for Exchange Web Services
Group: Networking/Mail
License: LGPL-2.1
Url: https://wiki.gnome.org/Apps/Evolution

Vcs: https://gitlab.gnome.org/GNOME/evolution-ews.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define evolution_ver %ver_major
%define eds_ver %ver_major
%define glib_ver 2.68
%define libmspack_ver 0.4
%define soup3_ver 3.0
%define json_glib_ver 1.0.4

Requires: evolution >= %evolution_ver
Requires: evolution-data-server >= %eds_ver
Requires: libmspack >= %libmspack_ver

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ninja-build gcc-c++ intltool
BuildRequires: evolution-data-server-devel >= %eds_ver
BuildRequires: evolution-devel >= %evolution_ver
BuildRequires: libmspack-devel >= %libmspack_ver
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= 3.0
BuildRequires: libsoup3.0-devel >= %soup3_ver
BuildRequires: libsqlite3-devel libical-devel
BuildRequires: pkgconfig(json-glib-1.0) >= %json_glib_ver

%description
This package allows Evolution to interact with Microsoft Exchange servers,
versions 2007 and later, through its Exchange Web Services (EWS) interface.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
# reenable RPATH* to link against private libraries
%cmake -GNinja \
    -DCMAKE_SKIP_RPATH:BOOL=OFF \
    -DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
    -DCMAKE_BUILD_WITH_INSTALL_RPATH:BOOL=ON \
    -DENABLE_SCHEMAS_COMPILE:BOOL=OFF
%cmake_build

%install
%cmake_install

# Remove files we don't want packaged (no devel subpackage).
rm -rf %buildroot%_includedir/evolution-data-server
rm -f %buildroot%_libdir/evolution-data-server/*.so

%find_lang %name

%files -f %name.lang
%doc COPYING NEWS README*
%_libdir/%name/*.so
%_libdir/evolution-data-server/camel-providers/*
%_libdir/evolution-data-server/addressbook-backends/*.so
%_libdir/evolution-data-server/calendar-backends/*.so
%_libdir/evolution-data-server/registry-modules/*.so
%_libdir/evolution/modules/*.so
%_datadir/evolution/errors/*.error
%_datadir/evolution-data-server/ews/windowsZones.xml
%_datadir/metainfo/%xdg_name-ews.metainfo.xml

%changelog
