%def_disable snapshot
%define xdg_name org.gnome.Evince

%define _libexecdir %_prefix/libexec
%define ver_major 48
%define beta %nil
%define api_ver_major 4
%define lib_api_ver 3
%define api_ver %lib_api_ver.0
%define so_ver 4

%def_enable xps
%def_enable ps
%def_enable dbus
%def_enable introspection
%def_disable nautilus
%def_enable gtk_doc
%def_disable debug

Name: evince
Version: %ver_major.1
Release: alt1%beta

Summary: A document viewer
Group: Office
License: GPL-2.0-or-later
Url: https://apps.gnome.org/Evince

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %EVR
Requires: %name-data = %EVR
Requires: gnome-icon-theme gnome-icon-theme-symbolic icon-theme-adwaita
Requires: gvfs-backend-recent-files
Requires: dconf
# for feature GTK4 GtkVideo widget
Requires: gst-plugins-base1.0 gst-libav

%define poppler_ver 22.05.0
%define libarchive_ver 3.6.0
%define gtk_ver 3.22
%define handy_ver 1.5.0
%define spectre_ver 0.2.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
# for old meson (in p10)
BuildRequires: /usr/bin/update-desktop-database
BuildRequires: libpoppler-glib-devel >= %poppler_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: gcc-c++ gnome-common /usr/bin/appstream-util yelp-tools
BuildRequires: icon-theme-adwaita libdjvu-devel libgnome-keyring-devel
BuildRequires: libspectre-devel >= %spectre_ver libtiff-devel
BuildRequires: libxml2-devel libkpathsea-devel libgail3-devel gsettings-desktop-schemas-devel
BuildRequires: zlib-devel libsecret-devel libarchive-devel >= %libarchive_ver libgspell-devel
BuildRequires: libsynctex-devel
BuildRequires: libgnome-desktop3-devel
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
%{?_enable_xps:BuildRequires: libgxps-devel}
%{?_enable_dbus:BuildRequires: libdbus-devel}
%{?_enable_multimedia:BuildRequires: gst-plugins1.0-devel}
%{?_enable_nautilus:BuildRequires: libnautilus-devel}
%{?_enable_introspection:
BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
BuildRequires: libXi-devel
BuildRequires: pkgconfig(systemd)

%description
Evince is a document viewer capable of displaying multiple and single page
document formats like PDF and Postscript

%package data
Summary: Arch independent files for Evince
Group: Office
BuildArch: noarch

%description data
This package provides noarch data needed for Evince to work.

%package dvi
Summary: Evince backend for dvi files
Group: Office
Requires: %name = %EVR

%description dvi
A backend to let evince display dvi files

%package -n lib%name
Summary: Library for the %name project
Group: System/Libraries

%description -n lib%name
Library for %name project

%package -n lib%name-gir
Summary: GObject introspection data for the Evince library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Evince library

%package -n lib%name-devel
Summary: Development files for the %name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Header files for %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Evince library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the Evince library

%package -n lib%name-devel-doc
Summary: Development documentation for Evince
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package contains documentation necessary to develop applications
using Evince library.


%prep
%setup -n %name-%version%beta

%build
%meson \
    -Dpdf=enabled \
    -Dtiff=enabled \
    -Ddjvu=enabled \
    -Ddvi=enabled \
    -Dcomics=enabled \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool dbus dbus} \
    %{subst_enable_meson_feature xps xps} \
    %{subst_enable_meson_feature ps ps} \
    %{subst_enable_meson_bool introspection introspection} \
    %{subst_enable_meson_bool nautilus nautilus} \
#    %{?_enable_multimedia:-Dmultimedia=enabled} \
%nil
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%files
%_bindir/evince*
%{?_enable_dbus:
%_libexecdir/evince*
%_prefix/lib/systemd/user/%xdg_name.service}
%{?_enable_nautilus:%_libdir/nautilus/extensions-3.0/libevince-properties-page.so}
%doc AUTHORS NEWS* README.md

%files data -f %name.lang
#%{?_enable_dbus:%_datadir/dbus-1/services/%xdg_name.Daemon.service}
%{?_enable_dbus:%_datadir/dbus-1/services/org.gnome.evince.Daemon.service}
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_desktopdir/%xdg_name-previewer.desktop
%_datadir/metainfo/%name-comicsdocument.metainfo.xml
%_datadir/metainfo/%name-djvudocument.metainfo.xml
%_datadir/metainfo/%name-pdfdocument.metainfo.xml
%{?_enable_ps:%_datadir/metainfo/%name-psdocument.metainfo.xml}
%_datadir/metainfo/%name-tiffdocument.metainfo.xml
%_datadir/metainfo/%name-xpsdocument.metainfo.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%_datadir/glib-2.0/schemas/org.gnome.Evince.gschema.xml
%_datadir/thumbnailers/evince.thumbnailer
%_iconsdir/hicolor/*/apps/*
%_man1dir/*.1*

%files -n lib%name
%_libdir/libevdocument%{lib_api_ver}.so.%{so_ver}*
%_libdir/libevview%{lib_api_ver}.so.*
# backends
%dir %_libdir/evince
%dir %_libdir/evince/%api_ver_major
%dir %_libdir/evince/%api_ver_major/backends
%_libdir/evince/%api_ver_major/backends/libcomicsdocument.so
%_libdir/evince/%api_ver_major/backends/libdjvudocument.so
%_libdir/evince/%api_ver_major/backends/libpdfdocument.so
%{?_enable_ps:%_libdir/evince/%api_ver_major/backends/libpsdocument.so}
%_libdir/evince/%api_ver_major/backends/libtiffdocument.so
%{?_enable_xps:%_libdir/evince/%api_ver_major/backends/libxpsdocument.so}
%_libdir/evince/%api_ver_major/backends/*.evince-backend
%exclude %_libdir/evince/%api_ver_major/backends/dvidocument.evince-backend

%files dvi
%_libdir/evince/%api_ver_major/backends/dvidocument.evince-backend
%_libdir/evince/%api_ver_major/backends/libdvidocument.so
%_datadir/metainfo/%name-dvidocument.metainfo.xml

%files -n lib%name-devel
%_includedir/evince
%_libdir/libevdocument%{lib_api_ver}.so
%_libdir/libevview%{lib_api_ver}.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/doc/libevdocument
%_datadir/doc/libevview
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/EvinceDocument-%api_ver.typelib
%_typelibdir/EvinceView-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/EvinceDocument-%api_ver.gir
%_girdir/EvinceView-%api_ver.gir
%endif


%changelog
