# Etersoft (c) 2007-2017
# Multiplatform spec for Korinf autobuild system (ALT Linux package spec policy)

%define modname etercifs

Name: etercifs
Version: 5.6.0
Release: alt1

Summary: Advanced Common Internet File System for Linux with Etersoft extension

Packager: Vitaly Lipatov <lav@altlinux.org>

License: GPLv2
Group: System/Kernel and hardware
Url: http://wiki.etersoft.ru/etercifs

BuildArch: noarch

Source: ftp://updates.etersoft.ru/pub/Etersoft/CIFS@Etersoft/%version/sources/tarball/%name-%version.tar
Source1: ftp://updates.etersoft.ru/pub/Etersoft/CIFS@Etersoft/%version/sources/tarball/etercifs-sources-%version.tar.xz

Conflicts: linux-cifs

BuildRequires: rpm-build-intro

Requires: gcc make

# We definitely needs mount.cifs command
Requires: cifs-utils

# We definitely have to use distr_vendor
Requires: eepm

%description
This package contains Etersoft modified CIFS kernel module
with WINE@Etersoft sharing access support.

The CIFS VFS is a virtual file system for Linux to allow access to
servers and storage appliances compliant with the SNIA CIFS
Specification version 1.0 or later.
Popular servers such as Samba, Windows 2000, Windows XP and many others
support CIFS by default.
The CIFS VFS provides some support for older servers based on the more
primitive SMB (Server Message Block) protocol (you also can use the
Linux file system smbfs as an alternative for accessing these).
CIFS VFS is designed to take advantage of advanced network file system
features such as locking, Unicode (advanced internationalization),
hardlinks, dfs (hierarchical, replicated name space), distributed
caching and uses native TCP names (rather than RFC1001, Netbios names).

Unlike some other network file systems all key network function
including authentication is provided in kernel (and changes to mount
and/or a mount helper file are not required in order to enable the CIFS
VFS). With the addition of upcoming improvements to the mount helper
(mount.cifs) the CIFS VFS will be able to take advantage of the new CIFS
URL specification though.

%if %_vendor != "alt"
%package -n dkms-etercifs
Summary: DKMS-ready CIFS Linux kernel module with Etersoft extensions
Group: System/Kernel and hardware
Requires(preun): dkms
Requires(post): dkms

Requires: etercifs = %version-%release

Buildarch: noarch

%description -n dkms-etercifs
The CIFS VFS is a virtual file system for Linux to allow access to
servers and storage appliances compliant with the SNIA CIFS
Specification version 1.0 or later.

This package contains DKMS-ready CIFS Linux kernel module with Etersoft
extensions.
%endif

%prep
%setup

%install
mkdir -p %buildroot%_sysconfdir/sysconfig/
cat <<EOF >%buildroot%_sysconfdir/sysconfig/%name.conf
# etercifs configuration file

# this options useful only for wine share using and security=share setting in smb.conf
#MOUNT_OPTIONS=user=guest,pass=,rw,iocharset=utf8,noperm,forcemand,direct,nounix
# wine options since etercifs 4.4.5 enable full wine support
MOUNT_OPTIONS=user=guest,pass=,rw,iocharset=utf8,noperm,wine

# default path for share mounting
DEFAULT_MOUNTPOINT=/net/sharebase

# disable package version checking
# CHECK_VERSION=0
EOF

%__subst "s|@DATADIR@|%_datadir/%name|g" functions.sh etercifs etermount etercifs-build
%__subst "s|@SYSCONFIGDIR@|%_sysconfdir/sysconfig|g" functions.sh etercifs etermount
%__subst "s|@INITDIR@|%_initdir|g" etercifs.service

install -D -m644 buildmodule.sh %buildroot%_datadir/%name/buildmodule.sh
install -D -m644 checkmodule.sh %buildroot%_datadir/%name/checkmodule.sh
install -D -m755 source.sh %buildroot%_datadir/%name/source.sh
install -D -m644 source.table %buildroot%_datadir/%name/source.table
install -D -m644 functions.sh %buildroot%_datadir/%name/functions.sh
install -D -m755 %name-build %buildroot%_sbindir/%name-build

cat <<EOF >%buildroot%_datadir/%name/package.conf
DATADIR=%_datadir/%name
SRC_DIR=%_usrsrc/%name-%version
MODULENAME=%name
MODULEFILENAME=%name.ko
MODULEVERSION=%version
PACKAGEVEREL=%version-%release
CHECK_VERSION=1
EOF

mkdir -p %buildroot%_sysconfdir/modprobe.d
cat <<EOF >%buildroot%_sysconfdir/modprobe.d/etersoft.conf
# wine@etersoft
install cifs /sbin/modprobe etercifs
blacklist cifs
EOF

install -D -m755 %name %buildroot%_initdir/%name
install -D -m644 %name.service %buildroot%_unitdir/%name.service
install -D -m755 %name.outformat %buildroot%_datadir/%name

cp %SOURCE1 %buildroot%_datadir/%name/

mkdir -p %buildroot%_bindir
install -m755 etermount %buildroot%_bindir/

%if %_vendor != "alt"
# dkms part
mkdir -p %buildroot%_usrsrc/%modname-%version/
cat > %buildroot%_usrsrc/%modname-%version/dkms.conf <<EOF
# DKMS file for Linux CIFS with Etersoft's extensions

PACKAGE_NAME="%modname"
PACKAGE_VERSION="%version"

BUILT_MODULE_NAME[0]="etercifs"
DEST_MODULE_LOCATION[0]="/kernel/fs/cifs/"
REMAKE_INITRD="no"
AUTOINSTALL="YES"
EOF

%post -n dkms-etercifs
if [ "$1" = 1 ]
then
  dkms add -m %modname -v %version --rpm_safe_upgrade
fi
%_initdir/%modname build

%preun -n dkms-etercifs
if [ "$1" = 0 ]
then
  dkms remove -m %modname -v %version --rpm_safe_upgrade --all
fi
%endif

%post
%post_service %name

%preun
%preun_service %name

%files
%doc README.ETER AUTHORS README TODO
%_bindir/etermount
%_sbindir/%name-build
%_initrddir/%name
%_unitdir/%name.service
%config %_sysconfdir/sysconfig/%name.conf
%config %_sysconfdir/modprobe.d/etersoft.conf
%_datadir/%name/

%if %_vendor != "alt"
%files -n dkms-etercifs
%_usrsrc/%modname-%version/dkms.conf
%endif

%changelog
