%define _unpackaged_files_terminate_build 1

Name: etckeeper
Version: 1.18.23
Release: alt1
Summary: Keep your /etc directory in VCS repository
License: GPL-2.0-or-later
Group: System/Configuration/Other
Url: https://etckeeper.branchable.com/
Vcs: https://git.joeyh.name/index.cgi/etckeeper.git
BuildArch: noarch
AutoReq: yes,noshell
Requires: coreutils diffutils findutils grep sh
Requires: git-core >= 1.6.0
Requires: perl-base
Obsoletes: %name-origin < %version-%release

Source: %name-%version.tar

%description
etckeeper is a collection of tools to let /etc be stored in a VCS
repository. It hooks into apt/yum/packman/etc to automatically commit
changes made to /etc during package upgrades. It's quite modular and
configurable, while also being simple to use if you understand the
basics of working with VCS.

%prep
%setup
sed -i '/^LOWLEVEL_PACKAGE_MANAGER=/s/=.*/=rpm/' etckeeper.conf
# No DPkg support, no empty lines.
sed -i '/^RPM::/!d' apt.conf
sed -i '/apt.apt.conf.d/s/05etckeeper/%name.conf/' Makefile
# We dont want bzr now:
sed -i '/etckeeper-bzr/d' Makefile
# There is no cruft package for ALT:
sed -i '/cruft/d' Makefile

%install
make install DESTDIR=%buildroot PYTHON=%__python3 systemddir=%_unitdir
install -Dp .gear/cron.daily %buildroot%_sysconfdir/cron.daily/%name

%check
grep -x LOWLEVEL_PACKAGE_MANAGER=rpm %buildroot%_sysconfdir/%name/etckeeper.conf
grep -x HIGHLEVEL_PACKAGE_MANAGER=apt %buildroot%_sysconfdir/%name/etckeeper.conf
find %buildroot -type f | xargs file | grep 'shell script' | cut -d: -f1 | xargs -n1 -t bash -n

%triggerin -- %name < 1.18.16
pl="/var/cache/etckeeper/packagelist.pre-install"
[ ! -e $pl ] || LC_COLLATE=C LC_ALL= sort -o $pl{,}

%files
%define _customdocdir %_docdir/%name
%doc README.md GPL CHANGELOG COPYRIGHT
%_bindir/%name
%_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%_sysconfdir/apt/apt.conf.d/%name.conf
%_man8dir/%{name}.8*
/usr/share/bash-completion/completions/%name
/usr/share/zsh/vendor-completions/_etckeeper
%_cachedir/%name
%_sysconfdir/cron.daily/%name
%_unitdir/%{name}.*

%changelog
