%global import_path github.com/etcd-io/etcd

%global _unpackaged_files_terminate_build 1

%define git_commit e72f3c2

Name: etcd-for-kubernetes1.32
Version: 3.5.24
Release: alt1

Summary: A highly-available key value store for shared configuration
License: Apache-2.0
Group: System/Servers
Url: https://etcd.io
Vcs: https://github.com/etcd-io/etcd

ExclusiveArch: %go_arches

Source0: %name-%version.tar

Provides: etcd-for-kubernetes = %EVR
Conflicts: etcd-for-kubernetes
Conflicts: etcd

BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.24

%description
Etcd is a distributed key value store that provides a reliable way to store data
across a cluster of machines.
This package contains etcd version needed for kubernetes container image.

%prep
%setup

%build
export CGO_ENABLED=0
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export LDFLAGS="-X go.etcd.io/etcd/api/v3/version.GitSHA=%git_commit"

%golang_prepare

cd .build/src/%import_path

%golang_build \
    server \
    etcdctl \
#

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install

mkdir -p -- %buildroot%_sbindir
mv -f -- %buildroot%_bindir/server %buildroot%_sbindir/etcd

%files
%_bindir/etcdctl
%_sbindir/etcd

%changelog
