%def_disable snapshot
%set_verify_elf_method unresolved=relaxed

%define _libexecdir %_prefix/libexec

%define ver_major 49
%define beta %nil
%define xdg_name org.gnome.Epiphany

%def_enable man
# 13/15 Web view test              FAIL
# libEGL warning: DRI3 error: Could not get DRI3 device
# libEGL warning: Ensure your X server supports DRI3 to get accelerated rendering
# bwrap: No permissions to creating new namespace, 
# likely because the kernel does not allow non-privileged user namespaces...
%def_disable check

Name: epiphany
Version: %ver_major.2
Release: alt1%beta

Summary: Epiphany is a GNOME web browser.
Summary(ru_RU.UTF-8): Epiphany - интернет-браузер для графической оболочки GNOME.
Group: Networking/WWW
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Web

Vcs: https://gitlab.gnome.org/GNOME/epiphany.git

%if_enabled snapshot
Source: %name-%version%beta.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%endif

Provides: webclient
Provides: /usr/bin/x-www-browser
Obsoletes: %name-extensions

%add_findprov_lib_path %_libdir/%name

%define glib_ver 2.74.0
%define webki_api_ver 6.0
%define webkit_ver 2.43.4
%define gtk4_ver 4.19
%define adwaita_ver 1.8
%define gcr4_ver 3.9.0
%define nettle_ver 3.4
%define libxml2_ver 2.6.12
%define soup3_ver 2.99.4
%define secret_ver 0.19
%define iso_codes_ver 0.35
%define sqlite_ver 3.24
%define portal_ver 0.6

Requires: %name-data = %version-%release indexhtml iso-codes

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ blueprint-compiler
BuildRequires: yelp-tools /usr/bin/appstreamcli desktop-file-utils
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: gcr4-libs-devel >= %gcr4_ver
BuildRequires: pkgconfig(gstreamer-1.0)
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: libsqlite3-devel >= %sqlite_ver
BuildRequires: libnettle-devel >= %nettle_ver
BuildRequires: iso-codes-devel >= %iso_codes_ver
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libjson-glib-devel
BuildRequires: libportal-gtk4-devel >= %portal_ver
BuildRequires: libarchive-devel
BuildRequires: libsoup3.0-devel >= %soup3_ver pkgconfig(webkitgtk-%webki_api_ver) >= %webkit_ver
%{?_enable_man:BuildRequires: /usr/bin/rst2man}
%{?_enable_chek:BuildRequires: bubblewrap xdg-dbus-proxy}

%description
Epiphany is a GNOME web browser based on the Webkit rendering engine.

%description -l ru_RU.UTF-8
Epiphany - интернет-браузер для графической оболочки GNOME, основанный на
движке отрисовки страниц Webkit.

%package data
Summary: Epiphany data files
Group: Networking/WWW
BuildArch: noarch

%description data
Epiphany is a GNOME web browser based on the Webkit rendering engine.
This package contains common noarch files needed for Epiphany.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{?_subst_enable_meson_feature man man-pages}
%nil
%meson_build

%install
%meson_install
cat << _EOF_\
> %buildroot/%_datadir/glib-2.0/schemas/org.gnome.Epiphany.gschema.override
[org.gnome.Epiphany]
homepage-url='file:///usr/share/doc/HTML/index.html'
_EOF_

mkdir -p %buildroot/%_altdir
cat << _EOF_ \
> %buildroot/%_altdir/%name
%_bindir/x-www-browser	%_bindir/%name 60
_EOF_

%find_lang --with-gnome --output=%name.lang %name

%check
export XDG_RUNTIME_DIR=${PWD}
xvfb-run %__meson_test

%files
%_bindir/%name
%_altdir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/ephy-profile-migrator
%_libexecdir/%name-search-provider
%_libexecdir/%name-webapp-provider
%dir %_libdir/%name
%_libdir/%name/*.so
%dir %_libdir/%name/web-process-extensions
%_libdir/%name/web-process-extensions/libephywebprocessextension.so
%_desktopdir/%xdg_name.desktop
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc NEWS README* TODO

%files data -f %name.lang
%_datadir/%name
%_datadir/dbus-1/services/*
%config %_datadir/glib-2.0/schemas/org.gnome.epiphany.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Epiphany.enums.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Epiphany.gschema.override
%{?_enable_man:%_man1dir/*}
%_datadir/gnome-shell/search-providers/%xdg_name.SearchProvider.ini
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg

%changelog
