# gnulib as submodule
%def_disable snapshot
%define _name enchant
%define ver_major 2.8
%define api_ver 2

%def_enable aspell
%def_enable hspell
%def_enable voikko
%def_disable relocatable
%def_enable check

Name: %_name%api_ver
Version: %ver_major.14
Release: alt1
Epoch: 1

Summary: An Enchanting Spell Checking Program
Group: Text tools
License: LGPL-2.1-or-later
Url: https://rrthomas.github.io/enchant

Vcs: https://github.com/rrthomas/enchant.git

%if_disabled snapshot
Source: https://github.com/rrthomas/enchant/releases/download/v%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif
Patch1: enchant-2.8.7-alt-add-myspell-dicts-dir-to-hunspell.patch

Requires:  lib%name = %EVR

%define glib_ver 2.76

BuildRequires: vala-tools gcc-c++
BuildRequires: libgio-devel >= %glib_ver libhunspell-devel
BuildRequires: groff
%{?_enable_aspell:BuildRequires: libaspell-devel}
%{?_enable_hspell:BuildRequires: libhspell-devel}
%{?_enable_voikko:BuildRequires: libvoikko-devel}
%{?_enable_check:BuildRequires: libunittest-cpp-devel}

%description
This package contains simple programs that wrap other spell checking backends,
including an Ispell compatible script.

%package -n lib%name
Summary: An Enchanting Spell Checking Library
Group: System/Libraries

%description -n lib%name
A library that wraps other spell checking backends.

%package -n lib%name-devel
Summary: Support files necessary to compile applications with libenchant.
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
Libraries, headers, and support files necessary to compile applications
using libenchant.

%prep
%setup -n %_name-%version
%patch1 -p1
# relax autoconf version
sed -i 's|\(AC_PREREQ(\[2.\)71|\169|' configure.ac

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static \
    --disable-gcc-warnings \
    %{?_enable_check:--enable-relocatable}
%nil
%make_build

%install
%makeinstall_std

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%make -k check VERBOSE=1

%files
%_bindir/*
%_man1dir/*
%_man5dir/*
%doc src/*.html

%files -n lib%name
%_libdir/*.so.*
%dir %_libdir/%_name-%api_ver
%_libdir/%_name-%api_ver/*.so
%_datadir/%_name-%api_ver/
%doc AUTHORS README* NEWS

%files -n lib%name-devel
%_includedir/%_name-%api_ver/
%_libdir/*.so
%_pkgconfigdir/%_name-%api_ver.pc

%changelog
