%define _unpackaged_files_terminate_build 1
%def_without texmf
%define ModeName auctex
%define _aucstatedir %_localstatedir/%ModeName

Name: emacs-mode-auctex
Version: 14.1.0
Release: alt1

Summary: Enhanced LaTeX mode for GNU Emacs
License: GPLv3
Group: Editors
Url: http://www.gnu.org/software/auctex/index.html
Vcs: git://git.git.savannah.gnu.org/auctex.git
BuildArch: noarch

Source0: %name-%version.tar

Source10: %name-11.10-info.ALT

Patch1: auctex-14.1.0-alt-path-for-install-info.patch

Requires: common-licenses
%if_with texmf
Requires: texmf-latex-preview
%else
Requires: tex(preview.sty)
%endif

Provides: preview-latex
Provides: emacs-preview-latex = %version-%release
Obsoletes: emacs-preview-latex < 11.82
Obsoletes: auctex

%define require_compiler %(rpm -qf "$(which %emacsbin)" \
                               --queryformat=%%{NAME} 2> /dev/null)

BuildRequires(pre): rpm-build-tex
BuildRequires(pre): rpm-build-emacs
BuildRequires: emacs-common
BuildRequires: emacs-nox
BuildRequires: makeinfo
BuildRequires: texlive-dist

%description
AUC TeX is a comprehensive, customizable, integrated environment for
writing, editing and processing input files for LaTeX using GNU Emacs.
This mode also supports graphic preview for formulas and figures.

(Emacs Lisp code is principally byte-compiled,
install emacs-mode-auctex-el for sources.)

%package el
Summary: The Emacs Lisp sources for bytecode files in emacs-mode-auctex
Group: Development/Other

Requires: emacs-mode-auctex = %version-%release
Provides: emacs-preview-latex-el = %version-%release

%description el
emacs-mode-auctex-el contains the Emacs Lisp sources for the bytecode
included in the emacs-mode-auctex package, that extends Emacs.

You need to install emacs-mode-auctex-el only if you intend to modify
any of the emacs-mode-auctex code or see some Lisp examples.

#FIXME: fix install to texlive
%package doc
Summary: Documentation for emacs-mode-auctex
Group: Editors

Requires: emacs-mode-auctex
Requires: /usr/share/texmf/doc

%description -n emacs-mode-auctex-doc
Does your neck hurt from turning between previewer windows and the
source too often? This Elisp/LaTeX package will render your displayed
LaTeX equations right into the editing window where they belong.

This package contains the documentation.

%package -n texmf-latex-preview
Summary: Preview style for TeX subsystems
Group: Development/Other
BuildArch: noarch

%description -n texmf-latex-preview
emacs-mode-auctex-el contains the Emacs Lisp sources for the bytecode
included in the emacs-mode-auctex package, that extends Emacs.

You need to install emacs-mode-auctex-el only if you intend to modify
any of the emacs-mode-auctex code or see some Lisp examples.

%prep
%setup
%autopatch -p1

%build
%make_build

# Build documentation in various formats

#pushd doc
#make extradist
#popd

%install
# create target directories
install -d $RPM_BUILD_ROOT{%_emacslispdir/site-start.d,%_infodir}
mkdir -p $RPM_BUILD_ROOT%_emacslispdir/auctex/
mkdir -p $RPM_BUILD_ROOT%_emacslispdir/auctex/style/
mkdir -p $RPM_BUILD_ROOT%_emacslispdir/auctex/images/
mkdir -p %buildroot%_texmfmain/tex/latex/preview/preview.sty
mkdir -p %buildroot%_aucstatedir

# copy byte-code files
install -m 644 *.elc %buildroot/%_emacslispdir/auctex
install -m 644 style/*.elc %buildroot%_emacslispdir/auctex/style/
install -m 644 style/*.el %buildroot%_emacslispdir/auctex/style/
#usr/share/emacs/site-lisp/auctex/style/*.el

# copy lisp-code files
mkdir -p %buildroot/%_emacslispdir/auctex
mkdir -p %buildroot/%_emacs_sitestart_dir
install -m 644 *.el %buildroot/%_emacslispdir/auctex/

install -m 644 tex-site.el %buildroot%_emacslispdir/tex-site.el
install -m 644 auctex.el %buildroot%_emacs_sitestart_dir/auctex.el
install -m 644 auctex.el \
        %buildroot/%_emacslispdir/site-start.d/auctex.el
install -m 644 tests/japanese/preview-latex.el \
        %buildroot%_emacslispdir/site-start.d/preview-latex.el
install -m 644 latex/preview.sty \
        %buildroot%_texmfmain/tex/latex/preview/preview.sty

# documentation
install -Dm 644 doc/*.info -t %buildroot/%_infodir

# install ALT's info:
install -m0644 %SOURCE10 ALT-packaging-info

# The license:
ln -s -f %_licensedir/GPL-2 COPYING

mkdir -p $RPM_BUILD_ROOT/%_docdir/emacs-mode-auctex-%version/

# Create these .nosearch files to keep the directories from the elisp
# search path
touch %buildroot%_emacslispdir/auctex/.nosearch
touch %buildroot%_emacslispdir/auctex/style/.nosearch

%global _customdocdir %_defaultdocdir/auctex

%files
%_infodir/*
%_sysconfdir/emacs/site-start.d/auctex.el
%_emacslispdir/*.el
%_emacslispdir/auctex/*.elc
%_emacslispdir/auctex/.nosearch
%_emacslispdir/auctex/style/*.elc
%_emacslispdir/auctex/style/.nosearch
%_emacslispdir/site-start.d/auctex.el
%_emacslispdir/site-start.d/preview-latex.el
%exclude %_texmfmain/tex/latex/preview

%files el
%_emacslispdir/auctex/*.el
%_emacslispdir/auctex/style/*.el

%files -n emacs-mode-auctex-doc
%doc --no-dereference COPYING
%doc ChangeLog*
%doc ALT-packaging-info

%if_with texmf
%files -n texmf-latex-preview
%_texmfmain/tex/latex/preview
%endif

%changelog
