%def_disable sepplay

%define _unpackaged_files_terminate_build 1
Name: eepm
Version: 3.64.41
Release: alt1

Summary: Etersoft EPM package manager

License: AGPL-3.0+
Group: System/Configuration/Packaging
Url: http://wiki.etersoft.ru/EPM

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/Etersoft/eepm/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

BuildArchitectures: noarch

%if "%_vendor" == "alt"
Obsoletes: epm
Provides: epm = %EVR

# FIXHERE: Replace with target platform package manager
Requires: apt rpm

Conflicts: rpmbasefix

%endif

%if_disabled sepplay
Conflicts: eepm-play < %EVR
Provides: eepm-play = %EVR
%endif

AutoProv:no
AutoReq:no

# TODO: drop gzip (used in some pack.d/repack.d/play.d)
Requires: coreutils diffutils findutils file gawk grep gzip less sed bash termutils

%description
Etersoft EPM is the package manager for any platform
and any platform version. It provides
universal interface to any package manager.
Can be useful for system administrators working
with various distros.

See detailed description here: http://wiki.etersoft.ru/EPM

%package repack
Summary: Etersoft EPM package manager (repack requirements)
Group: System/Configuration/Packaging
Requires: %name = %EVR
Requires: alien cpio dpkg patchelf p7zip
%if "%_vendor" == "alt"
Requires: eepm-rpm-build
%else
Requires: /usr/bin/rpmbuild
%endif

%description repack
This package has requirements needed for using epm repack on ALT
(repack rpm packages and repack/install deb packages).

See https://bugzilla.altlinux.org/show_bug.cgi?id=34308 for
a discussion about extra requirements.


%package play
Summary: Etersoft EPM package manager (epm play command)
Group: System/Configuration/Packaging
Requires: %name = %EVR

AutoProv:no
AutoReq:no

%description play
This package contains epm play command for install
packages from vendor's sites.

See https://bugzilla.altlinux.org/48465 for
a discussion about epm play security.

%prep
%setup

%build
make -C po

%install
%make_install install DESTDIR=%buildroot \
	datadir=%_datadir bindir=%_bindir mandir=%_mandir \
	sysconfdir=%_sysconfdir version=%version-%release
%make_install -C po install DESTDIR=%buildroot \
	datadir=%_datadir
%find_lang %name
cat >%buildroot/%_bindir/rpmbasefix <<EOF
#!/bin/sh -x
exec epm --verbose fix
EOF
%if "%_vendor" == "alt"
    chmod 0755 %buildroot/%_bindir/rpmbasefix
%else
    rm -v %buildroot%_bindir/rpmbasefix
%endif

%files -f %name.lang
%doc README.md TODO LICENSE
%dir %_sysconfdir/eepm/
%dir %_sysconfdir/eepm/conf.d/
%dir %_sysconfdir/eepm/pack.d/
%dir %_sysconfdir/eepm/repack.d/
%dir %_sysconfdir/eepm/prescription.d/
%dir %_sysconfdir/eepm/desktop.d/
%config(noreplace) %_sysconfdir/eepm/eepm.conf
%config(noreplace) %_sysconfdir/eepm/serv.conf
%config(noreplace) %_sysconfdir/eepm/*.list
%config(noreplace) %_sysconfdir/eepm/repack.d/*
%config(noreplace) %_sysconfdir/eepm/pack.d/*
%config(noreplace) %_sysconfdir/eepm/prescription.d/*
%config(noreplace) %_sysconfdir/eepm/desktop.d/*
%_bindir/epm*
%_bindir/eepm
%_bindir/serv
%_bindir/distr_info
%_bindir/esu
%if "%_vendor" == "alt"
%_bindir/rpmbasefix
%endif
%dir /var/lib/eepm/
%dir /var/cache/eepm/
%_man1dir/*
%_datadir/%name/
%if_enabled sepplay
%exclude %_bindir/epmp
%exclude %_datadir/%name/epm-play
%else
%dir %_sysconfdir/eepm/play.d/
%config(noreplace) %_sysconfdir/eepm/play.d/*
%endif
%_sysconfdir/bash_completion.d/serv
%_sysconfdir/bash_completion.d/eepm
%_datadir/zsh/Completion/Linux/_serv
%_datadir/zsh/Completion/Linux/_eepm
%_datadir/fish/vendor_completions.d/*pm*.fish

%files repack

%if_enabled sepplay
%files play
%_bindir/epmp
%_datadir/%name/epm-play
%dir %_sysconfdir/eepm/play.d/
%config(noreplace) %_sysconfdir/eepm/play.d/*
%endif

%changelog
