%def_disable snapshot
%define __isa_bits %(s="%_lib"; s=${s#lib}; echo "${s:-32}")

%define _name easyeffects
%define xdg_name com.github.wwmm.%_name

Name: %_name-qt
Version: 8.0.5
Release: alt1

Summary: Audio effects for Pipewire applications
License: GPL-3.0-or-later
Group: Sound
Url: https://github.com/wwmm/easyeffects

Vcs: https://github.com/wwmm/easyeffects.git

%if_disabled snapshot
Source: %url/archive/v%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

# no 32-bit qt6-webengine
ExcludeArch: %ix86

Conflicts: %_name < 8.0.0

%define pw_api_ver 0.3
%define pw_ver 0.3.58
%define lv2_ver 1.18.2
%define lilv_ver 0.22
%define calf_ver 0.90.1
%define lsp_ver 1.2.10

Requires: pipewire >= %pw_ver dconf
Requires: calf calf-plugins >= %calf_ver
Requires: lv2-lsp-plugins >= %lsp_ver
Requires: lv2-mda-plugins
Requires: lv2-zam-plugins
%ifnarch %ix86
Requires: ladspa-deepfilternet-plugins
%endif
Requires: kf6-kirigami-addons
Requires: xdg-desktop-portal-kde
Requires: libqtgraphs-qt6

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++ extra-cmake-modules
BuildRequires: desktop-file-utils /usr/bin/appstreamcli
BuildRequires: pkgconfig(libpipewire-%pw_api_ver) >= %pw_ver
BuildRequires: nlohmann-json-devel
BuildRequires: pkgconfig(gsl)
BuildRequires: lv2-devel >= %lv2_ver
BuildRequires: ladspa_sdk
BuildRequires: libsndfile-devel libsamplerate-devel libfftw3-devel
BuildRequires: libbs2b-devel
BuildRequires: liblilv-devel >= %lilv_ver
BuildRequires: libebur128-devel
BuildRequires: pkgconfig(speexdsp)
BuildRequires: pkgconfig(rnnoise)
BuildRequires: pkgconfig(speex)
BuildRequires: pkgconfig(soundtouch)
BuildRequires: zita-convolver-devel
BuildRequires: libtbb-devel
BuildRequires: libgio-devel
BuildRequires: libwebrtc-audio-processing-2-devel
BuildRequires: libvulkan-devel
# QT
BuildRequires: pkgconfig(Qt6Core)
BuildRequires: pkgconfig(Qt6DBus)
BuildRequires: pkgconfig(Qt6Graphs)
BuildRequires: pkgconfig(Qt6Gui)
BuildRequires: pkgconfig(Qt6Network)
BuildRequires: pkgconfig(Qt6Qml)
BuildRequires: pkgconfig(Qt6Quick)
BuildRequires: pkgconfig(Qt6QuickControls2)
BuildRequires: pkgconfig(Qt6Widgets)
BuildRequires: pkgconfig(Qt6WebEngineQuick)
BuildRequires: pkgconfig(libportal-qt6)
# KDE
#BuildRequires: pkgconfig(KF6ConfigCore)
#BuildRequires: pkgconfig(KF6ConfigWidgets)
#BuildRequires: pkgconfig(KF6CoreAddons)
#BuildRequires: pkgconfig(KF6I18n)
#BuildRequires: pkgconfig(KF6IconThemes)
#BuildRequires: pkgconfig(KF6Kirigami)
#BuildRequires: pkgconfig(KF6KirigamiAddons)
#BuildRequires: pkgconfig(KF6QQC2DesktopStyle)
BuildRequires: kf6-kconfigwidgets-devel
BuildRequires: kf6-kcolorscheme-devel
BuildRequires: kf6-kcoreaddons-devel
BuildRequires: kf6-kiconthemes-devel
BuildRequires: kf6-ki18n-devel
BuildRequires: kf6-kirigami-devel
BuildRequires: kf6-kirigami-addons-devel kf6-kirigami-addons
BuildRequires: kf6-qqc2-desktop-style-devel

%description
This application was formerly known as PulseEffects, but it was
renamed to EasyEffects after it started to use GTK4 and GStreamer
usage was replaced by native PipeWire filters. And eventually the whole
application was ported from GTK4 to a combination of Qt, QML and
KDE/Kirigami frameworks.

%prep
%setup -n %_name-%version
%if "%__isa_bits" == "32"
sed -i 's/tbb/tbb32/' src/meson.build
%endif

%ifarch %e2k
# -isystem/usr/include/ breaks the compiler's includes
sed -i "s/, include_type: 'system'//" src/meson.build
sed -i -E 's/plugin( .*map\(\)) \| std::views.*$/fix\1){auto\&plugin=fix.second;/' \
    src/plugins_box.cpp
%endif

%build
%add_optflags %(pkg-config --cflags gio-2.0)
%cmake
%cmake_build

%install
%cmake_install
%find_lang --with-gnome --output=%name.lang %_name

%files -f %name.lang
%_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* CHANGELOG.*

%changelog
