%def_disable snapshot

%define ver_major 1.0
%define rdn_name app.drey.EarTag

%def_enable check

Name: eartag
Version: %ver_major.2
Release: alt1.1

Summary: Small and simple audio file tag editor
License: MIT
Group: Sound
Url: https://gitlab.gnome.org/World/eartag

Vcs: https://gitlab.gnome.org/World/eartag.git

%if_disabled snapshot
Source: %url/-/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

%define gtk_ver 4.18
%define adwaita_ver 1.7

%add_python3_path %_datadir/%name

Requires: python3-module-pygobject3
Requires: typelib(Adw) = 1
Requires: python3(acoustid)

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson blueprint-compiler
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver typelib(Adw)
%{?_enable_check:BuildRequires: python3(pytest)
BuildRequires: python3-module-pygobject3
BuildRequires: python3(mutagen) python3(magic) python3-module-Pillow
BuildRequires: python3(acoustid)}
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils
BuildRequires: python3(aiofiles) python3(xxhash)
BuildRequires: python3(filetype) python3(aiohttp)
BuildRequires: python3(aiohttp_retry)
BuildRequires: python3(pytest-asyncio)}

%description
%summary

%prep
%setup
# ERROR: '"function"' is not a valid asyncio_default_fixture_loop_scope.
sed -i 's|"function"|function|' pytest.ini

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %rdn_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_desktopdir/%rdn_name.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{rdn_name}*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*

%changelog
