Name: duplicity
Version: 3.0.4.1
Release: alt1

Summary: Untrusted/encrypted backup using rsync algorithm

Group: Archiving/Backup
Url: https://gitlab.com/duplicity/duplicity
License: GPLv2

# Source-url: https://gitlab.com/duplicity/duplicity/-/archive/rel.%version/duplicity-rel.%version.tar.bz2
Source: %name-%version.tar

AutoProv:no

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(setuptools_scm)
BuildRequires: librsync-devel

# No required by default (Dropbox)
%add_python3_req_skip dropbox
# No required by default (OpenStack)
%add_python3_req_skip pyrax
# No required by default (box)
%add_python3_req_skip boxsdk

Requires: gnupg

# for check
# generated by 'epm restore --dry-run' from duplicity/setup.py install_requires
BuildRequires: gnupg
%py3_use fasteners

%description
Duplicity incrementally backs up files and directory by encrypting
tar-format volumes with GnuPG and uploading them to a remote (or
local) file server.  In theory many remote backends are possible;
right now local, ssh/scp, ftp, and rsync backends are written.
Because duplicity uses librsync, the incremental archives are space
efficient and only record the parts of files that have changed since
the last backup.  Currently duplicity supports deleted files, full
unix permissions, directories, symbolic links, fifos, etc., but not
hard links.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install
rm -v %buildroot%python3_sitelibdir/%name/backends/_testbackend.py

%find_lang %name

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
# check VersionedCopy in setup.py
%buildroot%_bindir/duplicity -V | grep "%version"

%files -f %name.lang
%doc CHANGELOG.md README*
#%_bindir/rdiffdir
%_bindir/duplicity
%_man1dir/*
%python3_sitelibdir/%name/
%python3_sitelibdir/%name-*.egg-info

%changelog
